"use strict";
'use strict';
var type_1 = require("../type");
function resolveYamlBoolean(data) {
    if (null === data) {
        return false;
    }
    var max = data.length;
    return (max === 4 && (data === 'true' || data === 'True' || data === 'TRUE')) ||
        (max === 5 && (data === 'false' || data === 'False' || data === 'FALSE'));
}
function constructYamlBoolean(data) {
    return data === 'true' ||
        data === 'True' ||
        data === 'TRUE';
}
function isBoolean(object) {
    return '[object Boolean]' === Object.prototype.toString.call(object);
}
module.exports = new type_1.Type('tag:yaml.org,2002:bool', {
    kind: 'scalar',
    resolve: resolveYamlBoolean,
    construct: constructYamlBoolean,
    predicate: isBoolean,
    represent: {
        lowercase: function (object) { return object ? 'true' : 'false'; },
        uppercase: function (object) { return object ? 'TRUE' : 'FALSE'; },
        camelcase: function (object) { return object ? 'True' : 'False'; }
    },
    defaultStyle: 'lowercase'
});
//# sourceMappingURL=bool.js.map