/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.core.plugin.Format;
import io.cucumber.core.plugin.Formats;
import io.cucumber.core.plugin.UTF8PrintWriter;
import io.cucumber.plugin.ColorAware;
import io.cucumber.plugin.ConcurrentEventListener;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.Status;
import io.cucumber.plugin.event.StepDefinedEvent;
import io.cucumber.plugin.event.TestRunFinished;
import io.cucumber.plugin.event.TestStepFinished;
import java.io.OutputStream;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public final class UnusedStepsSummaryPrinter
implements ColorAware,
ConcurrentEventListener {
    private final Map<String, String> registeredSteps = new TreeMap<String, String>();
    private final Set<String> usedSteps = new TreeSet<String>();
    private final UTF8PrintWriter out;
    private Formats formats = Formats.ansi();

    public UnusedStepsSummaryPrinter(OutputStream out) {
        this.out = new UTF8PrintWriter(out);
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(StepDefinedEvent.class, this::handleStepDefinedEvent);
        publisher.registerHandlerFor(TestStepFinished.class, this::handleTestStepFinished);
        publisher.registerHandlerFor(TestRunFinished.class, event -> this.finishReport());
    }

    private void handleStepDefinedEvent(StepDefinedEvent event) {
        this.registeredSteps.put(event.getStepDefinition().getLocation(), event.getStepDefinition().getPattern());
    }

    private void handleTestStepFinished(TestStepFinished event) {
        String codeLocation = event.getTestStep().getCodeLocation();
        if (codeLocation != null) {
            this.usedSteps.add(codeLocation);
        }
    }

    private void finishReport() {
        this.usedSteps.forEach(this.registeredSteps::remove);
        if (this.registeredSteps.isEmpty()) {
            return;
        }
        Format format = this.formats.get(Status.UNUSED.name().toLowerCase(Locale.ROOT));
        this.out.println(format.text(this.registeredSteps.size() + " Unused steps:"));
        for (Map.Entry<String, String> entry : this.registeredSteps.entrySet()) {
            String location = entry.getKey();
            String pattern = entry.getValue();
            this.out.println(format.text(location) + " # " + pattern);
        }
        this.out.close();
    }

    public void setMonochrome(boolean monochrome) {
        this.formats = monochrome ? Formats.monochrome() : Formats.ansi();
    }
}

