/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.api;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Node;

public interface ElementIterable<T extends Element>
extends Iterable<T> {
    public static final ElementIterable EMPTY = new ElementIterableEmpty();

    @Override
    public Iterator<T> iterator();

    public T[] toArray();

    public Collection<T> toCollection();

    public Set<T> toSet();

    public void doBreak();

    public static final class ElementIterableEmpty
    implements Iterator<Element>,
    ElementIterable {
        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Element next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public Iterator<Element> iterator() {
            return this;
        }

        public Element[] toArray() {
            return new Node[0];
        }

        public Collection<Element> toCollection() {
            return Collections.EMPTY_LIST;
        }

        public Set<Element> toSet() {
            return Collections.EMPTY_SET;
        }

        @Override
        public void doBreak() {
        }
    }
}

