/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import jspecview.common.Annotation;
import jspecview.common.Coordinate;
import jspecview.common.Spectrum;

public class Measurement
extends Annotation {
    public static final int PT_XY1 = 1;
    public static final int PT_XY2 = 2;
    public static final int PT_INT_LABEL = -5;
    public static final int PT_ON_LINE1 = -1;
    public static final int PT_ON_LINE2 = -2;
    public static final int PT_ON_LINE = 0;
    private Coordinate pt2 = new Coordinate();
    protected double value;

    public Measurement setM1(double x, double y, Spectrum spec) {
        this.setA(x, y, spec, "", false, false, 0, 6);
        this.setPt2(this.getXVal(), this.getYVal());
        return this;
    }

    public Measurement copyM() {
        Measurement m = new Measurement();
        m.setA(this.getXVal(), this.getYVal(), this.spec, this.text, false, false, this.offsetX, this.offsetY);
        m.setPt2(this.pt2.getXVal(), this.pt2.getYVal());
        return m;
    }

    public Measurement setPt2(Spectrum spec, boolean doSetPt2) {
        this.spec = spec;
        if (doSetPt2) {
            this.setPt2(this.getXVal(), this.getYVal());
        }
        return this;
    }

    public void setPt2(double x, double y) {
        this.pt2.setXVal(x);
        this.pt2.setYVal(y);
        this.value = Math.abs(x - this.getXVal());
        this.text = this.spec.setMeasurementText(this);
    }

    public Spectrum getSpectrum() {
        return this.spec;
    }

    public void setValue(double value) {
        this.value = value;
        this.text = this.spec.setMeasurementText(this);
    }

    public double getValue() {
        return this.value;
    }

    public double getXVal2() {
        return this.pt2.getXVal();
    }

    public double getYVal2() {
        return this.pt2.getYVal();
    }

    @Override
    public void addSpecShift(double dx) {
        this.setXVal(this.getXVal() + dx);
        this.pt2.setXVal(this.pt2.getXVal() + dx);
    }

    public void setYVal2(double y2) {
        this.pt2.setYVal(y2);
    }

    public boolean overlaps(double x1, double x2) {
        return Math.min(this.getXVal(), this.getXVal2()) < Math.max(x1, x2) && Math.max(this.getXVal(), this.getXVal2()) > Math.min(x1, x2);
    }

    @Override
    public String toString() {
        return "[" + this.getXVal() + "," + this.pt2.getXVal() + "]";
    }
}

