/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JPanel;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationToChildReference;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.dialogs.DeleteFromRelationConfirmationDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;

public final class DeleteAction
extends JosmAction {
    public static final DeleteCommand.DeletionCallback defaultDeletionCallback = new DeleteCommand.DeletionCallback(){

        @Override
        public boolean checkAndConfirmOutlyingDelete(Collection<? extends OsmPrimitive> primitives, Collection<? extends OsmPrimitive> ignore) {
            return DeleteAction.checkAndConfirmOutlyingDelete(primitives, ignore);
        }

        @Override
        public boolean confirmRelationDeletion(Collection<Relation> relations) {
            return DeleteAction.confirmRelationDeletion(relations);
        }

        @Override
        public boolean confirmDeletionFromRelation(Collection<RelationToChildReference> references) {
            return this.confirmDeletionFromRelation(references, Collections.emptyList());
        }

        @Override
        public boolean confirmDeletionFromRelation(Collection<RelationToChildReference> references, Collection<Pair<Relation, Boolean>> parentsToDelete) {
            DeleteFromRelationConfirmationDialog dialog = DeleteFromRelationConfirmationDialog.getInstance();
            dialog.getModel().populate(references);
            dialog.getDeletedRelationsModel().populate(parentsToDelete);
            dialog.setVisible(true);
            return !dialog.isCanceled();
        }
    };

    public DeleteAction() {
        super(I18n.tr("Delete", new Object[0]), "dialogs/delete", I18n.tr("Delete selected objects.", new Object[0]), Shortcut.registerShortcut("system:delete", I18n.tr("Edit: {0}", I18n.tr("Delete", new Object[0])), 127, 5003), true);
        this.setHelpId(HelpUtil.ht("/Action/Delete"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MapFrame map = MainApplication.getMap();
        if (!this.isEnabled() || !map.mapView.isActiveLayerVisible()) {
            return;
        }
        map.mapModeDelete.doActionPerformed(e);
    }

    @Override
    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.updateEnabledStateOnModifiableSelection(selection);
    }

    public static boolean checkAndConfirmOutlyingDelete(Collection<? extends OsmPrimitive> primitives, Collection<? extends OsmPrimitive> ignore) {
        return Boolean.TRUE.equals(GuiHelper.runInEDTAndWaitAndReturn(() -> DeleteAction.checkAndConfirmOutlyingOperation("delete", I18n.tr("Delete confirmation", new Object[0]), I18n.tr("You are about to delete nodes which can have other referrers not yet downloaded.<br>This can cause problems because other objects (that you do not see) might use them.<br>Do you really want to delete?", new Object[0]), I18n.tr("You are about to delete incomplete objects.<br>This will cause problems because you don''t see the real object.<br>Do you really want to delete?", new Object[0]), primitives, ignore)));
    }

    public static boolean confirmRelationDeletion(Collection<Relation> relations) {
        if (relations.stream().allMatch(AbstractPrimitive::isNew)) {
            return true;
        }
        JPanel msg = new JPanel(new GridBagLayout());
        msg.add(new JMultilineLabel("<html>" + I18n.trn("You are about to delete {0} relation: {1}<br/>This step is rarely necessary and cannot be undone easily after being uploaded to the server.<br/>Do you really want to delete?", "You are about to delete {0} relations: {1}<br/>This step is rarely necessary and cannot be undone easily after being uploaded to the server.<br/>Do you really want to delete?", relations.size(), relations.size(), DefaultNameFormatter.getInstance().formatAsHtmlUnorderedList(relations, 20)) + "</html>"));
        return ConditionalOptionPaneUtil.showConfirmationDialog("delete_relations", MainApplication.getMainFrame(), msg, I18n.tr("Delete relation?", new Object[0]), 0, 3, 0);
    }
}

