/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.routines.AbstractValidator;
import org.openstreetmap.josm.data.validation.routines.EmailValidator;
import org.openstreetmap.josm.data.validation.routines.UrlValidator;
import org.openstreetmap.josm.tools.I18n;

public class InternetTags
extends Test.TagTest {
    public static final int INVALID_URL = 3301;
    public static final int INVALID_EMAIL = 3302;
    private static final String[] URL_KEYS = new String[]{"url", "source:url", "website", "contact:website", "heritage:website", "source:website"};
    private static final String[] EMAIL_KEYS = new String[]{"email", "contact:email"};

    public InternetTags() {
        super(I18n.tr("Internet tags", new Object[0]), I18n.tr("Checks for errors in internet-related tags.", new Object[0]));
    }

    private boolean doTest(OsmPrimitive p, String k, String[] keys, AbstractValidator validator, int code) {
        for (String i : keys) {
            if (!i.equals(k)) continue;
            return this.errors.addAll(this.validateTag(p, k, validator, code));
        }
        return false;
    }

    public List<TestError> validateTag(OsmPrimitive p, String k, AbstractValidator validator, int code) {
        return this.doValidateTag(p, k, null, validator, code);
    }

    private List<TestError> doValidateTag(OsmPrimitive p, String k, String v, AbstractValidator validator, int code) {
        ArrayList<TestError> errors = new ArrayList<TestError>();
        String values = v != null ? v : p.get(k);
        for (String value : values.split(";", -1)) {
            if (validator.isValid(value)) continue;
            Supplier<Command> fix = null;
            String errMsg = validator.getErrorMessage();
            if (I18n.tr("URL contains an invalid protocol: {0}", new Object[]{null}).equals(errMsg)) {
                String proto = validator instanceof EmailValidator ? "mailto://" : "http://";
                return this.doValidateTag(p, k, proto + value, validator, code);
            }
            if (I18n.tr("URL contains an invalid authority: {0}", new Object[]{null}).equals(errMsg) && value.contains("\\") && validator.isValid(value.replaceAll("\\\\", "/"))) {
                errMsg = I18n.tr("URL contains backslashes instead of slashes", new Object[0]);
                fix = () -> new ChangePropertyCommand(p, k, value.replaceAll("\\\\", "/"));
            }
            errors.add(TestError.builder(this, Severity.WARNING, code).message(validator.getValidatorName(), I18n.marktr("''{0}'': {1}"), k, errMsg).primitives(p).fix(fix).build());
        }
        return errors;
    }

    @Override
    public void check(OsmPrimitive p) {
        p.visitKeys((primitive, k, value) -> {
            if (!this.doTest(p, k, URL_KEYS, UrlValidator.getInstance(), 3301)) {
                this.doTest(p, k, EMAIL_KEYS, EmailValidator.getInstance(), 3302);
            }
        });
    }
}

