/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyYielder;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ArraySupport;

@JRubyClass(name={"Enumerator::Generator"})
public class RubyGenerator
extends RubyObject {
    private RubyProc proc;

    public static RubyClass createGeneratorClass(Ruby runtime2, RubyClass enumeratorModule) {
        RubyClass genc = runtime2.defineClassUnder("Generator", runtime2.getObject(), RubyGenerator::new, enumeratorModule);
        genc.includeModule(runtime2.getEnumerable());
        genc.defineAnnotatedMethods(RubyGenerator.class);
        return genc;
    }

    public RubyGenerator(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE, optional=1, checkArity=false)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2, Block block) {
        RubyProc proc2;
        int argc = Arity.checkArgumentCount(context, args2, 0, 1);
        Ruby runtime2 = context.runtime;
        if (argc == 0) {
            proc2 = RubyProc.newProc(runtime2, block, Block.Type.PROC);
        } else {
            if (!(args2[0] instanceof RubyProc)) {
                throw runtime2.newTypeError(args2[0], runtime2.getProc());
            }
            proc2 = (RubyProc)args2[0];
            if (block.isGiven()) {
                runtime2.getWarnings().warn(IRubyWarnings.ID.BLOCK_UNUSED, "given block not used");
            }
        }
        this.proc = proc2;
        return this;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(ThreadContext context, IRubyObject other) {
        if (!(other instanceof RubyGenerator)) {
            throw context.runtime.newTypeError(other, context.runtime.getGenerator());
        }
        this.checkFrozen();
        this.proc = ((RubyGenerator)other).proc;
        return this;
    }

    @JRubyMethod(rest=true, keywords=true)
    public IRubyObject each(ThreadContext context, IRubyObject[] args2, Block block) {
        return this.proc.call(context, ArraySupport.newCopy(RubyYielder.newYielder(context, block), args2));
    }

    public RubyProc getProc() {
        return this.proc;
    }
}

