/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;

public final class ExpressionUtil {
    public static boolean isEffectivelyUnqualified(PsiReferenceExpression refExpression) {
        PsiExpression qualifier2 = PsiUtil.deparenthesizeExpression(refExpression.getQualifierExpression());
        if (qualifier2 == null) {
            return true;
        }
        if (qualifier2 instanceof PsiThisExpression || qualifier2 instanceof PsiSuperExpression) {
            PsiJavaCodeReferenceElement thisQualifier = ((PsiQualifiedExpression)qualifier2).getQualifier();
            if (thisQualifier == null) {
                return true;
            }
            PsiClass innerMostClass = PsiTreeUtil.getParentOfType((PsiElement)refExpression, PsiClass.class);
            return innerMostClass == thisQualifier.resolve();
        }
        return false;
    }
}

