/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0006\u0010\u0014\u001a\u00020\tJ\u0016\u0010\u0015\u001a\u00020\u00032\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0013H\u0002J\u001e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00032\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u001cH\u0002R*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000RJ\u0010\u000e\u001a>\u0012\u0004\u0012\u00020\f\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00030\u000bj\b\u0012\u0004\u0012\u00020\u0003`\r0\u0006j\u001e\u0012\u0004\u0012\u00020\f\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00030\u000bj\b\u0012\u0004\u0012\u00020\u0003`\r`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000RJ\u0010\u0010\u001a>\u0012\u0004\u0012\u00020\f\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00030\u000bj\b\u0012\u0004\u0012\u00020\u0003`\r0\u0006j\u001e\u0012\u0004\u0012\u00020\f\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00030\u000bj\b\u0012\u0004\u0012\u00020\u0003`\r`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/MoveTemporaryVariableDeclarationToAssignment;", "", "body", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;)V", "blockParents", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "hasChanges", "", "removedVarDeclarations", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "Lkotlin/collections/HashSet;", "varAssignedInBlocks", "varBeforeAssignmentUsages", "varUsedInBlocks", "varWithoutInitDeclarations", "analyze", "", "apply", "calculateLCA", "blocks", "", "perform", "removeNonParentBlocks", "block", "parents", "Ljava/util/LinkedHashSet;", "js.translator"})
public final class MoveTemporaryVariableDeclarationToAssignment {
    @NotNull
    private final JsBlock body;
    private boolean hasChanges;
    @NotNull
    private final HashMap<JsName, HashSet<JsBlock>> varUsedInBlocks;
    @NotNull
    private final HashMap<JsName, HashSet<JsBlock>> varAssignedInBlocks;
    @NotNull
    private final HashMap<JsBlock, JsBlock> blockParents;
    @NotNull
    private final HashSet<JsName> varWithoutInitDeclarations;
    @NotNull
    private final HashSet<JsName> varBeforeAssignmentUsages;
    @NotNull
    private final HashSet<JsName> removedVarDeclarations;

    public MoveTemporaryVariableDeclarationToAssignment(@NotNull JsBlock body2) {
        Intrinsics.checkNotNullParameter(body2, "body");
        this.body = body2;
        this.varUsedInBlocks = new HashMap();
        this.varAssignedInBlocks = new HashMap();
        this.blockParents = new HashMap();
        this.varWithoutInitDeclarations = new HashSet();
        this.varBeforeAssignmentUsages = new HashSet();
        this.removedVarDeclarations = new HashSet();
    }

    public final boolean apply() {
        this.analyze();
        this.perform();
        if (!this.removedVarDeclarations.isEmpty()) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        return this.hasChanges;
    }

    private final void analyze() {
        RecursiveJsVisitor visitor2 = new RecursiveJsVisitor(this){
            @NotNull
            private final List<JsBlock> blockStack;
            final /* synthetic */ MoveTemporaryVariableDeclarationToAssignment this$0;
            {
                this.this$0 = $receiver;
                this.blockStack = new ArrayList<E>();
            }

            private final JsBlock getCurrentBlock() {
                return CollectionsKt.last(this.blockStack);
            }

            public void visitBlock(@NotNull JsBlock x) {
                Intrinsics.checkNotNullParameter(x, "x");
                if (!((Collection)this.blockStack).isEmpty()) {
                    ((Map)MoveTemporaryVariableDeclarationToAssignment.access$getBlockParents$p(this.this$0)).put(x, this.getCurrentBlock());
                }
                ((Collection)this.blockStack).add(x);
                super.visitBlock(x);
                CollectionsKt.removeLast(this.blockStack);
            }

            public void visit(@NotNull JsVars.JsVar x) {
                Intrinsics.checkNotNullParameter(x, "x");
                if (x.getInitExpression() == null && MetadataProperties.getSynthetic(x)) {
                    ((Collection)MoveTemporaryVariableDeclarationToAssignment.access$getVarWithoutInitDeclarations$p(this.this$0)).add(x.getName());
                }
                super.visit(x);
            }

            public void visitVars(@NotNull JsVars x) {
                Intrinsics.checkNotNullParameter(x, "x");
                if (MetadataProperties.getSynthetic(x)) {
                    for (JsVars.JsVar variable2 : x) {
                        if (variable2.getInitExpression() != null) continue;
                        ((Collection)MoveTemporaryVariableDeclarationToAssignment.access$getVarWithoutInitDeclarations$p(this.this$0)).add(variable2.getName());
                    }
                }
                super.visitVars(x);
            }

            public void visitNameRef(@NotNull JsNameRef nameRef) {
                Intrinsics.checkNotNullParameter(nameRef, "nameRef");
                JsName name2 = nameRef.getName();
                if (name2 != null && MoveTemporaryVariableDeclarationToAssignment.access$getVarWithoutInitDeclarations$p(this.this$0).contains(name2)) {
                    boolean hasAssignment;
                    block7: {
                        boolean bl;
                        Object object;
                        Object $this$getOrPut$iv = MoveTemporaryVariableDeclarationToAssignment.access$getVarUsedInBlocks$p(this.this$0);
                        boolean $i$f$getOrPut = false;
                        V value$iv = $this$getOrPut$iv.get(name2);
                        if (value$iv == null) {
                            boolean bl2 = false;
                            HashSet<E> answer$iv = new HashSet<E>();
                            $this$getOrPut$iv.put(name2, answer$iv);
                            object = answer$iv;
                        } else {
                            object = value$iv;
                        }
                        $this$getOrPut$iv = (Collection)object;
                        $this$getOrPut$iv.add(this.getCurrentBlock());
                        HashSet hashSet = (HashSet)MoveTemporaryVariableDeclarationToAssignment.access$getVarAssignedInBlocks$p(this.this$0).get(name2);
                        Set<T> assignments = hashSet == null ? SetsKt.emptySet() : (Set<T>)hashSet;
                        Iterable $this$any$iv = this.blockStack;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                JsBlock it = (JsBlock)element$iv;
                                boolean bl3 = false;
                                if (!assignments.contains(it)) continue;
                                bl = true;
                                break block7;
                            }
                            bl = hasAssignment = false;
                        }
                    }
                    if (!hasAssignment) {
                        ((Collection)MoveTemporaryVariableDeclarationToAssignment.access$getVarBeforeAssignmentUsages$p(this.this$0)).add(name2);
                    }
                }
                super.visitNameRef(nameRef);
            }

            /*
             * WARNING - void declaration
             */
            public void visitExpressionStatement(@NotNull JsExpressionStatement x) {
                Intrinsics.checkNotNullParameter(x, "x");
                Pair<JsName, JsExpression> assignment = JsAstUtils.decomposeAssignmentToVariable(x.getExpression());
                if (assignment != null) {
                    JsName name2 = assignment.component1();
                    if (MoveTemporaryVariableDeclarationToAssignment.access$getVarWithoutInitDeclarations$p(this.this$0).contains(name2)) {
                        Object object;
                        void $this$getOrPut$iv;
                        Object object2 = MoveTemporaryVariableDeclarationToAssignment.access$getVarAssignedInBlocks$p(this.this$0);
                        Intrinsics.checkNotNull(name2);
                        JsName key$iv = name2;
                        boolean $i$f$getOrPut = false;
                        V value$iv = $this$getOrPut$iv.get(key$iv);
                        if (value$iv == null) {
                            boolean bl = false;
                            HashSet<E> answer$iv = new HashSet<E>();
                            $this$getOrPut$iv.put(key$iv, answer$iv);
                            object = answer$iv;
                        } else {
                            object = value$iv;
                        }
                        object2 = (Collection)object;
                        object2.add(this.getCurrentBlock());
                    }
                }
                super.visitExpressionStatement(x);
            }
        };
        visitor2.accept((JsNode)this.body);
    }

    private final void removeNonParentBlocks(JsBlock block, LinkedHashSet<JsBlock> parents2) {
        JsBlock blockParent = block;
        while (blockParent != null) {
            Iterator parentIter;
            if (!parents2.contains(blockParent)) {
                blockParent = this.blockParents.get(blockParent);
                continue;
            }
            Intrinsics.checkNotNullExpressionValue(parents2.iterator(), "iterator(...)");
            while (parentIter.hasNext()) {
                if (!Intrinsics.areEqual(parentIter.next(), blockParent)) {
                    parentIter.remove();
                    continue;
                }
                return;
            }
        }
    }

    private final JsBlock calculateLCA(Set<? extends JsBlock> blocks) {
        if (!(!((Collection)blocks).isEmpty())) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        LinkedHashSet<JsBlock> parents2 = new LinkedHashSet<JsBlock>();
        JsBlock firstBlockParent = (JsBlock)CollectionsKt.first((Iterable)blocks);
        while (firstBlockParent != null) {
            ((Collection)parents2).add(firstBlockParent);
            firstBlockParent = this.blockParents.get(firstBlockParent);
        }
        Iterator iterator2 = SequencesKt.drop(CollectionsKt.asSequence((Iterable)blocks), 1).iterator();
        while (iterator2.hasNext()) {
            JsBlock block = (JsBlock)iterator2.next();
            this.removeNonParentBlocks(block, parents2);
        }
        if (!(!((Collection)parents2).isEmpty())) {
            String string3 = "Failed requirement.";
            throw new IllegalArgumentException(string3.toString());
        }
        return (JsBlock)CollectionsKt.first((Iterable)parents2);
    }

    private final void perform() {
        JsVisitorWithContextImpl visitor2 = new JsVisitorWithContextImpl(this){
            final /* synthetic */ MoveTemporaryVariableDeclarationToAssignment this$0;
            {
                this.this$0 = $receiver;
            }

            private final boolean canRemoveDeclarationWithoutInit(JsName name2) {
                if (!MoveTemporaryVariableDeclarationToAssignment.access$getVarWithoutInitDeclarations$p(this.this$0).contains(name2) || MoveTemporaryVariableDeclarationToAssignment.access$getVarBeforeAssignmentUsages$p(this.this$0).contains(name2)) {
                    return false;
                }
                HashSet hashSet = (HashSet)MoveTemporaryVariableDeclarationToAssignment.access$getVarAssignedInBlocks$p(this.this$0).get(name2);
                if (hashSet == null) {
                    return false;
                }
                HashSet assignedInBlocks = hashSet;
                HashSet hashSet2 = (HashSet)MoveTemporaryVariableDeclarationToAssignment.access$getVarUsedInBlocks$p(this.this$0).get(name2);
                Set<T> usedInBlocks = hashSet2 == null ? SetsKt.emptySet() : (Set<T>)hashSet2;
                JsBlock lcaBlock = MoveTemporaryVariableDeclarationToAssignment.access$calculateLCA(this.this$0, SetsKt.plus(usedInBlocks, assignedInBlocks));
                return assignedInBlocks.contains(lcaBlock);
            }

            public void endVisit(@NotNull JsVars.JsVar x, @NotNull JsContext<?> ctx) {
                Intrinsics.checkNotNullParameter(x, "x");
                Intrinsics.checkNotNullParameter(ctx, "ctx");
                JsName jsName = x.getName();
                Intrinsics.checkNotNullExpressionValue(jsName, "getName(...)");
                if (this.canRemoveDeclarationWithoutInit(jsName)) {
                    ((Collection)MoveTemporaryVariableDeclarationToAssignment.access$getRemovedVarDeclarations$p(this.this$0)).add(x.getName());
                    ctx.removeMe();
                    MoveTemporaryVariableDeclarationToAssignment.access$setHasChanges$p(this.this$0, true);
                } else {
                    super.endVisit(x, ctx);
                }
            }

            public void endVisit(@NotNull JsVars x, @NotNull JsContext<?> ctx) {
                Intrinsics.checkNotNullParameter(x, "x");
                Intrinsics.checkNotNullParameter(ctx, "ctx");
                if (x.isEmpty()) {
                    ctx.removeMe();
                    MoveTemporaryVariableDeclarationToAssignment.access$setHasChanges$p(this.this$0, true);
                } else {
                    super.endVisit(x, ctx);
                }
            }

            public void endVisit(@NotNull JsExpressionStatement x, @NotNull JsContext<JsNode> ctx) {
                Intrinsics.checkNotNullParameter(x, "x");
                Intrinsics.checkNotNullParameter(ctx, "ctx");
                Pair<JsName, JsExpression> assignment = JsAstUtils.decomposeAssignmentToVariable(x.getExpression());
                if (assignment != null) {
                    JsName name2 = assignment.component1();
                    JsExpression initExpr = assignment.component2();
                    if (MoveTemporaryVariableDeclarationToAssignment.access$getRemovedVarDeclarations$p(this.this$0).remove(name2)) {
                        JsVars jsVars;
                        JsVars.JsVar jsVar;
                        JsVars.JsVar $this$endVisit_u24lambda_u240 = jsVar = new JsVars.JsVar(name2, initExpr);
                        boolean bl = false;
                        MetadataProperties.setSynthetic($this$endVisit_u24lambda_u240, true);
                        JsVars.JsVar varDeclarationWithInit = jsVar;
                        JsVars $this$endVisit_u24lambda_u241 = jsVars = new JsVars(varDeclarationWithInit);
                        boolean bl2 = false;
                        MetadataProperties.setSynthetic($this$endVisit_u24lambda_u241, true);
                        JsVars vars = jsVars;
                        ctx.replaceMe((JsNode)vars);
                    }
                    this.accept((JsNode)initExpr);
                } else {
                    super.endVisit(x, ctx);
                }
            }
        };
        visitor2.accept((JsNode)this.body);
    }

    public static final /* synthetic */ HashMap access$getBlockParents$p(MoveTemporaryVariableDeclarationToAssignment $this) {
        return $this.blockParents;
    }

    public static final /* synthetic */ HashSet access$getVarWithoutInitDeclarations$p(MoveTemporaryVariableDeclarationToAssignment $this) {
        return $this.varWithoutInitDeclarations;
    }

    public static final /* synthetic */ HashMap access$getVarUsedInBlocks$p(MoveTemporaryVariableDeclarationToAssignment $this) {
        return $this.varUsedInBlocks;
    }

    public static final /* synthetic */ HashMap access$getVarAssignedInBlocks$p(MoveTemporaryVariableDeclarationToAssignment $this) {
        return $this.varAssignedInBlocks;
    }

    public static final /* synthetic */ HashSet access$getVarBeforeAssignmentUsages$p(MoveTemporaryVariableDeclarationToAssignment $this) {
        return $this.varBeforeAssignmentUsages;
    }

    public static final /* synthetic */ JsBlock access$calculateLCA(MoveTemporaryVariableDeclarationToAssignment $this, Set blocks) {
        return $this.calculateLCA(blocks);
    }

    public static final /* synthetic */ HashSet access$getRemovedVarDeclarations$p(MoveTemporaryVariableDeclarationToAssignment $this) {
        return $this.removedVarDeclarations;
    }

    public static final /* synthetic */ void access$setHasChanges$p(MoveTemporaryVariableDeclarationToAssignment $this, boolean bl) {
        $this.hasChanges = bl;
    }
}

