import { EndpointParameterInstructions } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@smithy/types";
import {
  CloudFormationClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../CloudFormationClient";
import {
  StopStackSetOperationInput,
  StopStackSetOperationOutput,
} from "../models/models_0";
export { __MetadataBearer, $Command };
export interface StopStackSetOperationCommandInput
  extends StopStackSetOperationInput {}
export interface StopStackSetOperationCommandOutput
  extends StopStackSetOperationOutput,
    __MetadataBearer {}
export declare class StopStackSetOperationCommand extends $Command<
  StopStackSetOperationCommandInput,
  StopStackSetOperationCommandOutput,
  CloudFormationClientResolvedConfig
> {
  readonly input: StopStackSetOperationCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: StopStackSetOperationCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: CloudFormationClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    StopStackSetOperationCommandInput,
    StopStackSetOperationCommandOutput
  >;
  private serialize;
  private deserialize;
}
