"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const assert = __importStar(require("assert"));
const sinon_1 = __importDefault(require("sinon"));
const typescript_1 = __importDefault(require("typescript"));
const svS = __importStar(require("../../../src/plugins/typescript/svelte-sys"));
const module_loader_1 = require("../../../src/plugins/typescript/module-loader");
describe('createSvelteModuleLoader', () => {
    afterEach(() => {
        sinon_1.default.restore();
    });
    function setup(resolvedModule) {
        const getSvelteSnapshotStub = sinon_1.default
            .stub()
            .returns({ scriptKind: typescript_1.default.ScriptKind.JSX });
        const resolveStub = sinon_1.default.stub().returns({
            resolvedModule
        });
        const moduleCacheMock = {
            getPackageJsonInfoCache: () => ({})
        };
        const svelteSys = 'svelteSys';
        sinon_1.default.stub(svS, 'createSvelteSys').returns(svelteSys);
        const compilerOptions = { strict: true, paths: { '/@/*': [] } };
        const moduleResolver = (0, module_loader_1.createSvelteModuleLoader)(getSvelteSnapshotStub, compilerOptions, typescript_1.default.sys, {
            ...typescript_1.default,
            createModuleResolutionCache: () => moduleCacheMock,
            resolveModuleName: resolveStub
        });
        return {
            getSvelteSnapshotStub,
            moduleCacheMock: moduleCacheMock,
            resolveStub,
            compilerOptions,
            moduleResolver,
            svelteSys
        };
    }
    function lastCall(stub) {
        return stub.getCall(stub.getCalls().length - 1);
    }
    it('uses tsSys for normal files', async () => {
        const resolvedModule = {
            extension: typescript_1.default.Extension.Ts,
            resolvedFileName: 'filename.ts'
        };
        const { resolveStub, moduleResolver, compilerOptions, moduleCacheMock } = setup(resolvedModule);
        const result = moduleResolver.resolveModuleNames(['./normal.ts'], 'C:/somerepo/somefile.svelte', undefined, undefined, undefined);
        assert.deepStrictEqual(result, [resolvedModule]);
        assert.deepStrictEqual(lastCall(resolveStub).args, [
            './normal.ts',
            'C:/somerepo/somefile.svelte',
            compilerOptions,
            typescript_1.default.sys,
            moduleCacheMock,
            undefined,
            undefined
        ]);
    });
    it('uses tsSys for normal files part of TS aliases', async () => {
        const resolvedModule = {
            extension: typescript_1.default.Extension.Ts,
            resolvedFileName: 'filename.ts'
        };
        const { resolveStub, moduleResolver, compilerOptions, moduleCacheMock } = setup(resolvedModule);
        const result = moduleResolver.resolveModuleNames(['/@/normal'], 'C:/somerepo/somefile.svelte', undefined, undefined, undefined);
        assert.deepStrictEqual(result, [resolvedModule]);
        assert.deepStrictEqual(lastCall(resolveStub).args, [
            '/@/normal',
            'C:/somerepo/somefile.svelte',
            compilerOptions,
            typescript_1.default.sys,
            moduleCacheMock,
            undefined,
            undefined
        ]);
    });
    it('uses tsSys for svelte.d.ts files', async () => {
        const resolvedModule = {
            extension: typescript_1.default.Extension.Dts,
            resolvedFileName: 'filename.d.ts'
        };
        const { resolveStub, moduleResolver, compilerOptions, moduleCacheMock } = setup(resolvedModule);
        const result = moduleResolver.resolveModuleNames(['./normal.ts'], 'C:/somerepo/somefile.svelte', undefined, undefined, undefined);
        assert.deepStrictEqual(result, [resolvedModule]);
        assert.deepStrictEqual(lastCall(resolveStub).args, [
            './normal.ts',
            'C:/somerepo/somefile.svelte',
            compilerOptions,
            typescript_1.default.sys,
            moduleCacheMock,
            undefined,
            undefined
        ]);
    });
    it('uses svelte module loader for virtual svelte files', async () => {
        const resolvedModule = {
            extension: typescript_1.default.Extension.Ts,
            resolvedFileName: 'filename.svelte.ts'
        };
        const { resolveStub, svelteSys, moduleResolver, compilerOptions, getSvelteSnapshotStub } = setup(resolvedModule);
        const result = moduleResolver.resolveModuleNames(['./svelte.svelte'], 'C:/somerepo/somefile.svelte', undefined, undefined, undefined);
        assert.deepStrictEqual(result, [
            {
                extension: typescript_1.default.Extension.Jsx,
                resolvedFileName: 'filename.svelte',
                isExternalLibraryImport: undefined
            }
        ]);
        assert.deepStrictEqual(lastCall(resolveStub).args, [
            './svelte.svelte',
            'C:/somerepo/somefile.svelte',
            compilerOptions,
            svelteSys,
            undefined,
            undefined,
            undefined
        ]);
        assert.deepStrictEqual(lastCall(getSvelteSnapshotStub).args, ['filename.svelte']);
    });
    it('uses svelte module loader for virtual svelte files with TS path aliases', async () => {
        const resolvedModule = {
            extension: typescript_1.default.Extension.Ts,
            resolvedFileName: 'filename.svelte.ts'
        };
        const { resolveStub, svelteSys, moduleResolver, compilerOptions, getSvelteSnapshotStub } = setup(resolvedModule);
        const result = moduleResolver.resolveModuleNames(['/@/svelte.svelte'], 'C:/somerepo/somefile.svelte', undefined, undefined, undefined);
        assert.deepStrictEqual(result, [
            {
                extension: typescript_1.default.Extension.Jsx,
                resolvedFileName: 'filename.svelte',
                isExternalLibraryImport: undefined
            }
        ]);
        assert.deepStrictEqual(lastCall(resolveStub).args, [
            '/@/svelte.svelte',
            'C:/somerepo/somefile.svelte',
            compilerOptions,
            svelteSys,
            undefined,
            undefined,
            undefined
        ]);
        assert.deepStrictEqual(lastCall(getSvelteSnapshotStub).args, ['filename.svelte']);
    });
    it('uses cache if module was already resolved before', async () => {
        const resolvedModule = {
            extension: typescript_1.default.Extension.Ts,
            resolvedFileName: 'filename.ts'
        };
        const { resolveStub, moduleResolver } = setup(resolvedModule);
        // first call
        moduleResolver.resolveModuleNames(['./normal.ts'], 'C:/somerepo/somefile.svelte', undefined, undefined, undefined);
        // second call, which should be from cache
        const result = moduleResolver.resolveModuleNames(['./normal.ts'], 'C:/somerepo/somefile.svelte', undefined, undefined, undefined);
        assert.deepStrictEqual(result, [resolvedModule]);
        assert.deepStrictEqual(resolveStub.callCount, 1);
    });
});
//# sourceMappingURL=module-loader.test.js.map