/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.deploy;

import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.catalina.ha.deploy.FileChangeListener;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class WarWatcher {
    private static final Log log = LogFactory.getLog(WarWatcher.class);
    private static final StringManager sm = StringManager.getManager(WarWatcher.class);
    protected final File watchDir;
    protected final FileChangeListener listener;
    protected final Map<String, WarInfo> currentStatus = new HashMap<String, WarInfo>();

    public WarWatcher(FileChangeListener fileChangeListener, File file) {
        this.listener = fileChangeListener;
        this.watchDir = file;
    }

    public void check() {
        File[] fileArray;
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("warWatcher.checkingWars", new Object[]{this.watchDir}));
        }
        if ((fileArray = this.watchDir.listFiles(new WarFilter())) == null) {
            log.warn((Object)sm.getString("warWatcher.cantListWatchDir", new Object[]{this.watchDir}));
            fileArray = new File[]{};
        }
        for (File file : fileArray) {
            if (!file.exists()) {
                log.warn((Object)sm.getString("warWatcher.listedFileDoesNotExist", new Object[]{file, this.watchDir}));
            }
            this.addWarInfo(file);
        }
        Iterator<Map.Entry<String, WarInfo>> iterator = this.currentStatus.entrySet().iterator();
        while (iterator.hasNext()) {
            int n;
            Map.Entry entry = (Map.Entry)iterator.next();
            WarInfo warInfo = (WarInfo)entry.getValue();
            if (log.isTraceEnabled()) {
                log.trace((Object)sm.getString("warWatcher.checkingWar", new Object[]{warInfo.getWar()}));
            }
            if ((n = warInfo.check()) == 1) {
                this.listener.fileModified(warInfo.getWar());
            } else if (n == -1) {
                this.listener.fileRemoved(warInfo.getWar());
                iterator.remove();
            }
            if (!log.isTraceEnabled()) continue;
            log.trace((Object)sm.getString("warWatcher.checkWarResult", new Object[]{n, warInfo.getWar()}));
        }
    }

    protected void addWarInfo(File file) {
        WarInfo warInfo = this.currentStatus.get(file.getAbsolutePath());
        if (warInfo == null) {
            warInfo = new WarInfo(file);
            warInfo.setLastState(-1);
            this.currentStatus.put(file.getAbsolutePath(), warInfo);
        }
    }

    public void clear() {
        this.currentStatus.clear();
    }

    protected static class WarFilter
    implements FilenameFilter {
        protected WarFilter() {
        }

        @Override
        public boolean accept(File file, String string) {
            if (string == null) {
                return false;
            }
            return string.endsWith(".war");
        }
    }

    protected static class WarInfo {
        protected final File war;
        protected long lastChecked = 0L;
        protected long lastState = 0L;

        public WarInfo(File file) {
            this.war = file;
            this.lastChecked = file.lastModified();
            if (!file.exists()) {
                this.lastState = -1L;
            }
        }

        public boolean modified() {
            return this.war.exists() && this.war.lastModified() > this.lastChecked;
        }

        public boolean exists() {
            return this.war.exists();
        }

        public int check() {
            int n = 0;
            if (this.modified()) {
                n = 1;
                this.lastState = n;
            } else if (!this.exists() && this.lastState != -1L) {
                n = -1;
                this.lastState = n;
            } else if (this.lastState == -1L && this.exists()) {
                n = 1;
                this.lastState = n;
            }
            this.lastChecked = System.currentTimeMillis();
            return n;
        }

        public File getWar() {
            return this.war;
        }

        public int hashCode() {
            return this.war.getAbsolutePath().hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof WarInfo) {
                WarInfo warInfo = (WarInfo)object;
                return warInfo.getWar().equals(this.getWar());
            }
            return false;
        }

        protected void setLastState(int n) {
            this.lastState = n;
        }
    }
}

