/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http2;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.coyote.http2.ConnectionException;
import org.apache.coyote.http2.Http2Error;
import org.apache.coyote.http2.Http2Exception;
import org.apache.coyote.http2.StreamException;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

abstract class AbstractStream {
    private static final Log log = LogFactory.getLog(AbstractStream.class);
    private static final StringManager sm = StringManager.getManager(AbstractStream.class);
    private final Integer identifier;
    private final String idAsString;
    private long windowSize = 65535L;
    protected final Lock windowAllocationLock = new ReentrantLock();
    protected final Condition windowAllocationAvailable = this.windowAllocationLock.newCondition();
    private volatile int connectionAllocationRequested = 0;
    private volatile int connectionAllocationMade = 0;

    AbstractStream(Integer n) {
        this.identifier = n;
        this.idAsString = n.toString();
    }

    final Integer getIdentifier() {
        return this.identifier;
    }

    final String getIdAsString() {
        return this.idAsString;
    }

    final int getIdAsInt() {
        return this.identifier;
    }

    final void setWindowSize(long l) {
        this.windowAllocationLock.lock();
        try {
            this.windowSize = l;
        }
        finally {
            this.windowAllocationLock.unlock();
        }
    }

    final long getWindowSize() {
        this.windowAllocationLock.lock();
        try {
            long l = this.windowSize;
            return l;
        }
        finally {
            this.windowAllocationLock.unlock();
        }
    }

    void incrementWindowSize(int n) throws Http2Exception {
        this.windowAllocationLock.lock();
        try {
            this.windowSize += (long)n;
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("abstractStream.windowSizeInc", new Object[]{this.getConnectionId(), this.getIdAsString(), Integer.toString(n), Long.toString(this.windowSize)}));
            }
            if (this.windowSize > Integer.MAX_VALUE) {
                String string = sm.getString("abstractStream.windowSizeTooBig", new Object[]{this.getConnectionId(), this.identifier, Integer.toString(n), Long.toString(this.windowSize)});
                if (this.identifier == 0) {
                    throw new ConnectionException(string, Http2Error.FLOW_CONTROL_ERROR);
                }
                throw new StreamException(string, Http2Error.FLOW_CONTROL_ERROR, this.identifier);
            }
        }
        finally {
            this.windowAllocationLock.unlock();
        }
    }

    final void decrementWindowSize(int n) {
        this.windowAllocationLock.lock();
        try {
            this.windowSize -= (long)n;
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("abstractStream.windowSizeDec", new Object[]{this.getConnectionId(), this.getIdAsString(), Integer.toString(n), Long.toString(this.windowSize)}));
            }
        }
        finally {
            this.windowAllocationLock.unlock();
        }
    }

    final int getConnectionAllocationRequested() {
        return this.connectionAllocationRequested;
    }

    final void setConnectionAllocationRequested(int n) {
        log.debug((Object)sm.getString("abstractStream.setConnectionAllocationRequested", new Object[]{this.getConnectionId(), this.getIdAsString(), Integer.toString(this.connectionAllocationRequested), Integer.toString(n)}));
        this.connectionAllocationRequested = n;
    }

    final int getConnectionAllocationMade() {
        return this.connectionAllocationMade;
    }

    final void setConnectionAllocationMade(int n) {
        log.debug((Object)sm.getString("abstractStream.setConnectionAllocationMade", new Object[]{this.getConnectionId(), this.getIdAsString(), Integer.toString(this.connectionAllocationMade), Integer.toString(n)}));
        this.connectionAllocationMade = n;
    }

    abstract String getConnectionId();
}

