/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.jsse;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.tomcat.util.buf.Asn1Parser;
import org.apache.tomcat.util.buf.Asn1Writer;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.codec.binary.Base64;
import org.apache.tomcat.util.file.ConfigFileLoader;
import org.apache.tomcat.util.res.StringManager;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

public class PEMFile {
    private static final StringManager sm = StringManager.getManager(PEMFile.class);
    private static final byte[] OID_EC_PUBLIC_KEY = new byte[]{6, 7, 42, -122, 72, -50, 61, 2, 1};
    private static final byte[] OID_PBES2 = new byte[]{42, -122, 72, -122, -9, 13, 1, 5, 13};
    private static final byte[] OID_PBKDF2 = new byte[]{42, -122, 72, -122, -9, 13, 1, 5, 12};
    private static final Map<String, String> OID_TO_PRF = new HashMap<String, String>();
    private static final Map<String, Algorithm> OID_TO_ALGORITHM;
    private List<X509Certificate> certificates = new ArrayList<X509Certificate>();
    private PrivateKey privateKey;

    public static String toPEM(X509Certificate x509Certificate) throws CertificateEncodingException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("-----BEGIN CERTIFICATE-----");
        stringBuilder.append(System.lineSeparator());
        Base64 base64 = new Base64(64);
        stringBuilder.append(base64.encodeAsString(x509Certificate.getEncoded()));
        stringBuilder.append("-----END CERTIFICATE-----");
        return stringBuilder.toString();
    }

    public List<X509Certificate> getCertificates() {
        return this.certificates;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public PEMFile(String string) throws IOException, GeneralSecurityException {
        this(string, null);
    }

    public PEMFile(String string, String string2) throws IOException, GeneralSecurityException {
        this(string, string2, null);
    }

    public PEMFile(String string, String string2, String string3) throws IOException, GeneralSecurityException {
        this(string, ConfigFileLoader.getInputStream((String)string), string2, string3);
    }

    public PEMFile(String string, String string2, String string3, String string4) throws IOException, GeneralSecurityException {
        this(string, ConfigFileLoader.getInputStream((String)string), string2, string3, string3 != null ? ConfigFileLoader.getInputStream((String)string3) : null, string4);
    }

    public PEMFile(String string, InputStream inputStream, String string2, String string3) throws IOException, GeneralSecurityException {
        this(string, inputStream, string2, null, null, string3);
    }

    public PEMFile(String string, InputStream inputStream, String string2, String string3, InputStream inputStream2, String string4) throws IOException, GeneralSecurityException {
        Object object;
        ArrayList<Part> arrayList = new ArrayList<Part>();
        try (Object object2 = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.US_ASCII));){
            String object3;
            object = null;
            while ((object3 = ((BufferedReader)object2).readLine()) != null) {
                if (object3.startsWith("-----BEGIN ")) {
                    object = new Part();
                    ((Part)object).type = object3.substring("-----BEGIN ".length(), object3.length() - "-----".length()).trim();
                    continue;
                }
                if (object3.startsWith("-----END ")) {
                    arrayList.add((Part)object);
                    object = null;
                    continue;
                }
                if (object != null && !object3.contains(":") && !object3.startsWith(" ")) {
                    ((Part)object).content = ((Part)object).content + object3;
                    continue;
                }
                if (object == null || !object3.contains(":") || object3.startsWith(" ") || !object3.startsWith("DEK-Info: ")) continue;
                String[] stringArray = object3.split(" ");
                if ((stringArray = stringArray[1].split(",")).length != 2) continue;
                ((Part)object).algorithm = stringArray[0];
                ((Part)object).ivHex = stringArray[1];
            }
        }
        object2 = null;
        if (inputStream2 != null) {
            object = new BufferedReader(new InputStreamReader(inputStream2, StandardCharsets.UTF_8));
            try {
                object2 = ((BufferedReader)object).readLine();
            }
            finally {
                ((BufferedReader)object).close();
            }
        } else {
            object2 = string2;
        }
        for (Part part : arrayList) {
            switch (part.type) {
                case "PRIVATE KEY": {
                    this.privateKey = part.toPrivateKey(string4, Format.PKCS8, string);
                    break;
                }
                case "EC PRIVATE KEY": {
                    this.privateKey = part.toPrivateKey("EC", Format.RFC5915, string);
                    break;
                }
                case "ENCRYPTED PRIVATE KEY": {
                    this.privateKey = part.toPrivateKey((String)object2, string4, Format.PKCS8, string);
                    break;
                }
                case "RSA PRIVATE KEY": {
                    if (part.algorithm == null) {
                        this.privateKey = part.toPrivateKey(string4, Format.PKCS1, string);
                        break;
                    }
                    this.privateKey = part.toPrivateKey((String)object2, string4, Format.PKCS1, string);
                    break;
                }
                case "CERTIFICATE": 
                case "X509 CERTIFICATE": {
                    this.certificates.add(part.toCertificate());
                }
            }
        }
    }

    static {
        OID_TO_PRF.put("2a864886f70d0207", "HmacSHA1");
        OID_TO_PRF.put("2a864886f70d0208", "HmacSHA224");
        OID_TO_PRF.put("2a864886f70d0209", "HmacSHA256");
        OID_TO_PRF.put("2a864886f70d020a", "HmacSHA384");
        OID_TO_PRF.put("2a864886f70d020b", "HmacSHA512");
        OID_TO_PRF.put("2a864886f70d020c", "HmacSHA512/224");
        OID_TO_PRF.put("2a864886f70d020d", "HmacSHA512/256");
        OID_TO_ALGORITHM = new HashMap<String, Algorithm>();
        OID_TO_ALGORITHM.put("2a864886f70d0307", Algorithm.DES_EDE3_CBC);
        OID_TO_ALGORITHM.put("608648016503040102", Algorithm.AES128_CBC_PAD);
        OID_TO_ALGORITHM.put("60864801650304012a", Algorithm.AES256_CBC_PAD);
    }

    private static enum Algorithm {
        AES128_CBC_PAD("AES/CBC/PKCS5PADDING", "AES", 128),
        AES256_CBC_PAD("AES/CBC/PKCS5PADDING", "AES", 256),
        DES_EDE3_CBC("DESede/CBC/PKCS5Padding", "DESede", 192);

        private final String transformation;
        private final String secretKeyAlgorithm;
        private final int keyLength;

        private Algorithm(String string2, String string3, int n2) {
            this.transformation = string2;
            this.secretKeyAlgorithm = string3;
            this.keyLength = n2;
        }

        public String getTransformation() {
            return this.transformation;
        }

        public String getSecretKeyAlgorithm() {
            return this.secretKeyAlgorithm;
        }

        public int getKeyLength() {
            return this.keyLength;
        }
    }

    private static enum Format {
        PKCS1,
        PKCS8,
        RFC5915;

    }

    private static class Part {
        public static final String BEGIN_BOUNDARY = "-----BEGIN ";
        public static final String END_BOUNDARY = "-----END ";
        public static final String FINISH_BOUNDARY = "-----";
        public static final String PRIVATE_KEY = "PRIVATE KEY";
        public static final String EC_PRIVATE_KEY = "EC PRIVATE KEY";
        public static final String ENCRYPTED_PRIVATE_KEY = "ENCRYPTED PRIVATE KEY";
        public static final String RSA_PRIVATE_KEY = "RSA PRIVATE KEY";
        public static final String CERTIFICATE = "CERTIFICATE";
        public static final String X509_CERTIFICATE = "X509 CERTIFICATE";
        public String type;
        public String content = "";
        public String algorithm = null;
        public String ivHex = null;

        private Part() {
        }

        private byte[] decode() {
            return Base64.decodeBase64((String)this.content);
        }

        public X509Certificate toCertificate() throws CertificateException {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            return (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(this.decode()));
        }

        public PrivateKey toPrivateKey(String string, Format format, String string2) throws GeneralSecurityException {
            return this.toPrivateKey(string, format, string2, this.decode());
        }

        public PrivateKey toPrivateKey(String string, String string2, Format format, String string3) throws GeneralSecurityException, IOException {
            switch (format) {
                case PKCS1: {
                    int n;
                    String string4;
                    String string5;
                    switch (this.algorithm) {
                        case "DES-CBC": {
                            string5 = "DES";
                            string4 = "DES/CBC/PKCS5Padding";
                            n = 8;
                            break;
                        }
                        case "DES-EDE3-CBC": {
                            string5 = "DESede";
                            string4 = "DESede/CBC/PKCS5Padding";
                            n = 24;
                            break;
                        }
                        case "AES-256-CBC": {
                            string5 = "AES";
                            string4 = "AES/CBC/PKCS5Padding";
                            n = 32;
                            break;
                        }
                        default: {
                            string5 = this.algorithm;
                            string4 = this.algorithm;
                            n = 8;
                        }
                    }
                    Object object = this.fromHex(this.ivHex);
                    byte[] byArray = this.deriveKeyPBKDF1(n, string, (byte[])object);
                    SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, string5);
                    Cipher cipher = Cipher.getInstance(string4);
                    cipher.init(2, (Key)secretKeySpec, new IvParameterSpec((byte[])object));
                    byte[] byArray2 = cipher.doFinal(this.decode());
                    return this.toPrivateKey(string2, format, string3, byArray2);
                }
                case PKCS8: {
                    Asn1Parser asn1Parser = new Asn1Parser(this.decode());
                    asn1Parser.parseTagSequence();
                    asn1Parser.parseFullLength();
                    asn1Parser.parseTagSequence();
                    asn1Parser.parseLength();
                    byte[] byArray = asn1Parser.parseOIDAsBytes();
                    if (!Arrays.equals(byArray, OID_PBES2)) {
                        throw new NoSuchAlgorithmException(sm.getString("pemFile.unknownPkcs8Algorithm", new Object[]{this.toDottedOidString(byArray)}));
                    }
                    asn1Parser.parseTagSequence();
                    asn1Parser.parseLength();
                    asn1Parser.parseTagSequence();
                    asn1Parser.parseLength();
                    byte[] byArray3 = asn1Parser.parseOIDAsBytes();
                    if (!Arrays.equals(byArray3, OID_PBKDF2)) {
                        throw new NoSuchAlgorithmException(sm.getString("pemFile.notPbkdf2", new Object[]{this.toDottedOidString(byArray3)}));
                    }
                    asn1Parser.parseTagSequence();
                    asn1Parser.parseLength();
                    byte[] byArray4 = asn1Parser.parseOctetString();
                    int n = asn1Parser.parseInt().intValue();
                    if (asn1Parser.peekTag() == 2) {
                        int n2 = asn1Parser.parseInt().intValue();
                    }
                    asn1Parser.parseTagSequence();
                    asn1Parser.parseLength();
                    byte[] byArray5 = asn1Parser.parseOIDAsBytes();
                    String string6 = (String)OID_TO_PRF.get(HexUtils.toHexString((byte[])byArray5));
                    if (string6 == null) {
                        throw new NoSuchAlgorithmException(sm.getString("pemFile.unknownPrfAlgorithm", new Object[]{this.toDottedOidString(byArray5)}));
                    }
                    asn1Parser.parseNull();
                    asn1Parser.parseTagSequence();
                    asn1Parser.parseLength();
                    byte[] byArray6 = asn1Parser.parseOIDAsBytes();
                    Algorithm algorithm = (Algorithm)((Object)OID_TO_ALGORITHM.get(HexUtils.toHexString((byte[])byArray6)));
                    if (algorithm == null) {
                        throw new NoSuchAlgorithmException(sm.getString("pemFile.unknownEncryptionAlgorithm", new Object[]{this.toDottedOidString(byArray6)}));
                    }
                    byte[] byArray7 = asn1Parser.parseOctetString();
                    byte[] byArray8 = asn1Parser.parseOctetString();
                    byte[] byArray9 = this.deriveKeyPBKDF2("PBKDF2With" + string6, string, byArray4, n, algorithm.getKeyLength());
                    SecretKeySpec secretKeySpec = new SecretKeySpec(byArray9, algorithm.getSecretKeyAlgorithm());
                    Cipher cipher = Cipher.getInstance(algorithm.getTransformation());
                    cipher.init(2, (Key)secretKeySpec, new IvParameterSpec(byArray7));
                    byte[] byArray10 = cipher.doFinal(byArray8);
                    return this.toPrivateKey(string2, format, string3, byArray10);
                }
            }
            throw new NoSuchAlgorithmException(sm.getString("pemFile.unknownEncryptedFormat", new Object[]{format}));
        }

        private PrivateKey toPrivateKey(String string, Format format, String string2, byte[] byArray) throws GeneralSecurityException {
            KeySpec keySpec = null;
            switch (format) {
                case PKCS1: {
                    keySpec = this.parsePKCS1(byArray);
                    break;
                }
                case PKCS8: {
                    keySpec = new PKCS8EncodedKeySpec(byArray);
                    break;
                }
                case RFC5915: {
                    keySpec = new PKCS8EncodedKeySpec(this.rfc5915ToPkcs8(byArray));
                }
            }
            InvalidKeyException invalidKeyException = new InvalidKeyException(sm.getString("pemFile.parseError", new Object[]{string2}));
            if (string == null) {
                for (String string3 : new String[]{"RSA", "DSA", "EC"}) {
                    try {
                        return KeyFactory.getInstance(string3).generatePrivate(keySpec);
                    }
                    catch (InvalidKeySpecException invalidKeySpecException) {
                        invalidKeyException.addSuppressed(invalidKeySpecException);
                    }
                }
            } else {
                try {
                    return KeyFactory.getInstance(string).generatePrivate(keySpec);
                }
                catch (InvalidKeySpecException invalidKeySpecException) {
                    invalidKeyException.addSuppressed(invalidKeySpecException);
                }
            }
            throw invalidKeyException;
        }

        private byte[] deriveKeyPBKDF1(int n, String string, byte[] byArray) throws NoSuchAlgorithmException {
            byte[] byArray2;
            byte[] byArray3 = new byte[n];
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] byArray4 = string.getBytes(StandardCharsets.UTF_8);
            for (int i = 0; i < n; i += byArray2.length) {
                messageDigest.update(byArray4);
                messageDigest.update(byArray, 0, 8);
                byArray2 = messageDigest.digest();
                messageDigest.update(byArray2);
                System.arraycopy(byArray2, 0, byArray3, i, Math.min(n - i, byArray2.length));
            }
            return byArray3;
        }

        private byte[] deriveKeyPBKDF2(String string, String string2, byte[] byArray, int n, int n2) throws GeneralSecurityException {
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string);
            PBEKeySpec pBEKeySpec = new PBEKeySpec(string2.toCharArray(), byArray, n, n2);
            SecretKey secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
            return secretKey.getEncoded();
        }

        private byte[] rfc5915ToPkcs8(byte[] byArray) {
            Asn1Parser asn1Parser = new Asn1Parser(byArray);
            asn1Parser.parseTag(48);
            asn1Parser.parseFullLength();
            BigInteger bigInteger = asn1Parser.parseInt();
            if (bigInteger.intValue() != 1) {
                throw new IllegalArgumentException(sm.getString("pemFile.notValidRFC5915"));
            }
            asn1Parser.parseTag(4);
            int n = asn1Parser.parseLength();
            byte[] byArray2 = new byte[n];
            asn1Parser.parseBytes(byArray2);
            asn1Parser.parseTag(160);
            int n2 = asn1Parser.parseLength();
            byte[] byArray3 = new byte[n2];
            asn1Parser.parseBytes(byArray3);
            if (byArray3[0] != 6) {
                throw new IllegalArgumentException(sm.getString("pemFile.notValidRFC5915"));
            }
            asn1Parser.parseTag(161);
            int n3 = asn1Parser.parseLength();
            byte[] byArray4 = new byte[n3];
            asn1Parser.parseBytes(byArray4);
            if (byArray4[0] != 3) {
                throw new IllegalArgumentException(sm.getString("pemFile.notValidRFC5915"));
            }
            return Asn1Writer.writeSequence((byte[][])new byte[][]{Asn1Writer.writeInteger((int)0), Asn1Writer.writeSequence((byte[][])new byte[][]{OID_EC_PUBLIC_KEY, byArray3}), Asn1Writer.writeOctetString((byte[])Asn1Writer.writeSequence((byte[][])new byte[][]{Asn1Writer.writeInteger((int)1), Asn1Writer.writeOctetString((byte[])byArray2), Asn1Writer.writeTag((byte)-95, (byte[])byArray4)}))});
        }

        private RSAPrivateCrtKeySpec parsePKCS1(byte[] byArray) {
            Asn1Parser asn1Parser = new Asn1Parser(byArray);
            asn1Parser.parseTag(48);
            asn1Parser.parseFullLength();
            BigInteger bigInteger = asn1Parser.parseInt();
            if (bigInteger.intValue() == 1) {
                throw new IllegalArgumentException(sm.getString("pemFile.noMultiPrimes"));
            }
            return new RSAPrivateCrtKeySpec(asn1Parser.parseInt(), asn1Parser.parseInt(), asn1Parser.parseInt(), asn1Parser.parseInt(), asn1Parser.parseInt(), asn1Parser.parseInt(), asn1Parser.parseInt(), asn1Parser.parseInt());
        }

        private byte[] fromHex(String string) {
            byte[] byArray = new byte[string.length() / 2];
            for (int i = 0; i < string.length(); i += 2) {
                byArray[i / 2] = (byte)((Character.digit(string.charAt(i), 16) << 4) + Character.digit(string.charAt(i + 1), 16));
            }
            return byArray;
        }

        private String toDottedOidString(byte[] byArray) {
            try {
                Oid oid = new Oid(byArray);
                return oid.toString();
            }
            catch (GSSException gSSException) {
                return HexUtils.toHexString((byte[])byArray);
            }
        }
    }
}

