/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Manager;
import org.apache.catalina.Store;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.session.PersistentManagerBase;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.util.CustomObjectInputStream;
import org.apache.catalina.util.LifecycleBase;
import org.apache.catalina.util.ToStringUtil;
import org.apache.tomcat.util.res.StringManager;

public abstract class StoreBase
extends LifecycleBase
implements Store {
    protected static final String storeName = "StoreBase";
    protected final PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected static final StringManager sm = StringManager.getManager(StoreBase.class);
    protected Manager manager;

    public String getStoreName() {
        return storeName;
    }

    @Override
    public void setManager(Manager manager) {
        Manager manager2 = this.manager;
        this.manager = manager;
        this.support.firePropertyChange("manager", manager2, this.manager);
    }

    @Override
    public Manager getManager() {
        return this.manager;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public String[] expiredKeys() throws IOException {
        return this.keys();
    }

    public void processExpires() {
        String[] stringArray = null;
        if (!this.getState().isAvailable()) {
            return;
        }
        try {
            stringArray = this.expiredKeys();
        }
        catch (IOException iOException) {
            this.manager.getContext().getLogger().error((Object)"Error getting keys", (Throwable)iOException);
            return;
        }
        if (this.manager.getContext().getLogger().isDebugEnabled()) {
            this.manager.getContext().getLogger().debug((Object)(this.getStoreName() + ": processExpires check number of " + stringArray.length + " sessions"));
        }
        long l = System.currentTimeMillis();
        for (String string : stringArray) {
            try {
                int n;
                StandardSession standardSession = (StandardSession)this.load(string);
                if (standardSession == null || (n = (int)((l - standardSession.getThisAccessedTime()) / 1000L)) < standardSession.getMaxInactiveInterval()) continue;
                if (this.manager.getContext().getLogger().isDebugEnabled()) {
                    this.manager.getContext().getLogger().debug((Object)(this.getStoreName() + ": processExpires expire store session " + string));
                }
                boolean bl = false;
                if (this.manager instanceof PersistentManagerBase) {
                    bl = ((PersistentManagerBase)this.manager).isLoaded(string);
                } else {
                    try {
                        if (this.manager.findSession(string) != null) {
                            bl = true;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (bl) {
                    standardSession.recycle();
                } else {
                    standardSession.expire();
                }
                this.remove(string);
            }
            catch (Exception exception) {
                this.manager.getContext().getLogger().error((Object)("Session: " + string + "; "), (Throwable)exception);
                try {
                    this.remove(string);
                }
                catch (IOException iOException) {
                    this.manager.getContext().getLogger().error((Object)"Error removing key", (Throwable)iOException);
                }
            }
        }
    }

    protected ObjectInputStream getObjectInputStream(InputStream inputStream) throws IOException {
        CustomObjectInputStream customObjectInputStream;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (this.manager instanceof ManagerBase) {
            ManagerBase managerBase = (ManagerBase)this.manager;
            customObjectInputStream = new CustomObjectInputStream(bufferedInputStream, classLoader, this.manager.getContext().getLogger(), managerBase.getSessionAttributeValueClassNamePattern(), managerBase.getWarnOnSessionAttributeFilterFailure());
        } else {
            customObjectInputStream = new CustomObjectInputStream(bufferedInputStream, classLoader);
        }
        return customObjectInputStream;
    }

    @Override
    protected void initInternal() {
    }

    @Override
    protected synchronized void startInternal() throws LifecycleException {
        this.setState(LifecycleState.STARTING);
    }

    @Override
    protected synchronized void stopInternal() throws LifecycleException {
        this.setState(LifecycleState.STOPPING);
    }

    @Override
    protected void destroyInternal() {
    }

    public String toString() {
        return ToStringUtil.toString((Object)this, this.manager);
    }
}

