/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.image;

import java.awt.BorderLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.commons.configuration.FileConfiguration;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.httppanel.Message;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelView;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelViewModel;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelViewModelEvent;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelViewModelListener;

public class ResponseImageView
implements HttpPanelView,
HttpPanelViewModelListener {
    public static final String NAME = "ResponseImageView";
    public static final String CAPTION_NAME = Constant.messages.getString("http.panel.view.image.name");
    private JPanel mainPanel;
    private JLabel imageLabel;
    private HttpPanelViewModel model;

    public ResponseImageView(HttpPanelViewModel model) {
        this.model = model;
        this.imageLabel = new JLabel();
        this.imageLabel.setVerticalAlignment(1);
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add(new JScrollPane(this.imageLabel));
        this.model.addHttpPanelViewModelListener(this);
    }

    @Override
    public void save() {
    }

    @Override
    public void setSelected(boolean selected) {
        if (selected) {
            this.imageLabel.requestFocusInWindow();
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getCaptionName() {
        return CAPTION_NAME;
    }

    @Override
    public String getTargetViewName() {
        return "";
    }

    @Override
    public int getPosition() {
        return 1;
    }

    @Override
    public boolean isEnabled(Message aMessage) {
        return ResponseImageView.isImage(aMessage);
    }

    @Override
    public boolean hasChanged() {
        return false;
    }

    @Override
    public JComponent getPane() {
        return this.mainPanel;
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public void setEditable(boolean editable) {
    }

    @Override
    public void setParentConfigurationKey(String configurationKey) {
    }

    @Override
    public void loadConfiguration(FileConfiguration fileConfiguration) {
    }

    @Override
    public void saveConfiguration(FileConfiguration fileConfiguration) {
    }

    @Override
    public HttpPanelViewModel getModel() {
        return this.model;
    }

    @Override
    public void dataChanged(HttpPanelViewModelEvent e) {
        HttpMessage httpMessage = (HttpMessage)this.model.getMessage();
        if (ResponseImageView.isImage(httpMessage)) {
            this.imageLabel.setIcon(new ImageIcon(httpMessage.getResponseBody().getBytes()));
        } else {
            this.imageLabel.setIcon(null);
        }
    }

    static boolean isImage(Message aMessage) {
        if (aMessage instanceof HttpMessage) {
            HttpMessage httpMessage = (HttpMessage)aMessage;
            if (httpMessage.getResponseBody().length() == 0) {
                return false;
            }
            return httpMessage.getResponseHeader().isImage();
        }
        return false;
    }
}

