/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.reader;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jooq.BatchBindStep;
import org.opensearch.performanceanalyzer.commons.event_process.Event;
import org.opensearch.performanceanalyzer.commons.event_process.EventProcessor;
import org.opensearch.performanceanalyzer.commons.metrics.AllMetrics;
import org.opensearch.performanceanalyzer.reader.ClusterManagerThrottlingMetricsSnapshot;

public class ClusterManagerThrottlingMetricsEventProcessor
implements EventProcessor {
    private static final Logger LOG = LogManager.getLogger(ClusterManagerThrottlingMetricsEventProcessor.class);
    private final ClusterManagerThrottlingMetricsSnapshot clusterManagerThrottlingMetricsSnapshot;
    private BatchBindStep handle;
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final TypeReference<HashMap<String, String>> TYPE_REF = new TypeReference<HashMap<String, String>>(){};

    private ClusterManagerThrottlingMetricsEventProcessor(ClusterManagerThrottlingMetricsSnapshot snapshot) {
        this.clusterManagerThrottlingMetricsSnapshot = snapshot;
    }

    static ClusterManagerThrottlingMetricsEventProcessor buildClusterManagerThrottlingMetricEventsProcessor(long currWindowStartTime, Connection conn, NavigableMap<Long, ClusterManagerThrottlingMetricsSnapshot> clusterManagerThroEventMetricsMap) {
        ClusterManagerThrottlingMetricsSnapshot clusterManagerThrottlingSnapshot = (ClusterManagerThrottlingMetricsSnapshot)clusterManagerThroEventMetricsMap.get(currWindowStartTime);
        if (clusterManagerThrottlingSnapshot == null) {
            clusterManagerThrottlingSnapshot = new ClusterManagerThrottlingMetricsSnapshot(conn, currWindowStartTime);
            clusterManagerThroEventMetricsMap.put(currWindowStartTime, clusterManagerThrottlingSnapshot);
        }
        return new ClusterManagerThrottlingMetricsEventProcessor(clusterManagerThrottlingSnapshot);
    }

    public void initializeProcessing(long startTime, long endTime) {
        this.handle = this.clusterManagerThrottlingMetricsSnapshot.startBatchPut();
    }

    public void finalizeProcessing() {
        if (this.handle.size() > 0) {
            this.handle.execute();
        }
        LOG.debug("Final CLusterManager Throttling metrics {}", this.clusterManagerThrottlingMetricsSnapshot.fetchAll());
    }

    public void processEvent(Event event) {
        String[] lines;
        for (String line : lines = event.value.split(System.lineSeparator())) {
            Map<String, String> clusterManagerThrottlingMap = ClusterManagerThrottlingMetricsEventProcessor.extractEntryData(line);
            if (clusterManagerThrottlingMap.containsKey("current_time")) continue;
            try {
                this.handle.bind(new Object[]{Long.parseLong(clusterManagerThrottlingMap.get(AllMetrics.ClusterManagerThrottlingValue.DATA_RETRYING_TASK_COUNT.toString())), Long.parseLong(clusterManagerThrottlingMap.get(AllMetrics.ClusterManagerThrottlingValue.CLUSTER_MANAGER_THROTTLED_PENDING_TASK_COUNT.toString()))});
            }
            catch (Exception ex) {
                LOG.error("Fail to get cluster_manager throttling metrics ", (Throwable)ex);
            }
        }
    }

    public boolean shouldProcessEvent(Event event) {
        return event.key.contains("cluster_manager_throttling_metrics");
    }

    public void commitBatchIfRequired() {
        if (this.handle.size() > 500) {
            this.handle.execute();
            this.handle = this.clusterManagerThrottlingMetricsSnapshot.startBatchPut();
        }
    }

    static Map<String, String> extractEntryData(String line) {
        try {
            return (Map)MAPPER.readValue(line, TYPE_REF);
        }
        catch (IOException ioe) {
            LOG.error("Error occurred while parsing tmp file", (Throwable)ioe);
            return new HashMap<String, String>();
        }
    }
}

