/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.core.ui.actions;

import java.awt.event.ActionEvent;
import java.util.Set;
import org.graalvm.visualvm.core.datasupport.Utils;
import org.graalvm.visualvm.core.snapshot.Snapshot;
import org.graalvm.visualvm.core.ui.actions.MultiDataSourceAction;
import org.openide.util.NbBundle;

class DeleteSnapshotAction
extends MultiDataSourceAction<Snapshot> {
    private static DeleteSnapshotAction instance;

    public static DeleteSnapshotAction instance() {
        if (instance == null) {
            instance = new DeleteSnapshotAction();
        }
        return instance;
    }

    @Override
    protected void actionPerformed(Set<Snapshot> snapshots, ActionEvent actionEvent) {
        for (Snapshot snapshot : snapshots) {
            snapshot.delete();
        }
    }

    @Override
    protected boolean isEnabled(Set<Snapshot> snapshots) {
        for (Snapshot snapshot : snapshots) {
            if (snapshot.supportsDelete()) continue;
            return false;
        }
        return Utils.areDataSourcesIndependent(snapshots);
    }

    private DeleteSnapshotAction() {
        super(Snapshot.class);
        this.putValue("Name", NbBundle.getMessage(DeleteSnapshotAction.class, (String)"LBL_Delete"));
        this.putValue("ShortDescription", NbBundle.getMessage(DeleteSnapshotAction.class, (String)"LBL_Delete_Snapshot"));
    }
}

