/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapdump.impl;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.ui.actions.ActionUtils;
import org.graalvm.visualvm.core.ui.actions.MultiDataSourceAction;
import org.graalvm.visualvm.coredump.CoreDump;
import org.graalvm.visualvm.heapdump.HeapDumpSupport;
import org.openide.util.NbBundle;

class HeapDumpAction
extends MultiDataSourceAction<DataSource> {
    private Set<Application> lastSelectedApplications = new HashSet<Application>();
    private final PropertyChangeListener stateListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            HeapDumpAction.this.updateState(ActionUtils.getSelectedDataSources());
        }
    };
    private static HeapDumpAction INSTANCE;

    public static synchronized HeapDumpAction instance() {
        if (INSTANCE == null) {
            INSTANCE = new HeapDumpAction();
        }
        return INSTANCE;
    }

    protected void actionPerformed(Set<DataSource> dataSources, ActionEvent actionEvent) {
        HeapDumpSupport support = HeapDumpSupport.getInstance();
        for (DataSource dataSource : dataSources) {
            if (dataSource instanceof Application) {
                boolean tagged;
                Application application = (Application)dataSource;
                boolean bl = tagged = (actionEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0;
                if (application.isLocalApplication()) {
                    support.takeHeapDump(application, !tagged);
                    continue;
                }
                support.takeRemoteHeapDump(application, null, !tagged);
                continue;
            }
            if (!(dataSource instanceof CoreDump)) continue;
            CoreDump coreDump = (CoreDump)dataSource;
            support.takeHeapDump(coreDump, (actionEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) == 0);
        }
    }

    protected boolean isEnabled(Set<DataSource> dataSources) {
        HeapDumpSupport support = HeapDumpSupport.getInstance();
        for (DataSource dataSource : dataSources) {
            if (dataSource instanceof Application) {
                Application application = (Application)dataSource;
                this.lastSelectedApplications.add(application);
                application.addPropertyChangeListener("prop_state", this.stateListener);
                if (application.getState() != 1) {
                    return false;
                }
                if (!(application.isLocalApplication() ? !support.supportsHeapDump(application) : !support.supportsRemoteHeapDump(application))) continue;
                return false;
            }
            if (dataSource instanceof CoreDump) continue;
            return false;
        }
        return true;
    }

    protected void updateState(Set<DataSource> dataSources) {
        if (!this.lastSelectedApplications.isEmpty()) {
            for (Application application : this.lastSelectedApplications) {
                application.removePropertyChangeListener("prop_state", this.stateListener);
            }
        }
        this.lastSelectedApplications.clear();
        super.updateState(dataSources);
    }

    private HeapDumpAction() {
        super(DataSource.class);
        this.putValue("Name", NbBundle.getMessage(HeapDumpAction.class, (String)"MSG_Heap_Dump"));
        this.putValue("ShortDescription", NbBundle.getMessage(HeapDumpAction.class, (String)"LBL_Heap_Dump"));
    }
}

