// Copyright Amazon.com Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
import { _encryptStream } from './encrypt_stream';
import { _encrypt } from './encrypt';
import { CommitmentPolicy, needs, } from '@aws-crypto/material-management-node';
export function buildEncrypt(options = {}) {
    const { commitmentPolicy = CommitmentPolicy.REQUIRE_ENCRYPT_REQUIRE_DECRYPT, maxEncryptedDataKeys = false, } = typeof options === 'string' ? { commitmentPolicy: options } : options;
    /* Precondition: node buildEncrypt needs a valid commitmentPolicy. */
    needs(CommitmentPolicy[commitmentPolicy], 'Invalid commitment policy.');
    /* Precondition: node buildEncrypt needs a valid maxEncryptedDataKeys. */
    needs(maxEncryptedDataKeys === false || maxEncryptedDataKeys >= 1, 'Invalid maxEncryptedDataKeys value.');
    const clientOptions = {
        commitmentPolicy,
        maxEncryptedDataKeys,
    };
    return {
        encryptStream: _encryptStream.bind({}, clientOptions),
        encrypt: _encrypt.bind({}, clientOptions),
    };
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZW5jcnlwdF9jbGllbnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvZW5jcnlwdF9jbGllbnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsb0VBQW9FO0FBQ3BFLHNDQUFzQztBQUV0QyxPQUFPLEVBQUUsY0FBYyxFQUFFLE1BQU0sa0JBQWtCLENBQUE7QUFDakQsT0FBTyxFQUFFLFFBQVEsRUFBRSxNQUFNLFdBQVcsQ0FBQTtBQUNwQyxPQUFPLEVBQ0wsZ0JBQWdCLEVBRWhCLEtBQUssR0FDTixNQUFNLHNDQUFzQyxDQUFBO0FBUzdDLE1BQU0sVUFBVSxZQUFZLENBQzFCLFVBQXFELEVBQUU7SUFPdkQsTUFBTSxFQUNKLGdCQUFnQixHQUFHLGdCQUFnQixDQUFDLCtCQUErQixFQUNuRSxvQkFBb0IsR0FBRyxLQUFLLEdBQzdCLEdBQUcsT0FBTyxPQUFPLEtBQUssUUFBUSxDQUFDLENBQUMsQ0FBQyxFQUFFLGdCQUFnQixFQUFFLE9BQU8sRUFBRSxDQUFDLENBQUMsQ0FBQyxPQUFPLENBQUE7SUFFekUscUVBQXFFO0lBQ3JFLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxnQkFBZ0IsQ0FBQyxFQUFFLDRCQUE0QixDQUFDLENBQUE7SUFDdkUseUVBQXlFO0lBQ3pFLEtBQUssQ0FDSCxvQkFBb0IsS0FBSyxLQUFLLElBQUksb0JBQW9CLElBQUksQ0FBQyxFQUMzRCxxQ0FBcUMsQ0FDdEMsQ0FBQTtJQUVELE1BQU0sYUFBYSxHQUFrQjtRQUNuQyxnQkFBZ0I7UUFDaEIsb0JBQW9CO0tBQ3JCLENBQUE7SUFDRCxPQUFPO1FBQ0wsYUFBYSxFQUFFLGNBQWMsQ0FBQyxJQUFJLENBQUMsRUFBRSxFQUFFLGFBQWEsQ0FBQztRQUNyRCxPQUFPLEVBQUUsUUFBUSxDQUFDLElBQUksQ0FBQyxFQUFFLEVBQUUsYUFBYSxDQUFDO0tBQzFDLENBQUE7QUFDSCxDQUFDIn0=