/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import net.sf.sdedit.icons.Icons;

public class ToolBar
extends JToolBar {
    private Map<String, JButton> buttonMap = new HashMap<String, JButton>();

    private static String getId(Action action) {
        String id = (String)action.getValue("ActionID");
        if (id == null) {
            throw new IllegalArgumentException("no id defined for action with name " + action.getValue("Name"));
        }
        return id;
    }

    private static Action makeToolbarAction(final Action action) {
        return new AbstractAction(){
            {
                this.putValue("Name", action.getValue("Name"));
                this.putValue("ShortDescription", action.getValue("ShortDescription"));
                String iconName = (String)action.getValue("IconName");
                if (iconName != null) {
                    ImageIcon icon = Icons.getIcon("large/" + iconName);
                    this.putValue("SmallIcon", icon);
                } else {
                    this.putValue("SmallIcon", action.getValue("SmallIcon"));
                }
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                action.actionPerformed(e);
            }
        };
    }

    public void disableAction(String id) {
    }

    public void updateAction(Action action) {
        JButton button = this.buttonMap.get(ToolBar.getId(action));
        if (button == null) {
            throw new IllegalArgumentException("no button for action with name " + action.getValue("Name"));
        }
        button.setAction(ToolBar.makeToolbarAction(action));
    }

    public JButton addAction(Action action) {
        JButton button = super.add(ToolBar.makeToolbarAction(action));
        button.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 5));
        button.setOpaque(false);
        button.setMargin(new Insets(1, 1, 1, 1));
        this.buttonMap.put(ToolBar.getId(action), button);
        return button;
    }

    @Override
    public void addSeparator() {
        JSeparator sep = new JSeparator();
        sep.setOrientation(1);
        Dimension size = new Dimension(10, 25);
        sep.setMinimumSize(size);
        sep.setPreferredSize(size);
        sep.setMaximumSize(size);
        super.add(sep);
    }
}

