/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import javax.swing.Icon;
import org.openide.util.VectorIcon;

final class AquaVectorCloseButton
extends VectorIcon {
    public static final Icon DEFAULT = new AquaVectorCloseButton(State.DEFAULT);
    public static final Icon PRESSED = new AquaVectorCloseButton(State.PRESSED);
    public static final Icon ROLLOVER = new AquaVectorCloseButton(State.ROLLOVER);
    private final State state;

    private AquaVectorCloseButton(State state) {
        super(14, 12);
        this.state = state;
    }

    protected void paintIcon(Component component, Graphics2D graphics2D, int n, int n2, double d) {
        double d2;
        double d3;
        double d4 = Math.min(n, n2);
        Color color = new Color(0, 0, 0, 0);
        Color color2 = new Color(0, 0, 0, 168);
        if (this.state == State.ROLLOVER) {
            color2 = Color.WHITE;
            color = new Color(125, 125, 125, 215);
        } else if (this.state == State.PRESSED) {
            color2 = Color.WHITE;
            color = new Color(105, 105, 105, 215);
        }
        if (color.getAlpha() > 0) {
            d3 = ((double)n - d4) / 2.0;
            d2 = ((double)n2 - d4) / 2.0;
            Ellipse2D.Double double_ = new Ellipse2D.Double(d3, d2, d4, d4);
            graphics2D.setColor(color);
            graphics2D.fill(double_);
        }
        graphics2D.setColor(color2);
        d3 = 1.4 * d;
        d2 = (double)n / 2.0;
        double d5 = (double)n2 / 2.0;
        double d6 = 0.45 * (d4 / 2.0);
        BasicStroke basicStroke = new BasicStroke((float)d3, 1, 1);
        Area area = new Area();
        area.add(new Area(basicStroke.createStrokedShape(new Line2D.Double(d2 - d6, d5 - d6, d2 + d6, d5 + d6))));
        area.add(new Area(basicStroke.createStrokedShape(new Line2D.Double(d2 + d6, d5 - d6, d2 - d6, d5 + d6))));
        graphics2D.fill(area);
    }

    private static enum State {
        DEFAULT,
        PRESSED,
        ROLLOVER;

    }
}

