/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.templates;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.api.templates.CreateDescriptor;
import org.netbeans.api.templates.CreateFromTemplateAttributes;
import org.netbeans.api.templates.CreateFromTemplateDecorator;
import org.netbeans.api.templates.CreateFromTemplateHandler;
import org.netbeans.api.templates.FileBuilder;
import org.netbeans.modules.templates.ScriptingCreateFromTemplateHandler;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.MapFormat;
import org.openide.util.Parameters;

final class CreateFromTemplateImpl {
    private static final Logger LOG = Logger.getLogger(CreateFromTemplateImpl.class.getName());
    private static final String NEWLINE = "\n";
    private final FileBuilder builder;
    private final CreateDescriptor desc;
    private Map<String, ?> originalParams;
    private List<CreateFromTemplateDecorator> decorators;
    private CreateFromTemplateHandler handler;

    private CreateFromTemplateImpl(FileBuilder fileBuilder) {
        this.builder = fileBuilder;
        this.desc = fileBuilder.getDescriptor();
    }

    static List<FileObject> build(FileBuilder fileBuilder) throws IOException {
        CreateFromTemplateImpl createFromTemplateImpl = new CreateFromTemplateImpl(fileBuilder);
        AtomicReference atomicReference = new AtomicReference();
        createFromTemplateImpl.desc.getTarget().getFileSystem().runAtomicAction(() -> atomicReference.set(createFromTemplateImpl.build(createFromTemplateImpl.prepare())));
        return (List)atomicReference.get();
    }

    static void collectAttributes(FileBuilder fileBuilder) {
        CreateFromTemplateImpl createFromTemplateImpl = new CreateFromTemplateImpl(fileBuilder);
        CreateFromTemplateImpl.computeEffectiveName(createFromTemplateImpl.desc);
        fileBuilder.withParameters(createFromTemplateImpl.findTemplateParameters());
    }

    private void setupDecorators() {
        this.decorators = new ArrayList<CreateFromTemplateDecorator>(Lookup.getDefault().lookupAll(CreateFromTemplateDecorator.class));
        Iterator<CreateFromTemplateDecorator> iterator = this.decorators.iterator();
        while (iterator.hasNext()) {
            CreateFromTemplateDecorator createFromTemplateDecorator = iterator.next();
            if (createFromTemplateDecorator.accept(this.desc)) continue;
            iterator.remove();
        }
    }

    List<FileObject> prepare() throws IOException {
        FileObject fileObject = this.desc.getTemplate();
        FileObject fileObject2 = this.desc.getTarget();
        FileBuilder.Mode mode = this.builder.defaultMode;
        Format format = this.builder.format;
        Parameters.notNull((CharSequence)"f", (Object)fileObject);
        Parameters.notNull((CharSequence)"folder", (Object)fileObject2);
        assert (mode != FileBuilder.Mode.FORMAT || format != null) : "Format must be provided for Mode.FORMAT";
        if (!fileObject2.isFolder()) {
            throw new IllegalArgumentException("Not a folder: " + fileObject2);
        }
        this.findTemplateParameters();
        this.setupDecorators();
        CreateFromTemplateImpl.computeEffectiveName(this.desc);
        List<FileObject> list = this.callDecorators(true, new ArrayList<FileObject>());
        CreateFromTemplateImpl.computeEffectiveName(this.desc);
        this.handler = Stream.concat(this.desc.getLookup().lookupAll(CreateFromTemplateHandler.class).stream(), Lookup.getDefault().lookupAll(CreateFromTemplateHandler.class).stream()).filter(createFromTemplateHandler -> createFromTemplateHandler.accept(this.desc)).findFirst().orElse((CreateFromTemplateHandler)fileObject.getAttribute("template.createTemplateHandler"));
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<FileObject> build(List<FileObject> list) throws IOException {
        try {
            List<FileObject> list2 = null;
            if (this.handler != null) {
                list2 = this.handler.createFromTemplate(this.desc);
                assert (list2 != null && !list2.isEmpty());
            }
            if (list2 == null && this.builder.defaultMode != FileBuilder.Mode.FAIL) {
                list2 = this.defaultCreate();
            }
            if (list2 == null) {
                List<FileObject> list3 = list2;
                return list3;
            }
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>(list2);
            arrayList.addAll(list);
            this.callDecorators(false, arrayList);
            ArrayList<FileObject> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            this.builder.getDescriptor().parameters = this.originalParams;
        }
    }

    private List<FileObject> callDecorators(boolean bl, List<FileObject> list) throws IOException {
        for (CreateFromTemplateDecorator createFromTemplateDecorator : this.decorators) {
            List<FileObject> list2;
            if (!(bl ? createFromTemplateDecorator.isBeforeCreation() : createFromTemplateDecorator.isAfterCreation()) || (list2 = createFromTemplateDecorator.decorate(this.desc, list)) == null) continue;
            list2.removeAll(list);
            list.addAll(list2);
        }
        return list;
    }

    static String interpolateName(ScriptEngine scriptEngine, String string, Map<String, ?> map, FileObject fileObject) {
        if (scriptEngine == null) {
            return CreateFromTemplateHandler.mapParameters(string, map);
        }
        Bindings bindings = scriptEngine.getContext().getBindings(100);
        bindings.putAll((Map<? extends String, ? extends Object>)map);
        bindings.put("name", (Object)string);
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            scriptEngine.getContext().setWriter(printWriter);
            scriptEngine.getContext().setAttribute(FileObject.class.getName() + ".owner", fileObject, 100);
            scriptEngine.getContext().setAttribute("javax.script.filename", fileObject.getNameExt(), 100);
            scriptEngine.eval(string);
            printWriter.flush();
            return stringWriter.toString();
        }
        catch (ScriptException scriptException) {
            LOG.log(Level.SEVERE, "Errors encountered during interpolation of {0}", string);
            LOG.log(Level.SEVERE, "Cannot interpolate name", scriptException);
            return string;
        }
    }

    static void computeEffectiveName(CreateDescriptor createDescriptor) {
        String string = createDescriptor.getName();
        if (string == null) {
            boolean bl;
            Object object = createDescriptor.getParameters().get("name");
            ScriptEngine scriptEngine = ScriptingCreateFromTemplateHandler.engine(createDescriptor.getTemplate());
            String string2 = object instanceof String ? object.toString() : createDescriptor.getTemplate().getName();
            string = CreateFromTemplateImpl.interpolateName(scriptEngine, string2, createDescriptor.getParameters(), createDescriptor.getTemplate());
            boolean bl2 = bl = Boolean.TRUE.equals(createDescriptor.getValue("template.mergeFolders")) || Boolean.TRUE.equals(createDescriptor.getTemplate().getAttribute("template.mergeFolders"));
            if (createDescriptor.getTemplate().isFolder() && bl) {
                createDescriptor.parameters.put("template.mergeFolders", Boolean.TRUE);
            } else {
                string = FileUtil.findFreeFileName((FileObject)createDescriptor.getTarget(), (String)string, (String)createDescriptor.getTemplate().getExt());
            }
        }
        createDescriptor.proposedName = string;
    }

    public Map<String, Object> findTemplateParameters() {
        Map<String, ?> map;
        Object object2;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.putAll(this.desc.getParameters());
        this.originalParams = this.desc.parameters;
        this.desc.parameters = hashMap;
        for (Object object2 : Lookup.getDefault().lookupAll(CreateFromTemplateAttributes.class)) {
            map = object2.attributesFor(this.desc);
            if (map == null) continue;
            for (Map.Entry<String, ?> entry : map.entrySet()) {
                if (this.originalParams != null && this.originalParams.containsKey(entry.getKey())) continue;
                hashMap.put(entry.getKey(), entry.getValue());
            }
        }
        Object object3 = this.desc.getName();
        if (object3 == null) {
            object3 = this.desc.getProposedName();
        }
        if (!hashMap.containsKey("name") && object3 != null) {
            object2 = object3;
            if (this.desc.hasFreeExtension()) {
                object2 = ((String)object3).replaceFirst("[.].*", "");
            }
            hashMap.put("name", object2);
        }
        object2 = new Date();
        if (!hashMap.containsKey("dateTime")) {
            hashMap.put("dateTime", object2);
        }
        map = this.desc.getTemplate().getExt();
        if (!hashMap.containsKey("nameAndExt") && object3 != null) {
            if (!(map == null || ((String)((Object)map)).length() <= 0 || this.originalParams == null || this.desc.hasFreeExtension() && ((String)object3).indexOf(46) != -1)) {
                hashMap.put("nameAndExt", (String)object3 + '.' + (String)((Object)map));
            } else {
                hashMap.put("nameAndExt", object3);
            }
        }
        return hashMap;
    }

    private List<FileObject> defaultCreateFolder() throws IOException {
        String string = this.desc.getProposedName();
        FileObject fileObject = FileUtil.createFolder((FileObject)this.desc.getTarget(), (String)string);
        CreateFromTemplateHandler.copyAttributesFromTemplate(null, this.desc.getTemplate(), fileObject);
        return CreateFromTemplateHandler.defaultCopyContents(this.desc, this.desc.getTemplate(), fileObject);
    }

    private List<FileObject> defaultCreate() throws IOException {
        Object object2;
        Object object3;
        FileObject fileObject;
        if (this.desc.getTemplate().isFolder()) {
            return this.defaultCreateFolder();
        }
        Map<String, Object> map = this.desc.getParameters();
        FileBuilder.Mode mode = this.builder.defaultMode;
        Format format = this.builder.format;
        if (mode != FileBuilder.Mode.COPY && format instanceof MapFormat) {
            fileObject = (MapFormat)format;
            object3 = fileObject.getMap();
            object2 = null;
            for (String object4 : map.keySet()) {
                if (object3.containsKey(object4)) continue;
                if (object2 == null) {
                    object2 = new HashMap(object3);
                }
                object2.put(object4, map.get(object4));
            }
            if (object2 != null) {
                fileObject.setMap((Map)object2);
            }
        }
        fileObject = this.desc.getTemplate();
        object3 = this.desc.getTemplate().getExt();
        object2 = this.desc.getTarget().createData(this.desc.getProposedName(), (String)object3);
        boolean bl = false;
        Charset charset = FileEncodingQuery.getEncoding((FileObject)fileObject);
        boolean bl2 = false;
        FileLock fileLock = object2.lock();
        try (InputStream scriptException = fileObject.getInputStream();
             InputStreamReader inputStreamReader = new InputStreamReader(scriptException, charset);
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            bl = this.desc.isPreformatted();
            Charset charset2 = FileEncodingQuery.getEncoding((FileObject)object2);
            ScriptEngine scriptEngine = this.desc.isPreformatted() ? null : ScriptingCreateFromTemplateHandler.indentEngine();
            StringWriter stringWriter = new StringWriter();
            try (OutputStream outputStream = object2.getOutputStream(fileLock);
                 OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, charset2);
                 Writer writer = bl || scriptEngine == null ? outputStreamWriter : stringWriter;){
                String string;
                String string2 = null;
                while ((string = bufferedReader.readLine()) != null) {
                    if (string2 != null) {
                        writer.append(NEWLINE);
                    }
                    string2 = format != null ? format.format(string) : string;
                    writer.append(string2);
                }
                writer.append(NEWLINE);
                writer.flush();
                if (scriptEngine != null) {
                    scriptEngine.getContext().setAttribute("mimeType", fileObject.getMIMEType(), 100);
                    scriptEngine.getContext().setWriter(outputStreamWriter);
                    scriptEngine.eval(new StringReader(stringWriter.toString()));
                }
            }
            CreateFromTemplateHandler.copyAttributesFromTemplate(null, fileObject, object2);
            bl2 = true;
        }
        catch (IOException iOException) {
            try {
                object2.delete(fileLock);
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            throw iOException;
        }
        catch (ScriptException scriptException2) {
            IOException iOException = scriptException2.getCause() instanceof IOException ? (IOException)scriptException2.getCause() : null;
            try {
                object2.delete(fileLock);
            }
            catch (IOException iOException3) {
                // empty catch block
            }
            throw iOException == null ? new IOException(scriptException2) : iOException;
        }
        finally {
            if (!bl2) {
                object2.delete(fileLock);
            }
            fileLock.releaseLock();
        }
        return Collections.singletonList(object2);
    }
}

