/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.Foreign;
import com.kenai.jffi.Platform;

public abstract class PageManager {
    public static final int PROT_EXEC = 4;
    public static final int PROT_READ = 1;
    public static final int PROT_WRITE = 2;
    private final Foreign foreign = Foreign.getInstance();
    private int pageSize;

    public static PageManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public final long pageSize() {
        return this.pageSize != 0 ? (long)this.pageSize : this.calculatePageSize();
    }

    private long calculatePageSize() {
        long l;
        long pgSize = Foreign.pageSize();
        if (pgSize < Integer.MAX_VALUE) {
            this.pageSize = (int)pgSize;
            l = this.pageSize;
        } else {
            l = pgSize;
        }
        return l;
    }

    public abstract long allocatePages(int var1, int var2);

    public abstract void freePages(long var1, int var3);

    public abstract void protectPages(long var1, int var3, int var4);

    private static final class SingletonHolder {
        public static final PageManager INSTANCE = Platform.getPlatform().getOS() == Platform.OS.WINDOWS ? new Windows() : new Unix();

        private SingletonHolder() {
        }
    }

    static final class Windows
    extends PageManager {
        @Override
        public long allocatePages(int pageCount, int protection) {
            return Foreign.VirtualAlloc(0L, (int)this.pageSize() * pageCount, 12288, Windows.w32prot(protection));
        }

        @Override
        public void freePages(long address2, int pageCount) {
            Foreign.VirtualFree(address2, 0, 32768);
        }

        @Override
        public void protectPages(long address2, int pageCount, int protection) {
            Foreign.VirtualProtect(address2, (int)this.pageSize() * pageCount, Windows.w32prot(protection));
        }

        private static int w32prot(int p2) {
            int w32 = 1;
            if ((p2 & 3) == 3) {
                w32 = 4;
            } else if ((p2 & 1) == 1) {
                w32 = 2;
            }
            if ((p2 & 4) == 4) {
                w32 <<= 4;
            }
            return w32;
        }
    }

    static final class Unix
    extends PageManager {
        Unix() {
        }

        @Override
        public long allocatePages(int npages, int protection) {
            long sz = (long)npages * this.pageSize();
            long memory = Foreign.mmap(0L, sz, protection, 258, -1, 0L);
            return memory != -1L ? memory : 0L;
        }

        @Override
        public void freePages(long address2, int npages) {
            Foreign.munmap(address2, (long)npages * this.pageSize());
        }

        @Override
        public void protectPages(long address2, int npages, int protection) {
            Foreign.mprotect(address2, (long)npages * this.pageSize(), protection);
        }
    }
}

