/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import java.nio.ByteOrder;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.AbstractMemory;
import org.jruby.ext.ffi.Factory;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.Pointer;
import org.jruby.ext.ffi.SwappedMemoryIO;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"FFI::Buffer"}, parent="FFI::AbstractMemory")
public final class Buffer
extends AbstractMemory {
    public static final int IN = 1;
    public static final int OUT = 2;
    private int inout;

    public static RubyClass createBufferClass(Ruby runtime2, RubyModule module) {
        RubyClass result2 = module.defineClassUnder("Buffer", module.getClass("AbstractMemory"), Buffer::new);
        result2.defineAnnotatedMethods(Buffer.class);
        result2.defineAnnotatedConstants(Buffer.class);
        return result2;
    }

    public Buffer(Ruby runtime2, RubyClass klass) {
        super(runtime2, klass, runtime2.getFFI().getNullMemoryIO(), 0L, 0);
        this.inout = 3;
    }

    public Buffer(Ruby runtime2, int size2) {
        this(runtime2, size2, 3);
    }

    public Buffer(Ruby runtime2, int size2, int flags2) {
        this(runtime2, runtime2.getFFI().bufferClass, Buffer.allocateMemoryIO(runtime2, size2), size2, 1, flags2);
    }

    private Buffer(Ruby runtime2, IRubyObject klass, MemoryIO io2, long size2, int typeSize, int inout) {
        super(runtime2, (RubyClass)klass, io2, size2, typeSize);
        this.inout = inout;
    }

    private static final int getCount(IRubyObject countArg) {
        return countArg instanceof RubyFixnum ? RubyFixnum.fix2int(countArg) : 1;
    }

    private static Buffer allocate(ThreadContext context, IRubyObject recv2, IRubyObject sizeArg, int count2, int flags2) {
        int typeSize = Buffer.calculateTypeSize(context, sizeArg);
        int total2 = typeSize * count2;
        return new Buffer(context.runtime, recv2, Buffer.allocateMemoryIO(context.runtime, total2), total2, typeSize, flags2);
    }

    private IRubyObject init(ThreadContext context, IRubyObject rbTypeSize, int count2, int flags2, Block block) {
        this.typeSize = Buffer.calculateTypeSize(context, rbTypeSize);
        this.size = this.typeSize * count2;
        this.inout = flags2;
        this.setMemoryIO(Buffer.allocateMemoryIO(context.runtime, (int)this.size));
        if (block.isGiven()) {
            block.yield(context, this);
        }
        return this;
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject sizeArg, Block block) {
        return sizeArg instanceof RubyFixnum ? this.init(context, RubyFixnum.one(context.runtime), RubyFixnum.fix2int(sizeArg), 3, block) : this.init(context, sizeArg, 1, 3, block);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject sizeArg, IRubyObject arg2, Block block) {
        return this.init(context, sizeArg, Buffer.getCount(arg2), 3, block);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject sizeArg, IRubyObject countArg, IRubyObject clearArg, Block block) {
        return this.init(context, sizeArg, RubyFixnum.fix2int(countArg), 3, block);
    }

    @JRubyMethod(required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(ThreadContext context, IRubyObject other) {
        if (this == other) {
            return this;
        }
        Buffer orig = (Buffer)other;
        this.typeSize = orig.typeSize;
        this.size = orig.size;
        this.inout = orig.inout;
        this.setMemoryIO(orig.getMemoryIO().dup());
        return this;
    }

    @JRubyMethod(name={"alloc_inout", "__alloc_inout"}, meta=true)
    public static Buffer allocateInOut(ThreadContext context, IRubyObject recv2, IRubyObject sizeArg) {
        return Buffer.allocate(context, recv2, sizeArg, 1, 3);
    }

    @JRubyMethod(name={"alloc_inout", "__alloc_inout"}, meta=true)
    public static Buffer allocateInOut(ThreadContext context, IRubyObject recv2, IRubyObject sizeArg, IRubyObject arg2) {
        return Buffer.allocate(context, recv2, sizeArg, Buffer.getCount(arg2), 3);
    }

    @JRubyMethod(name={"alloc_inout", "__alloc_inout"}, meta=true)
    public static Buffer allocateInOut(ThreadContext context, IRubyObject recv2, IRubyObject sizeArg, IRubyObject countArg, IRubyObject clearArg) {
        return Buffer.allocate(context, recv2, sizeArg, RubyFixnum.fix2int(countArg), 3);
    }

    @JRubyMethod(name={"new_in", "alloc_in", "__alloc_in"}, meta=true)
    public static Buffer allocateInput(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        return Buffer.allocate(context, recv2, arg2, 1, 1);
    }

    @JRubyMethod(name={"new_in", "alloc_in", "__alloc_in"}, meta=true)
    public static Buffer allocateInput(ThreadContext context, IRubyObject recv2, IRubyObject sizeArg, IRubyObject arg2) {
        return Buffer.allocate(context, recv2, sizeArg, Buffer.getCount(arg2), 1);
    }

    @JRubyMethod(name={"new_in", "alloc_in", "__alloc_in"}, meta=true)
    public static Buffer allocateInput(ThreadContext context, IRubyObject recv2, IRubyObject sizeArg, IRubyObject countArg, IRubyObject clearArg) {
        return Buffer.allocate(context, recv2, sizeArg, RubyFixnum.fix2int(countArg), 1);
    }

    @JRubyMethod(name={"new_out", "alloc_out", "__alloc_out"}, meta=true)
    public static Buffer allocateOutput(ThreadContext context, IRubyObject recv2, IRubyObject sizeArg) {
        return Buffer.allocate(context, recv2, sizeArg, 1, 2);
    }

    @JRubyMethod(name={"new_out", "alloc_out", "__alloc_out"}, meta=true)
    public static Buffer allocateOutput(ThreadContext context, IRubyObject recv2, IRubyObject sizeArg, IRubyObject arg2) {
        return Buffer.allocate(context, recv2, sizeArg, Buffer.getCount(arg2), 2);
    }

    @JRubyMethod(name={"new_out", "alloc_out", "__alloc_out"}, meta=true)
    public static Buffer allocateOutput(ThreadContext context, IRubyObject recv2, IRubyObject sizeArg, IRubyObject countArg, IRubyObject clearArg) {
        return Buffer.allocate(context, recv2, sizeArg, RubyFixnum.fix2int(countArg), 2);
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext context) {
        return RubyString.newString(context.runtime, String.format("#<Buffer size=%d>", this.size));
    }

    @Override
    public final AbstractMemory order(Ruby runtime2, ByteOrder order2) {
        return new Buffer(runtime2, this.getMetaClass(), order2.equals(this.getMemoryIO().order()) ? this.getMemoryIO() : new SwappedMemoryIO(runtime2, this.getMemoryIO()), this.size, this.typeSize, this.inout);
    }

    @Override
    protected AbstractMemory slice(Ruby runtime2, long offset2) {
        return new Buffer(runtime2, this.getMetaClass(), this.getMemoryIO().slice(offset2), this.size - offset2, this.typeSize, this.inout);
    }

    @Override
    protected AbstractMemory slice(Ruby runtime2, long offset2, long size2) {
        return new Buffer(runtime2, this.getMetaClass(), this.getMemoryIO().slice(offset2, size2), size2, this.typeSize, this.inout);
    }

    @Override
    protected Pointer getPointer(Ruby runtime2, long offset2) {
        return new Pointer(runtime2, this.getMemoryIO().getMemoryIO(offset2));
    }

    public int getInOutFlags() {
        return this.inout;
    }

    private static MemoryIO allocateMemoryIO(Ruby runtime2, int size2) {
        return Factory.getInstance().allocateTransientDirectMemory(runtime2, size2, 8, true);
    }
}

