/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.asynchronous.context.permits;

import org.opensearch.common.lease.Releasable;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.opensearch.search.asynchronous.context.AsynchronousSearchContextId;
import org.opensearch.search.asynchronous.context.active.AsynchronousSearchContextClosedException;
import org.opensearch.search.asynchronous.context.permits.AsynchronousSearchContextPermits;

public class NoopAsynchronousSearchContextPermits
extends AsynchronousSearchContextPermits {
    public NoopAsynchronousSearchContextPermits(AsynchronousSearchContextId asynchronousSearchContextId) {
        super(asynchronousSearchContextId, null, null);
    }

    @Override
    public void asyncAcquirePermit(ActionListener<Releasable> onAcquired, TimeValue timeout, String reason) {
        if (this.closed) {
            logger.debug("Trying to acquire permit for closed context [{}]", (Object)this.asynchronousSearchContextId);
            onAcquired.onFailure((Exception)new AsynchronousSearchContextClosedException(this.asynchronousSearchContextId));
        } else {
            onAcquired.onResponse(() -> {});
        }
    }

    @Override
    public void asyncAcquireAllPermits(ActionListener<Releasable> onAcquired, TimeValue timeout, String reason) {
        throw new IllegalStateException("Acquiring all permits is not allowed for asynchronous search id" + this.asynchronousSearchContextId);
    }
}

