from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.gp import *
from OCC.Core.Geom2d import *
from OCC.Core.gce import *


class GCE2d_MakeMirror:
    @overload
    def __init__(self, Point: gp_Pnt2d) -> None: ...
    @overload
    def __init__(self, Axis: gp_Ax2d) -> None: ...
    @overload
    def __init__(self, Line: gp_Lin2d) -> None: ...
    @overload
    def __init__(self, Point: gp_Pnt2d, Direc: gp_Dir2d) -> None: ...
    def Value(self) -> Geom2d_Transformation: ...

class GCE2d_MakeRotation:
    def __init__(self, Point: gp_Pnt2d, Angle: float) -> None: ...
    def Value(self) -> Geom2d_Transformation: ...

class GCE2d_MakeScale:
    def __init__(self, Point: gp_Pnt2d, Scale: float) -> None: ...
    def Value(self) -> Geom2d_Transformation: ...

class GCE2d_MakeTranslation:
    @overload
    def __init__(self, Vect: gp_Vec2d) -> None: ...
    @overload
    def __init__(self, Point1: gp_Pnt2d, Point2: gp_Pnt2d) -> None: ...
    def Value(self) -> Geom2d_Transformation: ...

class GCE2d_Root:
    def IsDone(self) -> bool: ...
    def Status(self) -> gce_ErrorType: ...

class GCE2d_MakeArcOfCircle(GCE2d_Root):
    @overload
    def __init__(self, Circ: gp_Circ2d, Alpha1: float, Alpha2: float, Sense: Optional[bool] = True) -> None: ...
    @overload
    def __init__(self, Circ: gp_Circ2d, P: gp_Pnt2d, Alpha: float, Sense: Optional[bool] = True) -> None: ...
    @overload
    def __init__(self, Circ: gp_Circ2d, P1: gp_Pnt2d, P2: gp_Pnt2d, Sense: Optional[bool] = True) -> None: ...
    @overload
    def __init__(self, P1: gp_Pnt2d, P2: gp_Pnt2d, P3: gp_Pnt2d) -> None: ...
    @overload
    def __init__(self, P1: gp_Pnt2d, V: gp_Vec2d, P2: gp_Pnt2d) -> None: ...
    def Value(self) -> Geom2d_TrimmedCurve: ...

class GCE2d_MakeArcOfEllipse(GCE2d_Root):
    @overload
    def __init__(self, Elips: gp_Elips2d, Alpha1: float, Alpha2: float, Sense: Optional[bool] = True) -> None: ...
    @overload
    def __init__(self, Elips: gp_Elips2d, P: gp_Pnt2d, Alpha: float, Sense: Optional[bool] = True) -> None: ...
    @overload
    def __init__(self, Elips: gp_Elips2d, P1: gp_Pnt2d, P2: gp_Pnt2d, Sense: Optional[bool] = True) -> None: ...
    def Value(self) -> Geom2d_TrimmedCurve: ...

class GCE2d_MakeArcOfHyperbola(GCE2d_Root):
    @overload
    def __init__(self, Hypr: gp_Hypr2d, Alpha1: float, Alpha2: float, Sense: Optional[bool] = True) -> None: ...
    @overload
    def __init__(self, Hypr: gp_Hypr2d, P: gp_Pnt2d, Alpha: float, Sense: Optional[bool] = True) -> None: ...
    @overload
    def __init__(self, Hypr: gp_Hypr2d, P1: gp_Pnt2d, P2: gp_Pnt2d, Sense: Optional[bool] = True) -> None: ...
    def Value(self) -> Geom2d_TrimmedCurve: ...

class GCE2d_MakeArcOfParabola(GCE2d_Root):
    @overload
    def __init__(self, Parab: gp_Parab2d, Alpha1: float, Alpha2: float, Sense: Optional[bool] = True) -> None: ...
    @overload
    def __init__(self, Parab: gp_Parab2d, P: gp_Pnt2d, Alpha: float, Sense: Optional[bool] = True) -> None: ...
    @overload
    def __init__(self, Parab: gp_Parab2d, P1: gp_Pnt2d, P2: gp_Pnt2d, Sense: Optional[bool] = True) -> None: ...
    def Value(self) -> Geom2d_TrimmedCurve: ...

class GCE2d_MakeCircle(GCE2d_Root):
    @overload
    def __init__(self, C: gp_Circ2d) -> None: ...
    @overload
    def __init__(self, A: gp_Ax2d, Radius: float, Sense: Optional[bool] = True) -> None: ...
    @overload
    def __init__(self, A: gp_Ax22d, Radius: float) -> None: ...
    @overload
    def __init__(self, Circ: gp_Circ2d, Dist: float) -> None: ...
    @overload
    def __init__(self, Circ: gp_Circ2d, Point: gp_Pnt2d) -> None: ...
    @overload
    def __init__(self, P1: gp_Pnt2d, P2: gp_Pnt2d, P3: gp_Pnt2d) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt2d, Radius: float, Sense: Optional[bool] = True) -> None: ...
    @overload
    def __init__(self, Center: gp_Pnt2d, Point: gp_Pnt2d, Sense: Optional[bool] = True) -> None: ...
    def Value(self) -> Geom2d_Circle: ...

class GCE2d_MakeEllipse(GCE2d_Root):
    @overload
    def __init__(self, E: gp_Elips2d) -> None: ...
    @overload
    def __init__(self, MajorAxis: gp_Ax2d, MajorRadius: float, MinorRadius: float, Sense: Optional[bool] = True) -> None: ...
    @overload
    def __init__(self, Axis: gp_Ax22d, MajorRadius: float, MinorRadius: float) -> None: ...
    @overload
    def __init__(self, S1: gp_Pnt2d, S2: gp_Pnt2d, Center: gp_Pnt2d) -> None: ...
    def Value(self) -> Geom2d_Ellipse: ...

class GCE2d_MakeHyperbola(GCE2d_Root):
    @overload
    def __init__(self, H: gp_Hypr2d) -> None: ...
    @overload
    def __init__(self, MajorAxis: gp_Ax2d, MajorRadius: float, MinorRadius: float, Sense: bool) -> None: ...
    @overload
    def __init__(self, Axis: gp_Ax22d, MajorRadius: float, MinorRadius: float) -> None: ...
    @overload
    def __init__(self, S1: gp_Pnt2d, S2: gp_Pnt2d, Center: gp_Pnt2d) -> None: ...
    def Value(self) -> Geom2d_Hyperbola: ...

class GCE2d_MakeLine(GCE2d_Root):
    @overload
    def __init__(self, A: gp_Ax2d) -> None: ...
    @overload
    def __init__(self, L: gp_Lin2d) -> None: ...
    @overload
    def __init__(self, P: gp_Pnt2d, V: gp_Dir2d) -> None: ...
    @overload
    def __init__(self, Lin: gp_Lin2d, Point: gp_Pnt2d) -> None: ...
    @overload
    def __init__(self, Lin: gp_Lin2d, Dist: float) -> None: ...
    @overload
    def __init__(self, P1: gp_Pnt2d, P2: gp_Pnt2d) -> None: ...
    def Value(self) -> Geom2d_Line: ...

class GCE2d_MakeParabola(GCE2d_Root):
    @overload
    def __init__(self, Prb: gp_Parab2d) -> None: ...
    @overload
    def __init__(self, Axis: gp_Ax22d, Focal: float) -> None: ...
    @overload
    def __init__(self, MirrorAxis: gp_Ax2d, Focal: float, Sense: bool) -> None: ...
    @overload
    def __init__(self, D: gp_Ax2d, F: gp_Pnt2d, Sense: Optional[bool] = True) -> None: ...
    @overload
    def __init__(self, S1: gp_Pnt2d, O: gp_Pnt2d) -> None: ...
    def Value(self) -> Geom2d_Parabola: ...

class GCE2d_MakeSegment(GCE2d_Root):
    @overload
    def __init__(self, P1: gp_Pnt2d, P2: gp_Pnt2d) -> None: ...
    @overload
    def __init__(self, P1: gp_Pnt2d, V: gp_Dir2d, P2: gp_Pnt2d) -> None: ...
    @overload
    def __init__(self, Line: gp_Lin2d, U1: float, U2: float) -> None: ...
    @overload
    def __init__(self, Line: gp_Lin2d, Point: gp_Pnt2d, Ulast: float) -> None: ...
    @overload
    def __init__(self, Line: gp_Lin2d, P1: gp_Pnt2d, P2: gp_Pnt2d) -> None: ...
    def Value(self) -> Geom2d_TrimmedCurve: ...

# harray1 classes
# harray2 classes
# hsequence classes

