import { EndpointParameterInstructions } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@smithy/types";
import {
  CloudFormationClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../CloudFormationClient";
import {
  DescribeStackSetOperationInput,
  DescribeStackSetOperationOutput,
} from "../models/models_0";
export { __MetadataBearer, $Command };
export interface DescribeStackSetOperationCommandInput
  extends DescribeStackSetOperationInput {}
export interface DescribeStackSetOperationCommandOutput
  extends DescribeStackSetOperationOutput,
    __MetadataBearer {}
export declare class DescribeStackSetOperationCommand extends $Command<
  DescribeStackSetOperationCommandInput,
  DescribeStackSetOperationCommandOutput,
  CloudFormationClientResolvedConfig
> {
  readonly input: DescribeStackSetOperationCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DescribeStackSetOperationCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: CloudFormationClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DescribeStackSetOperationCommandInput,
    DescribeStackSetOperationCommandOutput
  >;
  private serialize;
  private deserialize;
}
