/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.actors.mobs;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.Spear;
import com.shatteredpixel.shatteredpixeldungeon.mechanics.Ballistica;
import com.shatteredpixel.shatteredpixeldungeon.sprites.GnollGuardSprite;
import com.watabou.utils.Random;

public class GnollGuard
extends Mob {
    public GnollGuard() {
        this.spriteClass = GnollGuardSprite.class;
        this.HT = 35;
        this.HP = 35;
        this.defenseSkill = 15;
        this.EXP = 7;
        this.maxLvl = -2;
        this.loot = Spear.class;
        this.lootChance = 0.1f;
    }

    @Override
    public int damageRoll() {
        if (this.enemy != null && !Dungeon.level.adjacent(this.pos, this.enemy.pos)) {
            return Random.NormalIntRange(15, 25);
        }
        return Random.NormalIntRange(5, 15);
    }

    @Override
    public int attackSkill(Char target) {
        return 20;
    }

    @Override
    public int drRoll() {
        return super.drRoll() + Random.NormalIntRange(0, 6);
    }

    @Override
    protected boolean canAttack(Char enemy) {
        return Dungeon.level.distance(enemy.pos, this.pos) <= 2 && new Ballistica((int)this.pos, (int)enemy.pos, (int)7).collisionPos == enemy.pos && new Ballistica((int)enemy.pos, (int)this.pos, (int)7).collisionPos == this.pos;
    }
}

