/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.scenes;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.GamesInProgress;
import com.shatteredpixel.shatteredpixeldungeon.ShatteredPixelDungeon;
import com.shatteredpixel.shatteredpixeldungeon.Statistics;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.LostBackpack;
import com.shatteredpixel.shatteredpixeldungeon.levels.Level;
import com.shatteredpixel.shatteredpixeldungeon.levels.features.Chasm;
import com.shatteredpixel.shatteredpixeldungeon.levels.features.LevelTransition;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.special.SpecialRoom;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.PixelScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.StartScene;
import com.shatteredpixel.shatteredpixeldungeon.ui.GameLog;
import com.shatteredpixel.shatteredpixeldungeon.ui.RenderedTextBlock;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndError;
import com.watabou.gltextures.TextureCache;
import com.watabou.glwrap.Blending;
import com.watabou.noosa.Camera;
import com.watabou.noosa.Game;
import com.watabou.noosa.Image;
import com.watabou.noosa.NoosaScript;
import com.watabou.noosa.NoosaScriptNoLighting;
import com.watabou.noosa.SkinnedBlock;
import com.watabou.utils.BArray;
import com.watabou.utils.DeviceCompat;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;

public class InterlevelScene
extends PixelScene {
    private static final float SLOW_FADE = 1.0f;
    private static final float NORM_FADE = 0.67f;
    private static final float FAST_FADE = 0.5f;
    private static float fadeTime;
    public static Mode mode;
    public static LevelTransition curTransition;
    public static int returnDepth;
    public static int returnBranch;
    public static int returnPos;
    public static boolean fallIntoPit;
    private Phase phase;
    private float timeLeft;
    private RenderedTextBlock message;
    private static Thread thread;
    private static Exception error;
    private float waitingTime;
    public static int lastRegion;

    public InterlevelScene() {
        this.inGameScene = true;
    }

    @Override
    public void create() {
        float scrollSpeed;
        int loadingDepth;
        super.create();
        fadeTime = 0.67f;
        switch (mode) {
            default: {
                loadingDepth = Dungeon.depth;
                scrollSpeed = 0.0f;
                break;
            }
            case CONTINUE: {
                loadingDepth = GamesInProgress.check((int)GamesInProgress.curSlot).depth;
                scrollSpeed = 5.0f;
                break;
            }
            case DESCEND: {
                if (Dungeon.hero == null) {
                    loadingDepth = 1;
                    fadeTime = 1.0f;
                } else {
                    loadingDepth = curTransition != null ? InterlevelScene.curTransition.destDepth : Dungeon.depth + 1;
                    if (Statistics.deepestFloor >= loadingDepth) {
                        fadeTime = 0.5f;
                    } else if (loadingDepth == 6 || loadingDepth == 11 || loadingDepth == 16 || loadingDepth == 21) {
                        fadeTime = 1.0f;
                    }
                }
                scrollSpeed = 5.0f;
                break;
            }
            case FALL: {
                loadingDepth = Dungeon.depth + 1;
                scrollSpeed = 50.0f;
                break;
            }
            case ASCEND: {
                fadeTime = 0.5f;
                loadingDepth = curTransition != null ? InterlevelScene.curTransition.destDepth : Dungeon.depth - 1;
                scrollSpeed = -5.0f;
                break;
            }
            case RETURN: {
                loadingDepth = returnDepth;
                scrollSpeed = returnDepth > Dungeon.depth ? 15.0f : -15.0f;
            }
        }
        int region = (int)Math.ceil((float)loadingDepth / 5.0f);
        if (region != lastRegion) {
            TextureCache.clear();
            lastRegion = region;
        }
        String loadingAsset = lastRegion == 1 ? "interfaces/loading_sewers.png" : (lastRegion == 2 ? "interfaces/loading_prison.png" : (lastRegion == 3 ? "interfaces/loading_caves.png" : (lastRegion == 4 ? "interfaces/loading_city.png" : (lastRegion == 5 ? "interfaces/loading_halls.png" : "interfaces/shadow.png"))));
        if (DeviceCompat.isDebug()) {
            fadeTime = 0.0f;
        }
        SkinnedBlock bg = new SkinnedBlock((float)Camera.main.width, (float)Camera.main.height, loadingAsset){

            @Override
            protected NoosaScript script() {
                return NoosaScriptNoLighting.get();
            }

            @Override
            public void draw() {
                Blending.disable();
                super.draw();
                Blending.enable();
            }

            @Override
            public void update() {
                super.update();
                this.offset(0.0f, Game.elapsed * scrollSpeed);
            }
        };
        bg.scale(4.0f, 4.0f);
        bg.autoAdjust = true;
        this.add(bg);
        Image im = new Image(TextureCache.createGradient(-1442840576, -1157627904, -872415232, -587202560, -16777216)){

            @Override
            public void update() {
                super.update();
                this.aa = InterlevelScene.this.phase == Phase.FADE_IN ? Math.max(0.0f, InterlevelScene.this.timeLeft - (fadeTime - 0.333f)) : (InterlevelScene.this.phase == Phase.FADE_OUT ? Math.max(0.0f, 0.333f - InterlevelScene.this.timeLeft) : 0.0f);
            }
        };
        im.angle = 90.0f;
        im.x = Camera.main.width;
        im.scale.x = (float)Camera.main.height / 5.0f;
        im.scale.y = Camera.main.width;
        this.add(im);
        String text = Messages.get(Mode.class, mode.name(), new Object[0]);
        this.message = PixelScene.renderTextBlock(text, 9);
        this.message.setPos(((float)Camera.main.width - this.message.width()) / 2.0f, ((float)Camera.main.height - this.message.height()) / 2.0f);
        InterlevelScene.align(this.message);
        this.add(this.message);
        this.phase = Phase.FADE_IN;
        this.timeLeft = fadeTime;
        if (thread == null) {
            thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Actor.fixTime();
                        switch (mode) {
                            case DESCEND: {
                                InterlevelScene.this.descend();
                                break;
                            }
                            case ASCEND: {
                                InterlevelScene.this.ascend();
                                break;
                            }
                            case CONTINUE: {
                                InterlevelScene.this.restore();
                                break;
                            }
                            case RESURRECT: {
                                InterlevelScene.this.resurrect();
                                break;
                            }
                            case RETURN: {
                                InterlevelScene.this.returnTo();
                                break;
                            }
                            case FALL: {
                                InterlevelScene.this.fall();
                                break;
                            }
                            case RESET: {
                                InterlevelScene.this.reset();
                            }
                        }
                    }
                    catch (Exception e) {
                        error = e;
                    }
                    Thread thread = thread;
                    synchronized (thread) {
                        if (InterlevelScene.this.phase == Phase.STATIC && error == null) {
                            InterlevelScene.this.phase = Phase.FADE_OUT;
                            InterlevelScene.this.timeLeft = fadeTime;
                        }
                    }
                }
            };
            thread.start();
        }
        this.waitingTime = 0.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update() {
        super.update();
        this.waitingTime += Game.elapsed;
        float p = this.timeLeft / fadeTime;
        switch (this.phase) {
            case FADE_IN: {
                float f;
                this.message.alpha(1.0f - p);
                this.timeLeft -= Game.elapsed;
                if (!(f <= 0.0f)) break;
                Thread thread = InterlevelScene.thread;
                synchronized (thread) {
                    if (!InterlevelScene.thread.isAlive() && error == null) {
                        this.phase = Phase.FADE_OUT;
                        this.timeLeft = fadeTime;
                    } else {
                        this.phase = Phase.STATIC;
                    }
                    break;
                }
            }
            case FADE_OUT: {
                float f;
                this.message.alpha(p);
                this.timeLeft -= Game.elapsed;
                if (!(f <= 0.0f)) break;
                Game.switchScene(GameScene.class);
                thread = null;
                error = null;
                break;
            }
            case STATIC: {
                if (error != null) {
                    String errorMsg;
                    if (error instanceof FileNotFoundException) {
                        errorMsg = Messages.get(this, "file_not_found", new Object[0]);
                    } else if (error instanceof IOException) {
                        errorMsg = Messages.get(this, "io_error", new Object[0]);
                    } else if (error.getMessage() != null && error.getMessage().equals("old save")) {
                        errorMsg = Messages.get(this, "io_error", new Object[0]);
                    } else {
                        throw new RuntimeException("fatal error occured while moving between floors. Seed:" + Dungeon.seed + " depth:" + Dungeon.depth, error);
                    }
                    this.add(new WndError(errorMsg){

                        @Override
                        public void onBackPressed() {
                            super.onBackPressed();
                            Game.switchScene(StartScene.class);
                        }
                    });
                    thread = null;
                    error = null;
                    break;
                }
                if (thread == null || (int)this.waitingTime != 10) break;
                this.waitingTime = 11.0f;
                String s = "";
                for (StackTraceElement t : thread.getStackTrace()) {
                    s = s + "\n";
                    s = s + t.toString();
                }
                ShatteredPixelDungeon.reportException(new RuntimeException("waited more than 10 seconds on levelgen. Seed:" + Dungeon.seed + " depth:" + Dungeon.depth + " trace:" + s));
            }
        }
    }

    private void descend() throws IOException {
        if (Dungeon.hero == null) {
            Mob.clearHeldAllies();
            Dungeon.init();
            GameLog.wipe();
            if (DeviceCompat.isDebug()) {
                int trueDepth = Dungeon.depth;
                int trueBranch = Dungeon.branch;
                for (int i = 1; i < trueDepth + (trueBranch == 0 ? 0 : 1); ++i) {
                    if (Dungeon.levelHasBeenGenerated(i, 0)) continue;
                    Dungeon.depth = i;
                    Dungeon.branch = 0;
                    Dungeon.level = Dungeon.newLevel();
                    Dungeon.saveLevel(GamesInProgress.curSlot);
                }
                Dungeon.depth = trueDepth;
                Dungeon.branch = trueBranch;
            }
            Level level = Dungeon.newLevel();
            Dungeon.switchLevel(level, -1);
        } else {
            Mob.holdAllies(Dungeon.level);
            Dungeon.saveAll();
            Dungeon.depth = InterlevelScene.curTransition.destDepth;
            Dungeon.branch = InterlevelScene.curTransition.destBranch;
            Level level = Dungeon.levelHasBeenGenerated(Dungeon.depth, Dungeon.branch) ? Dungeon.loadLevel(GamesInProgress.curSlot) : Dungeon.newLevel();
            LevelTransition destTransition = level.getTransition(InterlevelScene.curTransition.destType);
            curTransition = null;
            Dungeon.switchLevel(level, destTransition.cell());
        }
    }

    private void fall() throws IOException {
        Mob.holdAllies(Dungeon.level);
        Buff.affect(Dungeon.hero, Chasm.Falling.class);
        Dungeon.saveAll();
        Level level = Dungeon.levelHasBeenGenerated(++Dungeon.depth, Dungeon.branch) ? Dungeon.loadLevel(GamesInProgress.curSlot) : Dungeon.newLevel();
        Dungeon.switchLevel(level, level.fallCell(fallIntoPit));
    }

    private void ascend() throws IOException {
        Mob.holdAllies(Dungeon.level);
        Dungeon.saveAll();
        Dungeon.depth = InterlevelScene.curTransition.destDepth;
        Dungeon.branch = InterlevelScene.curTransition.destBranch;
        Level level = Dungeon.levelHasBeenGenerated(Dungeon.depth, Dungeon.branch) ? Dungeon.loadLevel(GamesInProgress.curSlot) : Dungeon.newLevel();
        LevelTransition destTransition = level.getTransition(InterlevelScene.curTransition.destType);
        curTransition = null;
        Dungeon.switchLevel(level, destTransition.cell());
    }

    private void returnTo() throws IOException {
        Mob.holdAllies(Dungeon.level);
        Dungeon.saveAll();
        Dungeon.depth = returnDepth;
        Dungeon.branch = returnBranch;
        Level level = Dungeon.levelHasBeenGenerated(Dungeon.depth, Dungeon.branch) ? Dungeon.loadLevel(GamesInProgress.curSlot) : Dungeon.newLevel();
        Dungeon.switchLevel(level, returnPos);
    }

    private void restore() throws IOException {
        Mob.clearHeldAllies();
        GameLog.wipe();
        Dungeon.loadGame(GamesInProgress.curSlot);
        if (Dungeon.depth == -1) {
            Dungeon.depth = Statistics.deepestFloor;
            Dungeon.switchLevel(Dungeon.loadLevel(GamesInProgress.curSlot), -1);
        } else {
            Level level = Dungeon.loadLevel(GamesInProgress.curSlot);
            Dungeon.switchLevel(level, Dungeon.hero.pos);
        }
    }

    private void resurrect() {
        Level level;
        Mob.holdAllies(Dungeon.level);
        if (Dungeon.level.locked) {
            ArrayList<Item> preservedItems = Dungeon.level.getItemsToPreserveFromSealedResurrect();
            Dungeon.hero.resurrect();
            level = Dungeon.newLevel();
            Dungeon.hero.pos = level.randomRespawnCell(Dungeon.hero);
            if (Dungeon.hero.pos == -1) {
                Dungeon.hero.pos = level.entrance();
            }
            for (Item i : preservedItems) {
                int pos = level.randomRespawnCell(null);
                if (pos == -1) {
                    pos = level.entrance();
                }
                level.drop(i, pos);
            }
            int pos = level.randomRespawnCell(null);
            if (pos == -1) {
                pos = level.entrance();
            }
            level.drop(new LostBackpack(), pos);
        } else {
            level = Dungeon.level;
            BArray.setFalse(level.heroFOV);
            BArray.setFalse(level.visited);
            BArray.setFalse(level.mapped);
            int invPos = Dungeon.hero.pos;
            int tries = 0;
            do {
                Dungeon.hero.pos = level.randomRespawnCell(Dungeon.hero);
            } while (level.traps.get(Dungeon.hero.pos) != null || level.plants.get(Dungeon.hero.pos) != null && ++tries < 500 || level.trueDistance(invPos, Dungeon.hero.pos) <= (float)(30 - tries / 10));
            if (level.map[Dungeon.hero.pos] == 15 || level.map[Dungeon.hero.pos] == 30) {
                level.map[Dungeon.hero.pos] = 2;
            }
            Dungeon.hero.resurrect();
            level.drop(new LostBackpack(), invPos);
        }
        Dungeon.switchLevel(level, Dungeon.hero.pos);
    }

    private void reset() throws IOException {
        Mob.holdAllies(Dungeon.level);
        SpecialRoom.resetPitRoom(Dungeon.depth + 1);
        Level level = Dungeon.newLevel();
        Dungeon.switchLevel(level, level.entrance());
    }

    @Override
    protected void onBackPressed() {
    }

    static {
        curTransition = null;
        error = null;
        lastRegion = -1;
    }

    private static enum Phase {
        FADE_IN,
        STATIC,
        FADE_OUT;

    }

    public static enum Mode {
        DESCEND,
        ASCEND,
        CONTINUE,
        RESURRECT,
        RETURN,
        FALL,
        RESET,
        NONE;

    }
}

