# ----------------------------------------------------------------------------
#
#  Copyright (C) 2018-2022 Fons Adriaensen <fons@linuxaudio.org>
#    
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http:#www.gnu.org/licenses/>.
#
# ----------------------------------------------------------------------------


import globdef as G
from PyQt6 import QtGui, QtCore, QtWidgets
from gmsbase import *
from buttonbase import *
from controls import *


class Inputelm (Gmsbase):

    def __init__(self, parent, bstyle, rstyle, callb, index, label): 
        super (Inputelm, self).__init__(parent, callb, index)
        self.resize (G.ELM_XS, G.IP_YS)
        L = QtWidgets.QLabel (self)
        L.setFont (G.LAB_FONT)
        L.setText (label)
        L.setGeometry (4, 5, G.ELM_XS - 8, 18)
        L.setAlignment (QtCore.Qt.AlignmentFlag.AlignCenter)
        R = Rgainctl (self, rstyle)
        R.move (7, 22)
        R.valueEvent.connect (self.value_event)
        R.show ()
        self.gainctl = R
        L = QtWidgets.QLabel (self)
        L.setFont (G.VAL_FONT)
        L.setText ('Off')
        L.setGeometry (0, 50, G.ELM_XS - 8, 14)
        L.setAlignment (QtCore.Qt.AlignmentFlag.AlignRight)
        self.gaintxt = L
        x = G.ELM_XS // 2
        self.bmute = ButtonBase (self, bstyle, True, 0)
        self.bmute.set_text ("M")
        self.bmute.move (x - 17, 68)
        self.bmute.bpressEvent.connect (self.mute_event)
        self.bsolo = ButtonBase (self, bstyle, True, 1)
        self.bsolo.set_text ("S")
        self.bsolo.move (x + 1, 68)
        self.bsolo.bpressEvent.connect (self.solo_event)
        
        
class Inputwin (QtWidgets.QWidget):

    def __init__(self, parent, nelm, callb, labels = None): 
        super (Inputwin, self).__init__(parent)
        self.nelm = nelm
        self.xs = nelm * (G.ELM_XS + 1) + 1
        self.ys = G.IP_YS
        self.resize (self.xs, self.ys)
        pal = self.palette () 
        bgc = pal.color (pal.ColorRole.Window)
        bstyle = ButtonStyle (17, 17, bgc, [G.FG_N,G.COL5,G.COL2], [G.MK_N,G.COL0,G.COL9], G.BUT_FONT, 9)
        rstyle = RotaryStyle (11, bgc, [G.FG_N,G.COL4], [G.MK_N,G.COL0])
        self.controls = [ None for i in range (nelm) ]
        x = 1
        for i in range (nelm):
            label = '%d' % (i,) if labels is None else labels [i]
            E = Inputelm (self, bstyle, rstyle, callb, i, label)  
            E.move (x, 0)
            self.controls [i] = E
            x += G.ELM_XS + 1

    def get_state (self, elm):
        return self.controls [elm].get_state ()

    def set_state (self, elm, gaindb, mute):
        return self.controls [elm].set_state (gaindb, mute)

    def get_solo (self, elm):
        return self.controls [elm].get_solo ()

    def any_solo (self):
        for E in self.controls:
            if E.get_solo (): return True
        return False
    
    def exc_solo (self, elm):
        for i in range (self.nelm):
            if i != elm: self.controls [i].solo_off ()

    def paintEvent(self, E):
        qp = QtGui.QPainter(self)
        qp.setRenderHint (QtGui.QPainter.RenderHint.Antialiasing)
        qp.setBrush (QtCore.Qt.BrushStyle.NoBrush)
        qp.setPen (QtGui.QPen (G.MK_N, 0.2))
        qp.translate (0.5, 0.5)
        x = 0
        for i in range (self.nelm + 1):
            qp.drawLine (x, 0, x, self.ys)
            x += G.ELM_XS + 1
