/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.plugin.rest;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.sql.common.utils.QueryContext;
import org.opensearch.sql.legacy.executor.format.ErrorMessageFactory;
import org.opensearch.sql.legacy.metrics.Metrics;

public class RestPPLStatsAction
extends BaseRestHandler {
    private static final Logger LOG = LogManager.getLogger(RestPPLStatsAction.class);
    public static final String PPL_STATS_API_ENDPOINT = "/_plugins/_ppl/stats";
    public static final String PPL_LEGACY_STATS_API_ENDPOINT = "/_opendistro/_ppl/stats";

    public RestPPLStatsAction(Settings settings, RestController restController) {
    }

    public String getName() {
        return "ppl_stats_action";
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of();
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return ImmutableList.of((Object)new RestHandler.ReplacedRoute(RestRequest.Method.POST, PPL_STATS_API_ENDPOINT, RestRequest.Method.POST, PPL_LEGACY_STATS_API_ENDPOINT), (Object)new RestHandler.ReplacedRoute(RestRequest.Method.GET, PPL_STATS_API_ENDPOINT, RestRequest.Method.GET, PPL_LEGACY_STATS_API_ENDPOINT));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        QueryContext.addRequestId();
        try {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, Metrics.getInstance().collectToJSON()));
        }
        catch (Exception e) {
            LOG.error("Failed during Query PPL STATS Action.", (Throwable)e);
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.SERVICE_UNAVAILABLE, ErrorMessageFactory.createErrorMessage((Exception)e, (int)RestStatus.SERVICE_UNAVAILABLE.getStatus()).toString()));
        }
    }

    protected Set<String> responseParams() {
        HashSet<String> responseParams = new HashSet<String>(super.responseParams());
        responseParams.addAll(Arrays.asList("format", "sanitize"));
        return responseParams;
    }
}

