/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.CheckArgsArrayArityInstr;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.OneOperandInstr;
import org.jruby.ir.instructions.RaiseArgumentErrorInstr;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.ir.transformations.inlining.InlineCloneInfo;
import org.jruby.ir.transformations.inlining.SimpleCloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class CheckArityInstr
extends OneOperandInstr
implements FixedArityInstr {
    public final int required;
    public final int opt;
    public final boolean rest;
    public final int restKey;

    public CheckArityInstr(int required, int opt, boolean rest, int restKey, Variable keywords) {
        super(Operation.CHECK_ARITY, keywords);
        this.required = required;
        this.opt = opt;
        this.rest = rest;
        this.restKey = restKey;
    }

    public Variable getKeywords() {
        return (Variable)this.getOperand1();
    }

    @Override
    public String[] toStringNonOperandArgs() {
        return new String[]{"req: " + this.required, "opt: " + this.opt, "*r: " + this.rest};
    }

    @Override
    public Instr clone(CloneInfo info) {
        if (info instanceof SimpleCloneInfo) {
            return new CheckArityInstr(this.required, this.opt, this.rest, this.restKey, (Variable)this.getOperand1());
        }
        InlineCloneInfo ii = (InlineCloneInfo)info;
        if (ii.canMapArgsStatically()) {
            int numArgs = ii.getArgsCount();
            if (numArgs < this.required || !this.rest && numArgs > this.required + this.opt) {
                return new RaiseArgumentErrorInstr(this.required, this.opt, this.rest, numArgs);
            }
            return null;
        }
        return new CheckArgsArrayArityInstr(ii.getArgs(), this.required, this.opt, this.rest);
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.required);
        e.encode(this.opt);
        e.encode(this.rest);
        e.encode(this.restKey);
        e.encode(this.getKeywords());
    }

    public static CheckArityInstr decode(IRReaderDecoder d) {
        return new CheckArityInstr(d.decodeInt(), d.decodeInt(), d.decodeBoolean(), d.decodeInt(), d.decodeVariable());
    }

    public void checkArity(ThreadContext context, IRubyObject self2, StaticScope scope, DynamicScope dynamicScope, IRubyObject[] args2, Block block, Object[] temp) {
        Object keyword = this.getOperand1().retrieve(context, self2, scope, dynamicScope, temp);
        IRRuntimeHelpers.checkArity(context, scope, args2, keyword, this.required, this.opt, this.rest, this.restKey, block);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.CheckArityInstr(this);
    }
}

