/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.reader;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opensearch.performanceanalyzer.commons.config.PluginSettings;
import org.opensearch.performanceanalyzer.commons.event_process.Event;

public abstract class FileHandler {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private String rootLocation = PluginSettings.instance().getMetricsLocation();

    public abstract List<File> findFiles4Metric(long var1);

    public abstract List<Event> getMetricData(Map<String, List<Event>> var1);

    FileHandler() {
    }

    public String[] processExtraDimensions(File file) throws IOException {
        if (this.filePathRegex().isEmpty()) {
            return EMPTY_STRING_ARRAY;
        }
        Pattern pattern = Pattern.compile(this.filePathRegex());
        Matcher matcher = pattern.matcher(file.getCanonicalPath());
        if (matcher.find()) {
            int groupCount = matcher.groupCount();
            String[] extraDimensions = new String[groupCount];
            for (int i = 1; i <= groupCount; ++i) {
                extraDimensions[i - 1] = matcher.group(i);
            }
            return extraDimensions;
        }
        throw new IOException(String.format("Cannot find a matching path %s", file.getCanonicalPath()));
    }

    String[] processExtraDimensions(String key) {
        if (this.filePathRegex().isEmpty()) {
            return EMPTY_STRING_ARRAY;
        }
        String[] temp = key.split(File.separatorChar == '\\' ? "\\\\" : File.separator);
        return Arrays.copyOfRange(temp, 1, temp.length);
    }

    protected String filePathRegex() {
        return "";
    }

    public String getRootLocation() {
        return this.rootLocation;
    }

    @VisibleForTesting
    void setRootLocation(String location) {
        this.rootLocation = location;
    }
}

