/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster;

import java.io.IOException;
import org.opensearch.cluster.Diff;
import org.opensearch.cluster.Diffable;
import org.opensearch.common.Nullable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;

public abstract class AbstractDiffable<T extends Diffable<T>>
implements Diffable<T> {
    private static final Diff<?> EMPTY = new CompleteDiff();

    @Override
    public Diff<T> diff(T previousState) {
        if (this.equals(previousState)) {
            return EMPTY;
        }
        return new CompleteDiff<AbstractDiffable>(this);
    }

    public static <T extends Diffable<T>> Diff<T> readDiffFrom(Writeable.Reader<T> reader, StreamInput in) throws IOException {
        if (in.readBoolean()) {
            return new CompleteDiff<Diffable>((Diffable)reader.read(in));
        }
        return EMPTY;
    }

    private static class CompleteDiff<T extends Diffable<T>>
    implements Diff<T> {
        @Nullable
        private final T part;

        CompleteDiff(T part) {
            this.part = part;
        }

        CompleteDiff() {
            this.part = null;
        }

        public void writeTo(StreamOutput out) throws IOException {
            if (this.part != null) {
                out.writeBoolean(true);
                this.part.writeTo(out);
            } else {
                out.writeBoolean(false);
            }
        }

        @Override
        public T apply(T part) {
            if (this.part != null) {
                return this.part;
            }
            return part;
        }
    }
}

