/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.cache;

import java.io.Closeable;
import java.io.IOException;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.index.AbstractIndexComponent;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.cache.bitset.BitsetFilterCache;
import org.opensearch.index.cache.query.QueryCache;

public class IndexCache
extends AbstractIndexComponent
implements Closeable {
    private final QueryCache queryCache;
    private final BitsetFilterCache bitsetFilterCache;

    public IndexCache(IndexSettings indexSettings, QueryCache queryCache, BitsetFilterCache bitsetFilterCache) {
        super(indexSettings);
        this.queryCache = queryCache;
        this.bitsetFilterCache = bitsetFilterCache;
    }

    public QueryCache query() {
        return this.queryCache;
    }

    public BitsetFilterCache bitsetFilterCache() {
        return this.bitsetFilterCache;
    }

    @Override
    public void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{this.queryCache, this.bitsetFilterCache});
    }

    public void clear(String reason) {
        this.queryCache.clear(reason);
        this.bitsetFilterCache.clear(reason);
    }
}

