/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.translog;

import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.lucene.store.BufferedChecksum;
import org.opensearch.core.common.io.stream.StreamOutput;

public final class BufferedChecksumStreamOutput
extends StreamOutput {
    private final StreamOutput out;
    private final Checksum digest;

    public BufferedChecksumStreamOutput(StreamOutput out) {
        this.out = out;
        this.digest = new BufferedChecksum((Checksum)new CRC32());
    }

    public long getChecksum() {
        return this.digest.getValue();
    }

    public void writeByte(byte b) throws IOException {
        this.out.writeByte(b);
        this.digest.update(b);
    }

    public void writeBytes(byte[] b, int offset, int length) throws IOException {
        this.out.writeBytes(b, offset, length);
        this.digest.update(b, offset, length);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.close();
    }

    public void reset() throws IOException {
        this.out.reset();
        this.digest.reset();
    }

    public void resetDigest() {
        this.digest.reset();
    }
}

