/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.composite;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.util.PriorityQueue;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lease.Releasables;
import org.opensearch.common.util.BigArrays;
import org.opensearch.common.util.LongArray;
import org.opensearch.search.aggregations.LeafBucketCollector;
import org.opensearch.search.aggregations.bucket.composite.CompositeKey;
import org.opensearch.search.aggregations.bucket.composite.SingleDimensionValuesSource;

final class CompositeValuesCollectorQueue
extends PriorityQueue<Integer>
implements Releasable {
    private static final int CANDIDATE_SLOT = Integer.MAX_VALUE;
    private final BigArrays bigArrays;
    private final int maxSize;
    private final Map<Slot, Integer> map;
    private final SingleDimensionValuesSource<?>[] arrays;
    private LongArray docCounts;
    private boolean afterKeyIsSet = false;

    CompositeValuesCollectorQueue(BigArrays bigArrays, SingleDimensionValuesSource<?>[] sources, int size, CompositeKey afterKey) {
        super(size);
        this.bigArrays = bigArrays;
        this.maxSize = size;
        this.arrays = sources;
        this.map = new HashMap<Slot, Integer>(size);
        if (afterKey != null) {
            assert (afterKey.size() == sources.length);
            this.afterKeyIsSet = true;
            for (int i = 0; i < afterKey.size(); ++i) {
                sources[i].setAfter(afterKey.get(i));
            }
        }
        this.docCounts = bigArrays.newLongArray(1L, false);
    }

    protected boolean lessThan(Integer a, Integer b) {
        return this.compare(a, b) > 0;
    }

    boolean isFull() {
        return this.size() >= this.maxSize;
    }

    Integer compareCurrent() {
        return this.map.get(new Slot(Integer.MAX_VALUE));
    }

    Comparable getLowerValueLeadSource() {
        return this.afterKeyIsSet ? (Comparable)this.arrays[0].getAfter() : null;
    }

    Comparable getUpperValueLeadSource() throws IOException {
        return this.size() >= this.maxSize ? (Comparable)this.arrays[0].toComparable((Integer)this.top()) : null;
    }

    long getDocCount(int slot) {
        return this.docCounts.get(slot);
    }

    private void copyCurrent(int slot, long value) {
        for (int i = 0; i < this.arrays.length; ++i) {
            this.arrays[i].copyCurrent(slot);
        }
        this.docCounts = this.bigArrays.grow(this.docCounts, (long)(slot + 1));
        this.docCounts.set(slot, value);
    }

    int compare(int slot1, int slot2) {
        assert (slot2 != Integer.MAX_VALUE);
        for (int i = 0; i < this.arrays.length; ++i) {
            int cmp = slot1 == Integer.MAX_VALUE ? this.arrays[i].compareCurrent(slot2) : this.arrays[i].compare(slot1, slot2);
            if (cmp == 0) continue;
            return cmp > 0 ? i + 1 : -(i + 1);
        }
        return 0;
    }

    boolean equals(int slot1, int slot2) {
        assert (slot2 != Integer.MAX_VALUE);
        for (int i = 0; i < this.arrays.length; ++i) {
            int cmp = slot1 == Integer.MAX_VALUE ? this.arrays[i].compareCurrent(slot2) : this.arrays[i].compare(slot1, slot2);
            if (cmp == 0) continue;
            return false;
        }
        return true;
    }

    int hashCode(int slot) {
        int result = 1;
        for (int i = 0; i < this.arrays.length; ++i) {
            result = 31 * result + (slot == Integer.MAX_VALUE ? this.arrays[i].hashCodeCurrent() : this.arrays[i].hashCode(slot));
        }
        return result;
    }

    private int compareCurrentWithAfter() {
        for (int i = 0; i < this.arrays.length; ++i) {
            int cmp = this.arrays[i].compareCurrentWithAfter();
            if (cmp == 0) continue;
            return cmp > 0 ? i + 1 : -(i + 1);
        }
        return 0;
    }

    CompositeKey toCompositeKey(int slot) throws IOException {
        assert (slot < this.maxSize);
        Comparable[] values = new Comparable[this.arrays.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.arrays[i].toComparable(slot);
        }
        return new CompositeKey(values);
    }

    LeafBucketCollector getLeafCollector(LeafReaderContext context, LeafBucketCollector in) throws IOException {
        return this.getLeafCollector(null, context, in);
    }

    LeafBucketCollector getLeafCollector(Comparable forceLeadSourceValue, LeafReaderContext context, LeafBucketCollector in) throws IOException {
        int last = this.arrays.length - 1;
        LeafBucketCollector collector = in;
        while (last > 0) {
            collector = this.arrays[last--].getLeafCollector(context, collector);
        }
        collector = forceLeadSourceValue != null ? this.arrays[last].getLeafCollector(forceLeadSourceValue, context, collector) : this.arrays[last].getLeafCollector(context, collector);
        return collector;
    }

    boolean addIfCompetitive(long inc) {
        return this.addIfCompetitive(0, inc);
    }

    boolean addIfCompetitive(int indexSortSourcePrefix, long inc) {
        int newSlot;
        int cmp;
        Integer topSlot = this.compareCurrent();
        if (topSlot != null) {
            this.docCounts.increment(topSlot.intValue(), inc);
            return true;
        }
        if (this.afterKeyIsSet && (cmp = this.compareCurrentWithAfter()) <= 0) {
            if (indexSortSourcePrefix < 0 && cmp == indexSortSourcePrefix) {
                throw new CollectionTerminatedException();
            }
            return false;
        }
        if (this.size() >= this.maxSize && (cmp = this.compare(Integer.MAX_VALUE, (Integer)this.top())) > 0) {
            if (cmp <= indexSortSourcePrefix) {
                throw new CollectionTerminatedException();
            }
            return false;
        }
        if (this.size() >= this.maxSize) {
            int slot = (Integer)this.pop();
            this.map.remove(new Slot(slot));
            newSlot = slot;
        } else {
            newSlot = this.size();
        }
        this.copyCurrent(newSlot, inc);
        this.map.put(new Slot(newSlot), newSlot);
        this.add(newSlot);
        return true;
    }

    public void close() {
        Releasables.close((Releasable)this.docCounts);
    }

    private class Slot {
        int value;

        Slot(int initial) {
            this.value = initial;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Slot slot = (Slot)o;
            return CompositeValuesCollectorQueue.this.equals(this.value, slot.value);
        }

        public int hashCode() {
            return CompositeValuesCollectorQueue.this.hashCode(this.value);
        }
    }
}

