/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.terms.heuristic;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.script.Script;
import org.opensearch.script.SignificantTermsHeuristicScoreScript;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.bucket.terms.heuristic.SignificanceHeuristic;

public class ScriptHeuristic
extends SignificanceHeuristic {
    public static final String NAME = "script_heuristic";
    public static final ConstructingObjectParser<ScriptHeuristic, Void> PARSER = new ConstructingObjectParser("script_heuristic", args -> new ScriptHeuristic((Script)args[0]));
    private final Script script;

    public ScriptHeuristic(Script script) {
        this.script = script;
    }

    public ScriptHeuristic(StreamInput in) throws IOException {
        this(new Script(in));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.script.writeTo(out);
    }

    @Override
    public SignificanceHeuristic rewrite(InternalAggregation.ReduceContext context) {
        SignificantTermsHeuristicScoreScript.Factory factory = context.scriptService().compile(this.script, SignificantTermsHeuristicScoreScript.CONTEXT);
        return new ExecutableScriptHeuristic(this.script, factory.newInstance());
    }

    @Override
    public SignificanceHeuristic rewrite(QueryShardContext queryShardContext) {
        SignificantTermsHeuristicScoreScript.Factory compiledScript = queryShardContext.compile(this.script, SignificantTermsHeuristicScoreScript.CONTEXT);
        return new ExecutableScriptHeuristic(this.script, compiledScript.newInstance());
    }

    @Override
    public double getScore(long subsetFreq, long subsetSize, long supersetFreq, long supersetSize) {
        throw new UnsupportedOperationException("This scoring heuristic must have 'rewrite' called on it to provide a version ready for use");
    }

    public String getWriteableName() {
        return NAME;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params builderParams) throws IOException {
        builder.startObject(NAME);
        builder.field(Script.SCRIPT_PARSE_FIELD.getPreferredName());
        this.script.toXContent(builder, builderParams);
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.script);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScriptHeuristic other = (ScriptHeuristic)obj;
        return Objects.equals(this.script, other.script);
    }

    static {
        Script.declareScript(PARSER, ConstructingObjectParser.constructorArg());
    }

    public final class LongAccessor
    extends Number {
        public long value;

        @Override
        public int intValue() {
            return (int)this.value;
        }

        @Override
        public long longValue() {
            return this.value;
        }

        @Override
        public float floatValue() {
            return this.value;
        }

        @Override
        public double doubleValue() {
            return this.value;
        }

        public String toString() {
            return Long.toString(this.value);
        }
    }

    static class ExecutableScriptHeuristic
    extends ScriptHeuristic {
        private final LongAccessor subsetSizeHolder;
        private final LongAccessor supersetSizeHolder;
        private final LongAccessor subsetDfHolder;
        private final LongAccessor supersetDfHolder;
        private final SignificantTermsHeuristicScoreScript executableScript;
        private final Map<String, Object> params = new HashMap<String, Object>();

        ExecutableScriptHeuristic(Script script, SignificantTermsHeuristicScoreScript executableScript) {
            super(script);
            this.subsetSizeHolder = new LongAccessor();
            this.supersetSizeHolder = new LongAccessor();
            this.subsetDfHolder = new LongAccessor();
            this.supersetDfHolder = new LongAccessor();
            this.executableScript = executableScript;
            this.params.putAll(script.getParams());
            this.params.put("_subset_freq", this.subsetDfHolder);
            this.params.put("_subset_size", this.subsetSizeHolder);
            this.params.put("_superset_freq", this.supersetDfHolder);
            this.params.put("_superset_size", this.supersetSizeHolder);
        }

        @Override
        public double getScore(long subsetFreq, long subsetSize, long supersetFreq, long supersetSize) {
            this.subsetSizeHolder.value = subsetSize;
            this.supersetSizeHolder.value = supersetSize;
            this.subsetDfHolder.value = subsetFreq;
            this.supersetDfHolder.value = supersetFreq;
            return this.executableScript.execute(this.params);
        }
    }
}

