/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.BinaryExpression;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.impl.BooleanConstant;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class EqualExpression
extends BinaryExpression {
    public EqualExpression(Expression expression, Expression expression2, int n) {
        super(expression, expression2, n);
    }

    private void checkNullComparison(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo, FlowInfo flowInfo2, FlowInfo flowInfo3) {
        FieldBinding fieldBinding;
        LocalVariableBinding localVariableBinding;
        boolean bl;
        int n = this.right.nullStatus(flowInfo, flowContext);
        int n2 = this.left.nullStatus(flowInfo, flowContext);
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = bl = (this.bits & 0x3F00) >> 8 == 18;
        if ((flowContext.tagBits & 0xF000) == 0) {
            if (n2 == 4 && n == 2) {
                bl2 = blockScope.problemReporter().expressionNonNullComparison(this.left, bl);
            } else if (n2 == 2 && n == 4) {
                bl3 = blockScope.problemReporter().expressionNonNullComparison(this.right, bl);
            }
        }
        boolean bl5 = bl ^ (flowContext.tagBits & 4) != 0;
        if (!bl2) {
            localVariableBinding = this.left.localVariableBinding();
            if (localVariableBinding != null) {
                if ((localVariableBinding.type.tagBits & 2L) == 0L) {
                    this.checkVariableComparison(blockScope, flowContext, flowInfo, flowInfo2, flowInfo3, localVariableBinding, n, this.left);
                }
            } else if (this.left instanceof Reference && (bl5 ? n == 4 : n == 2) && blockScope.compilerOptions().enableSyntacticNullAnalysisForFields && (fieldBinding = ((Reference)this.left).lastFieldBinding()) != null && (fieldBinding.type.tagBits & 2L) == 0L) {
                flowContext.recordNullCheckedFieldReference((Reference)this.left, 1);
            }
        }
        if (!bl3) {
            localVariableBinding = this.right.localVariableBinding();
            if (localVariableBinding != null) {
                if ((localVariableBinding.type.tagBits & 2L) == 0L) {
                    this.checkVariableComparison(blockScope, flowContext, flowInfo, flowInfo2, flowInfo3, localVariableBinding, n2, this.right);
                }
            } else if (this.right instanceof Reference && (bl5 ? n2 == 4 : n2 == 2) && blockScope.compilerOptions().enableSyntacticNullAnalysisForFields && (fieldBinding = ((Reference)this.right).lastFieldBinding()) != null && (fieldBinding.type.tagBits & 2L) == 0L) {
                flowContext.recordNullCheckedFieldReference((Reference)this.right, 1);
            }
        }
        if (bl2 || bl3) {
            if (bl) {
                flowInfo2.setReachMode(2);
            } else {
                flowInfo3.setReachMode(2);
            }
        }
    }

    private void checkVariableComparison(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo, FlowInfo flowInfo2, FlowInfo flowInfo3, LocalVariableBinding localVariableBinding, int n, Expression expression) {
        switch (n) {
            case 2: {
                if ((this.bits & 0x3F00) >> 8 == 18) {
                    flowContext.recordUsingNullReference(blockScope, localVariableBinding, expression, 256, flowInfo);
                    flowInfo2.markAsComparedEqualToNull(localVariableBinding);
                    flowInfo3.markAsComparedEqualToNonNull(localVariableBinding);
                    break;
                }
                flowContext.recordUsingNullReference(blockScope, localVariableBinding, expression, 512, flowInfo);
                flowInfo2.markAsComparedEqualToNonNull(localVariableBinding);
                flowInfo3.markAsComparedEqualToNull(localVariableBinding);
                break;
            }
            case 4: {
                if ((this.bits & 0x3F00) >> 8 == 18) {
                    flowContext.recordUsingNullReference(blockScope, localVariableBinding, expression, 513, flowInfo);
                    flowInfo2.markAsComparedEqualToNonNull(localVariableBinding);
                    break;
                }
                flowContext.recordUsingNullReference(blockScope, localVariableBinding, expression, 257, flowInfo);
            }
        }
    }

    private void analyzeLocalVariable(Expression expression, FlowInfo flowInfo) {
        if (expression instanceof SingleNameReference && (expression.bits & 2) != 0) {
            LocalVariableBinding localVariableBinding = (LocalVariableBinding)((SingleNameReference)expression).binding;
            if ((flowInfo.tagBits & 3) == 0) {
                localVariableBinding.useFlag = 1;
            } else if (localVariableBinding.useFlag == 0) {
                localVariableBinding.useFlag = 2;
            }
        }
    }

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        FlowInfo flowInfo2;
        if ((this.bits & 0x3F00) >> 8 == 18) {
            if (this.left.constant != Constant.NotAConstant && this.left.constant.typeID() == 5) {
                if (this.left.constant.booleanValue()) {
                    flowInfo2 = this.right.analyseCode(blockScope, flowContext, flowInfo);
                } else {
                    flowInfo2 = this.right.analyseCode(blockScope, flowContext, flowInfo).asNegatedCondition();
                    this.analyzeLocalVariable(this.left, flowInfo);
                }
            } else if (this.right.constant != Constant.NotAConstant && this.right.constant.typeID() == 5) {
                if (this.right.constant.booleanValue()) {
                    flowInfo2 = this.left.analyseCode(blockScope, flowContext, flowInfo);
                } else {
                    flowInfo2 = this.left.analyseCode(blockScope, flowContext, flowInfo).asNegatedCondition();
                    this.analyzeLocalVariable(this.right, flowInfo);
                }
            } else {
                flowInfo2 = this.right.analyseCode(blockScope, flowContext, this.left.analyseCode(blockScope, flowContext, flowInfo).unconditionalInits()).unconditionalInits();
            }
        } else if (this.left.constant != Constant.NotAConstant && this.left.constant.typeID() == 5) {
            if (!this.left.constant.booleanValue()) {
                flowInfo2 = this.right.analyseCode(blockScope, flowContext, flowInfo);
                this.analyzeLocalVariable(this.left, flowInfo);
            } else {
                flowInfo2 = this.right.analyseCode(blockScope, flowContext, flowInfo).asNegatedCondition();
            }
        } else if (this.right.constant != Constant.NotAConstant && this.right.constant.typeID() == 5) {
            if (!this.right.constant.booleanValue()) {
                flowInfo2 = this.left.analyseCode(blockScope, flowContext, flowInfo);
                this.analyzeLocalVariable(this.right, flowInfo);
            } else {
                flowInfo2 = this.left.analyseCode(blockScope, flowContext, flowInfo).asNegatedCondition();
            }
        } else {
            flowInfo2 = this.right.analyseCode(blockScope, flowContext, this.left.analyseCode(blockScope, flowContext, flowInfo).unconditionalInits()).unconditionalInits();
        }
        if (flowInfo2 instanceof UnconditionalFlowInfo && (flowInfo2.tagBits & 3) == 0) {
            flowInfo2 = FlowInfo.conditional(flowInfo2.copy(), flowInfo2.copy());
        }
        this.checkNullComparison(blockScope, flowContext, flowInfo2, flowInfo2.initsWhenTrue(), flowInfo2.initsWhenFalse());
        return flowInfo2;
    }

    public final void computeConstant(TypeBinding typeBinding, TypeBinding typeBinding2) {
        if (this.left.constant != Constant.NotAConstant && this.right.constant != Constant.NotAConstant) {
            this.constant = Constant.computeConstantOperationEQUAL_EQUAL(this.left.constant, typeBinding.id, this.right.constant, typeBinding2.id);
            if ((this.bits & 0x3F00) >> 8 == 29) {
                this.constant = BooleanConstant.fromValue(!this.constant.booleanValue());
            }
        } else {
            this.constant = Constant.NotAConstant;
        }
    }

    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        int n = codeStream.position;
        if (this.constant != Constant.NotAConstant) {
            if (bl) {
                codeStream.generateConstant(this.constant, this.implicitConversion);
            }
            codeStream.recordPositionsFrom(n, this.sourceStart);
            return;
        }
        if ((this.left.implicitConversion & 0xF) == 5) {
            this.generateBooleanEqual(blockScope, codeStream, bl);
        } else {
            this.generateNonBooleanEqual(blockScope, codeStream, bl);
        }
        if (bl) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    @Override
    public void generateOptimizedBoolean(BlockScope blockScope, CodeStream codeStream, BranchLabel branchLabel, BranchLabel branchLabel2, boolean bl) {
        if (this.constant != Constant.NotAConstant) {
            super.generateOptimizedBoolean(blockScope, codeStream, branchLabel, branchLabel2, bl);
            return;
        }
        if ((this.bits & 0x3F00) >> 8 == 18) {
            if ((this.left.implicitConversion & 0xF) == 5) {
                this.generateOptimizedBooleanEqual(blockScope, codeStream, branchLabel, branchLabel2, bl);
            } else {
                this.generateOptimizedNonBooleanEqual(blockScope, codeStream, branchLabel, branchLabel2, bl);
            }
        } else if ((this.left.implicitConversion & 0xF) == 5) {
            this.generateOptimizedBooleanEqual(blockScope, codeStream, branchLabel2, branchLabel, bl);
        } else {
            this.generateOptimizedNonBooleanEqual(blockScope, codeStream, branchLabel2, branchLabel, bl);
        }
    }

    public void generateBooleanEqual(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        boolean bl2 = (this.bits & 0x3F00) >> 8 == 18;
        Constant constant = this.left.optimizedBooleanConstant();
        if (constant != Constant.NotAConstant) {
            Constant constant2 = this.right.optimizedBooleanConstant();
            if (constant2 != Constant.NotAConstant) {
                this.left.generateCode(blockScope, codeStream, false);
                this.right.generateCode(blockScope, codeStream, false);
                if (bl) {
                    boolean bl3 = constant.booleanValue();
                    boolean bl4 = constant2.booleanValue();
                    if (bl2) {
                        if (bl3 == bl4) {
                            codeStream.iconst_1();
                        } else {
                            codeStream.iconst_0();
                        }
                    } else if (bl3 != bl4) {
                        codeStream.iconst_1();
                    } else {
                        codeStream.iconst_0();
                    }
                }
            } else if (constant.booleanValue() == bl2) {
                this.left.generateCode(blockScope, codeStream, false);
                this.right.generateCode(blockScope, codeStream, bl);
            } else if (bl) {
                BranchLabel branchLabel = new BranchLabel(codeStream);
                this.left.generateCode(blockScope, codeStream, false);
                this.right.generateOptimizedBoolean(blockScope, codeStream, null, branchLabel, bl);
                codeStream.iconst_0();
                if ((this.bits & 0x10) != 0) {
                    codeStream.generateImplicitConversion(this.implicitConversion);
                    codeStream.generateReturnBytecode(this);
                    branchLabel.place();
                    codeStream.iconst_1();
                } else {
                    BranchLabel branchLabel2 = new BranchLabel(codeStream);
                    codeStream.goto_(branchLabel2);
                    codeStream.decrStackSize(1);
                    branchLabel.place();
                    codeStream.iconst_1();
                    branchLabel2.place();
                }
            } else {
                this.left.generateCode(blockScope, codeStream, false);
                this.right.generateCode(blockScope, codeStream, false);
            }
            return;
        }
        constant = this.right.optimizedBooleanConstant();
        if (constant != Constant.NotAConstant) {
            if (constant.booleanValue() == bl2) {
                this.left.generateCode(blockScope, codeStream, bl);
                this.right.generateCode(blockScope, codeStream, false);
            } else if (bl) {
                BranchLabel branchLabel = new BranchLabel(codeStream);
                this.left.generateOptimizedBoolean(blockScope, codeStream, null, branchLabel, bl);
                this.right.generateCode(blockScope, codeStream, false);
                codeStream.iconst_0();
                if ((this.bits & 0x10) != 0) {
                    codeStream.generateImplicitConversion(this.implicitConversion);
                    codeStream.generateReturnBytecode(this);
                    branchLabel.place();
                    codeStream.iconst_1();
                } else {
                    BranchLabel branchLabel3 = new BranchLabel(codeStream);
                    codeStream.goto_(branchLabel3);
                    codeStream.decrStackSize(1);
                    branchLabel.place();
                    codeStream.iconst_1();
                    branchLabel3.place();
                }
            } else {
                this.left.generateCode(blockScope, codeStream, false);
                this.right.generateCode(blockScope, codeStream, false);
            }
            return;
        }
        this.left.generateCode(blockScope, codeStream, bl);
        this.right.generateCode(blockScope, codeStream, bl);
        if (bl) {
            if (bl2) {
                BranchLabel branchLabel = new BranchLabel(codeStream);
                codeStream.if_icmpne(branchLabel);
                codeStream.iconst_1();
                if ((this.bits & 0x10) != 0) {
                    codeStream.generateImplicitConversion(this.implicitConversion);
                    codeStream.generateReturnBytecode(this);
                    branchLabel.place();
                    codeStream.iconst_0();
                } else {
                    BranchLabel branchLabel4 = new BranchLabel(codeStream);
                    codeStream.goto_(branchLabel4);
                    codeStream.decrStackSize(1);
                    branchLabel.place();
                    codeStream.iconst_0();
                    branchLabel4.place();
                }
            } else {
                codeStream.ixor();
            }
        }
    }

    public void generateOptimizedBooleanEqual(BlockScope blockScope, CodeStream codeStream, BranchLabel branchLabel, BranchLabel branchLabel2, boolean bl) {
        if (this.left.constant != Constant.NotAConstant) {
            boolean bl2 = this.left.constant.booleanValue();
            this.right.generateOptimizedBoolean(blockScope, codeStream, bl2 ? branchLabel : branchLabel2, bl2 ? branchLabel2 : branchLabel, bl);
            return;
        }
        if (this.right.constant != Constant.NotAConstant) {
            boolean bl3 = this.right.constant.booleanValue();
            this.left.generateOptimizedBoolean(blockScope, codeStream, bl3 ? branchLabel : branchLabel2, bl3 ? branchLabel2 : branchLabel, bl);
            return;
        }
        this.left.generateCode(blockScope, codeStream, bl);
        this.right.generateCode(blockScope, codeStream, bl);
        int n = codeStream.position;
        if (bl) {
            if (branchLabel2 == null) {
                if (branchLabel != null) {
                    codeStream.if_icmpeq(branchLabel);
                }
            } else if (branchLabel == null) {
                codeStream.if_icmpne(branchLabel2);
            }
        }
        codeStream.recordPositionsFrom(n, this.sourceEnd);
    }

    public void generateNonBooleanEqual(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        Object object;
        boolean bl2;
        boolean bl3 = bl2 = (this.bits & 0x3F00) >> 8 == 18;
        if ((this.left.implicitConversion & 0xFF) >> 4 == 10) {
            object = this.left.constant;
            if (object != Constant.NotAConstant && ((Constant)object).intValue() == 0) {
                this.right.generateCode(blockScope, codeStream, bl);
                if (bl) {
                    BranchLabel branchLabel = new BranchLabel(codeStream);
                    if (bl2) {
                        codeStream.ifne(branchLabel);
                    } else {
                        codeStream.ifeq(branchLabel);
                    }
                    codeStream.iconst_1();
                    if ((this.bits & 0x10) != 0) {
                        codeStream.generateImplicitConversion(this.implicitConversion);
                        codeStream.generateReturnBytecode(this);
                        branchLabel.place();
                        codeStream.iconst_0();
                    } else {
                        BranchLabel branchLabel2 = new BranchLabel(codeStream);
                        codeStream.goto_(branchLabel2);
                        codeStream.decrStackSize(1);
                        branchLabel.place();
                        codeStream.iconst_0();
                        branchLabel2.place();
                    }
                }
                return;
            }
            object = this.right.constant;
            if (object != Constant.NotAConstant && ((Constant)object).intValue() == 0) {
                this.left.generateCode(blockScope, codeStream, bl);
                if (bl) {
                    BranchLabel branchLabel = new BranchLabel(codeStream);
                    if (bl2) {
                        codeStream.ifne(branchLabel);
                    } else {
                        codeStream.ifeq(branchLabel);
                    }
                    codeStream.iconst_1();
                    if ((this.bits & 0x10) != 0) {
                        codeStream.generateImplicitConversion(this.implicitConversion);
                        codeStream.generateReturnBytecode(this);
                        branchLabel.place();
                        codeStream.iconst_0();
                    } else {
                        BranchLabel branchLabel3 = new BranchLabel(codeStream);
                        codeStream.goto_(branchLabel3);
                        codeStream.decrStackSize(1);
                        branchLabel.place();
                        codeStream.iconst_0();
                        branchLabel3.place();
                    }
                }
                return;
            }
        }
        if (this.right instanceof NullLiteral) {
            if (this.left instanceof NullLiteral) {
                if (bl) {
                    if (bl2) {
                        codeStream.iconst_1();
                    } else {
                        codeStream.iconst_0();
                    }
                }
            } else {
                this.left.generateCode(blockScope, codeStream, bl);
                if (bl) {
                    object = new BranchLabel(codeStream);
                    if (bl2) {
                        codeStream.ifnonnull((BranchLabel)object);
                    } else {
                        codeStream.ifnull((BranchLabel)object);
                    }
                    codeStream.iconst_1();
                    if ((this.bits & 0x10) != 0) {
                        codeStream.generateImplicitConversion(this.implicitConversion);
                        codeStream.generateReturnBytecode(this);
                        ((BranchLabel)object).place();
                        codeStream.iconst_0();
                    } else {
                        BranchLabel branchLabel = new BranchLabel(codeStream);
                        codeStream.goto_(branchLabel);
                        codeStream.decrStackSize(1);
                        ((BranchLabel)object).place();
                        codeStream.iconst_0();
                        branchLabel.place();
                    }
                }
            }
            return;
        }
        if (this.left instanceof NullLiteral) {
            this.right.generateCode(blockScope, codeStream, bl);
            if (bl) {
                object = new BranchLabel(codeStream);
                if (bl2) {
                    codeStream.ifnonnull((BranchLabel)object);
                } else {
                    codeStream.ifnull((BranchLabel)object);
                }
                codeStream.iconst_1();
                if ((this.bits & 0x10) != 0) {
                    codeStream.generateImplicitConversion(this.implicitConversion);
                    codeStream.generateReturnBytecode(this);
                    ((BranchLabel)object).place();
                    codeStream.iconst_0();
                } else {
                    BranchLabel branchLabel = new BranchLabel(codeStream);
                    codeStream.goto_(branchLabel);
                    codeStream.decrStackSize(1);
                    ((BranchLabel)object).place();
                    codeStream.iconst_0();
                    branchLabel.place();
                }
            }
            return;
        }
        this.left.generateCode(blockScope, codeStream, bl);
        this.right.generateCode(blockScope, codeStream, bl);
        if (bl) {
            object = new BranchLabel(codeStream);
            if (bl2) {
                switch ((this.left.implicitConversion & 0xFF) >> 4) {
                    case 10: {
                        codeStream.if_icmpne((BranchLabel)object);
                        break;
                    }
                    case 9: {
                        codeStream.fcmpl();
                        codeStream.ifne((BranchLabel)object);
                        break;
                    }
                    case 7: {
                        codeStream.lcmp();
                        codeStream.ifne((BranchLabel)object);
                        break;
                    }
                    case 8: {
                        codeStream.dcmpl();
                        codeStream.ifne((BranchLabel)object);
                        break;
                    }
                    default: {
                        codeStream.if_acmpne((BranchLabel)object);
                        break;
                    }
                }
            } else {
                switch ((this.left.implicitConversion & 0xFF) >> 4) {
                    case 10: {
                        codeStream.if_icmpeq((BranchLabel)object);
                        break;
                    }
                    case 9: {
                        codeStream.fcmpl();
                        codeStream.ifeq((BranchLabel)object);
                        break;
                    }
                    case 7: {
                        codeStream.lcmp();
                        codeStream.ifeq((BranchLabel)object);
                        break;
                    }
                    case 8: {
                        codeStream.dcmpl();
                        codeStream.ifeq((BranchLabel)object);
                        break;
                    }
                    default: {
                        codeStream.if_acmpeq((BranchLabel)object);
                    }
                }
            }
            codeStream.iconst_1();
            if ((this.bits & 0x10) != 0) {
                codeStream.generateImplicitConversion(this.implicitConversion);
                codeStream.generateReturnBytecode(this);
                ((BranchLabel)object).place();
                codeStream.iconst_0();
            } else {
                BranchLabel branchLabel = new BranchLabel(codeStream);
                codeStream.goto_(branchLabel);
                codeStream.decrStackSize(1);
                ((BranchLabel)object).place();
                codeStream.iconst_0();
                branchLabel.place();
            }
        }
    }

    public void generateOptimizedNonBooleanEqual(BlockScope blockScope, CodeStream codeStream, BranchLabel branchLabel, BranchLabel branchLabel2, boolean bl) {
        int n = codeStream.position;
        Constant constant = this.right.constant;
        if (constant != Constant.NotAConstant && (this.left.implicitConversion & 0xFF) >> 4 == 10 && constant.intValue() == 0) {
            this.left.generateCode(blockScope, codeStream, bl);
            if (bl) {
                if (branchLabel2 == null) {
                    if (branchLabel != null) {
                        codeStream.ifeq(branchLabel);
                    }
                } else if (branchLabel == null) {
                    codeStream.ifne(branchLabel2);
                }
            }
            codeStream.recordPositionsFrom(n, this.sourceStart);
            return;
        }
        constant = this.left.constant;
        if (constant != Constant.NotAConstant && (this.left.implicitConversion & 0xFF) >> 4 == 10 && constant.intValue() == 0) {
            this.right.generateCode(blockScope, codeStream, bl);
            if (bl) {
                if (branchLabel2 == null) {
                    if (branchLabel != null) {
                        codeStream.ifeq(branchLabel);
                    }
                } else if (branchLabel == null) {
                    codeStream.ifne(branchLabel2);
                }
            }
            codeStream.recordPositionsFrom(n, this.sourceStart);
            return;
        }
        if (this.right instanceof NullLiteral) {
            if (this.left instanceof NullLiteral) {
                if (bl && branchLabel2 == null && branchLabel != null) {
                    codeStream.goto_(branchLabel);
                }
            } else {
                this.left.generateCode(blockScope, codeStream, bl);
                if (bl) {
                    if (branchLabel2 == null) {
                        if (branchLabel != null) {
                            codeStream.ifnull(branchLabel);
                        }
                    } else if (branchLabel == null) {
                        codeStream.ifnonnull(branchLabel2);
                    }
                }
            }
            codeStream.recordPositionsFrom(n, this.sourceStart);
            return;
        }
        if (this.left instanceof NullLiteral) {
            this.right.generateCode(blockScope, codeStream, bl);
            if (bl) {
                if (branchLabel2 == null) {
                    if (branchLabel != null) {
                        codeStream.ifnull(branchLabel);
                    }
                } else if (branchLabel == null) {
                    codeStream.ifnonnull(branchLabel2);
                }
            }
            codeStream.recordPositionsFrom(n, this.sourceStart);
            return;
        }
        this.left.generateCode(blockScope, codeStream, bl);
        this.right.generateCode(blockScope, codeStream, bl);
        if (bl) {
            if (branchLabel2 == null) {
                if (branchLabel != null) {
                    switch ((this.left.implicitConversion & 0xFF) >> 4) {
                        case 10: {
                            codeStream.if_icmpeq(branchLabel);
                            break;
                        }
                        case 9: {
                            codeStream.fcmpl();
                            codeStream.ifeq(branchLabel);
                            break;
                        }
                        case 7: {
                            codeStream.lcmp();
                            codeStream.ifeq(branchLabel);
                            break;
                        }
                        case 8: {
                            codeStream.dcmpl();
                            codeStream.ifeq(branchLabel);
                            break;
                        }
                        default: {
                            codeStream.if_acmpeq(branchLabel);
                            break;
                        }
                    }
                }
            } else if (branchLabel == null) {
                switch ((this.left.implicitConversion & 0xFF) >> 4) {
                    case 10: {
                        codeStream.if_icmpne(branchLabel2);
                        break;
                    }
                    case 9: {
                        codeStream.fcmpl();
                        codeStream.ifne(branchLabel2);
                        break;
                    }
                    case 7: {
                        codeStream.lcmp();
                        codeStream.ifne(branchLabel2);
                        break;
                    }
                    case 8: {
                        codeStream.dcmpl();
                        codeStream.ifne(branchLabel2);
                        break;
                    }
                    default: {
                        codeStream.if_acmpne(branchLabel2);
                    }
                }
            }
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    @Override
    public boolean isCompactableOperation() {
        return false;
    }

    @Override
    protected Constant optimizedNullComparisonConstant() {
        int n = (this.bits & 0x3F00) >> 8;
        if (n == 18) {
            if (this.left instanceof NullLiteral && this.right instanceof NullLiteral) {
                return BooleanConstant.fromValue(true);
            }
        } else if (n == 29 && this.left instanceof NullLiteral && this.right instanceof NullLiteral) {
            return BooleanConstant.fromValue(false);
        }
        return Constant.NotAConstant;
    }

    @Override
    public TypeBinding resolveType(BlockScope blockScope) {
        boolean bl = this.left instanceof CastExpression;
        if (bl) {
            this.left.bits |= 0x20;
        }
        TypeBinding typeBinding = this.left.resolveType(blockScope);
        boolean bl2 = this.right instanceof CastExpression;
        if (bl2) {
            this.right.bits |= 0x20;
        }
        TypeBinding typeBinding2 = this.right.resolveType(blockScope);
        if (typeBinding == null || typeBinding2 == null) {
            this.constant = Constant.NotAConstant;
            return null;
        }
        CompilerOptions compilerOptions = blockScope.compilerOptions();
        if (compilerOptions.complainOnUninternedIdentityComparison && typeBinding2.hasTypeBit(16) && typeBinding.hasTypeBit(16)) {
            blockScope.problemReporter().uninternedIdentityComparison(this, typeBinding, typeBinding2, blockScope.referenceCompilationUnit());
        }
        boolean bl3 = compilerOptions.sourceLevel >= 0x310000L;
        TypeBinding typeBinding3 = typeBinding;
        TypeBinding typeBinding4 = typeBinding2;
        if (bl3) {
            if (typeBinding3 != TypeBinding.NULL && typeBinding3.isBaseType()) {
                if (!typeBinding4.isBaseType()) {
                    typeBinding4 = blockScope.environment().computeBoxingType(typeBinding4);
                }
            } else if (typeBinding4 != TypeBinding.NULL && typeBinding4.isBaseType()) {
                typeBinding3 = blockScope.environment().computeBoxingType(typeBinding3);
            }
        }
        if (typeBinding3.isBaseType() && typeBinding4.isBaseType()) {
            int n;
            int n2 = typeBinding3.id;
            int n3 = typeBinding4.id;
            int n4 = OperatorSignatures[18][(n2 << 4) + n3];
            this.left.computeConversion(blockScope, TypeBinding.wellKnownType(blockScope, n4 >>> 16 & 0xF), typeBinding);
            this.right.computeConversion(blockScope, TypeBinding.wellKnownType(blockScope, n4 >>> 8 & 0xF), typeBinding2);
            this.bits |= n4 & 0xF;
            if ((n4 & 0xF) == 0) {
                this.constant = Constant.NotAConstant;
                blockScope.problemReporter().invalidOperator(this, typeBinding3, typeBinding4);
                return null;
            }
            if (bl || bl2) {
                CastExpression.checkNeedForArgumentCasts(blockScope, 18, n4, this.left, typeBinding3.id, bl, this.right, typeBinding4.id, bl2);
            }
            this.computeConstant(typeBinding3, typeBinding4);
            Binding binding = Expression.getDirectBinding(this.left);
            if (binding != null && binding == Expression.getDirectBinding(this.right)) {
                if (n2 != 8 && n2 != 9 && !(this.right instanceof Assignment)) {
                    blockScope.problemReporter().comparingIdenticalExpressions(this);
                }
            } else if (this.constant != Constant.NotAConstant && ((n = (this.bits & 0x3F00) >> 8) == 18 && this.constant == BooleanConstant.fromValue(true) || n == 29 && this.constant == BooleanConstant.fromValue(false))) {
                blockScope.problemReporter().comparingIdenticalExpressions(this);
            }
            this.resolvedType = TypeBinding.BOOLEAN;
            return this.resolvedType;
        }
        if (!(typeBinding3.isBaseType() && typeBinding3 != TypeBinding.NULL || typeBinding4.isBaseType() && typeBinding4 != TypeBinding.NULL || !this.checkCastTypesCompatibility(blockScope, typeBinding3, typeBinding4, null, true) && !this.checkCastTypesCompatibility(blockScope, typeBinding4, typeBinding3, null, true))) {
            Binding binding;
            boolean bl4;
            if (typeBinding4.id == 11 && typeBinding3.id == 11) {
                this.computeConstant(typeBinding3, typeBinding4);
            } else {
                this.constant = Constant.NotAConstant;
            }
            ReferenceBinding referenceBinding = blockScope.getJavaLangObject();
            this.left.computeConversion(blockScope, referenceBinding, typeBinding3);
            this.right.computeConversion(blockScope, referenceBinding, typeBinding4);
            boolean bl5 = (this.left.bits & 0x4000) != 0;
            boolean bl6 = bl4 = (this.right.bits & 0x4000) != 0;
            if (bl5 || bl4) {
                TypeBinding typeBinding5;
                binding = bl5 ? ((CastExpression)this.left).expression.resolvedType : typeBinding3;
                TypeBinding typeBinding6 = typeBinding5 = bl4 ? ((CastExpression)this.right).expression.resolvedType : typeBinding4;
                if (!this.isCastNeeded((TypeBinding)binding, typeBinding5) && (this.checkCastTypesCompatibility(blockScope, (TypeBinding)binding, typeBinding5, null, false) || this.checkCastTypesCompatibility(blockScope, typeBinding5, (TypeBinding)binding, null, false))) {
                    if (bl5) {
                        blockScope.problemReporter().unnecessaryCast((CastExpression)this.left);
                    }
                    if (bl4) {
                        blockScope.problemReporter().unnecessaryCast((CastExpression)this.right);
                    }
                }
            }
            if ((binding = Expression.getDirectBinding(this.left)) != null && binding == Expression.getDirectBinding(this.right) && !(this.right instanceof Assignment)) {
                blockScope.problemReporter().comparingIdenticalExpressions(this);
            }
            this.resolvedType = TypeBinding.BOOLEAN;
            return this.resolvedType;
        }
        this.constant = Constant.NotAConstant;
        blockScope.problemReporter().notCompatibleTypesError(this, typeBinding3, typeBinding4);
        return null;
    }

    private boolean isCastNeeded(TypeBinding typeBinding, TypeBinding typeBinding2) {
        if (typeBinding.isParameterizedType()) {
            return typeBinding2.isBaseType();
        }
        if (typeBinding2.isParameterizedType()) {
            return typeBinding.isBaseType();
        }
        return false;
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.left.traverse(aSTVisitor, blockScope);
            this.right.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

