/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.adapter;

import com.sun.star.io.BufferSizeExceededException;
import com.sun.star.io.IOException;
import com.sun.star.io.NotConnectedException;
import com.sun.star.io.XInputStream;
import com.sun.star.io.XSeekable;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lib.uno.helper.ComponentBase;

public final class ByteArrayToXInputStreamAdapter
extends ComponentBase
implements XInputStream,
XSeekable {
    byte[] m_bytes;
    int m_length;
    int m_pos;
    boolean m_open;

    public ByteArrayToXInputStreamAdapter(byte[] bytes) {
        this.init(bytes);
    }

    public void init(byte[] bytes) {
        this.m_bytes = bytes;
        this.m_length = bytes.length;
        this.m_pos = 0;
        this.m_open = true;
    }

    private void _check() throws NotConnectedException, IOException {
        if (this.m_bytes == null) {
            throw new NotConnectedException("no bytes");
        }
        if (!this.m_open) {
            throw new IOException("input closed");
        }
    }

    @Override
    public int available() throws NotConnectedException, IOException {
        this._check();
        long a = this.m_length - this.m_pos;
        if (a != (long)((int)a)) {
            throw new IOException("integer overflow");
        }
        return (int)a;
    }

    @Override
    public void closeInput() throws NotConnectedException, IOException {
        this._check();
        this.m_open = false;
    }

    @Override
    public int readBytes(byte[][] values, int param) throws NotConnectedException, BufferSizeExceededException, IOException {
        this._check();
        try {
            int remain = this.m_length - this.m_pos;
            if (param > remain) {
                param = remain;
            }
            if (values[0] == null) {
                values[0] = new byte[param];
            }
            System.arraycopy(this.m_bytes, this.m_pos, values[0], 0, param);
            this.m_pos += param;
            return param;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new BufferSizeExceededException(ex, "buffer overflow");
        }
        catch (Exception ex) {
            throw new IOException(ex, "error accessing buffer");
        }
    }

    @Override
    public int readSomeBytes(byte[][] values, int param) throws NotConnectedException, BufferSizeExceededException, IOException {
        return this.readBytes(values, param);
    }

    @Override
    public void skipBytes(int param) throws NotConnectedException, BufferSizeExceededException, IOException {
        this._check();
        if (param > this.m_length - this.m_pos) {
            throw new BufferSizeExceededException("buffer overflow");
        }
        this.m_pos += param;
    }

    @Override
    public long getLength() throws IOException {
        if (this.m_bytes != null) {
            return this.m_length;
        }
        throw new IOException("no bytes");
    }

    @Override
    public long getPosition() throws IOException {
        if (this.m_bytes != null) {
            return this.m_pos;
        }
        throw new IOException("no bytes");
    }

    @Override
    public void seek(long param) throws IllegalArgumentException, IOException {
        if (this.m_bytes != null) {
            if (param < 0L || param > (long)this.m_length) {
                throw new IllegalArgumentException("invalid seek position");
            }
        } else {
            throw new IOException("no bytes");
        }
        this.m_pos = (int)param;
    }
}

