/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.transport;

import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.opensearch.common.settings.Settings;
import org.opensearch.security.transport.InterClusterRequestEvaluator;
import org.opensearch.transport.TransportRequest;

public final class OIDClusterRequestEvaluator
implements InterClusterRequestEvaluator {
    private final String certOid;

    public OIDClusterRequestEvaluator(Settings settings) {
        this.certOid = settings.get("plugins.security.cert.oid", "1.2.3.4.5.5");
    }

    @Override
    public boolean isInterClusterRequest(TransportRequest request, X509Certificate[] localCerts, X509Certificate[] peerCerts, String principal) {
        if (localCerts != null && localCerts.length > 0 && peerCerts != null && peerCerts.length > 0) {
            byte[] localValue = localCerts[0].getExtensionValue(this.certOid);
            byte[] peerValue = peerCerts[0].getExtensionValue(this.certOid);
            if (localValue != null && peerValue != null) {
                return Arrays.equals(localValue, peerValue);
            }
        }
        return false;
    }
}

