/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.filter;

import io.netty.handler.ssl.SslHandler;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.SSLEngine;
import org.opensearch.http.netty4.Netty4HttpChannel;
import org.opensearch.rest.RestRequest;
import org.opensearch.security.filter.SecurityRequest;

public class OpenSearchRequest
implements SecurityRequest {
    protected final RestRequest underlyingRequest;

    OpenSearchRequest(RestRequest request) {
        this.underlyingRequest = request;
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.underlyingRequest.getHeaders();
    }

    @Override
    public SSLEngine getSSLEngine() {
        if (this.underlyingRequest == null || this.underlyingRequest.getHttpChannel() == null || !(this.underlyingRequest.getHttpChannel() instanceof Netty4HttpChannel)) {
            return null;
        }
        Netty4HttpChannel httpChannel = (Netty4HttpChannel)this.underlyingRequest.getHttpChannel();
        SslHandler sslhandler = (SslHandler)httpChannel.getNettyChannel().pipeline().get("ssl_http");
        return sslhandler != null ? sslhandler.engine() : null;
    }

    @Override
    public String path() {
        return this.underlyingRequest.path();
    }

    @Override
    public RestRequest.Method method() {
        return this.underlyingRequest.method();
    }

    @Override
    public Optional<InetSocketAddress> getRemoteAddress() {
        return Optional.ofNullable(this.underlyingRequest.getHttpChannel().getRemoteAddress());
    }

    @Override
    public String uri() {
        return this.underlyingRequest.uri();
    }

    @Override
    public Map<String, String> params() {
        return this.underlyingRequest.params();
    }

    public RestRequest breakEncapsulationForRequest() {
        return this.underlyingRequest;
    }
}

