/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.util.Map;
import javajs.api.GenericBinaryDocument;
import javajs.api.GenericLineReader;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.OC;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.T4;
import javajs.util.V3;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.MSInterface;
import org.jmol.api.Interface;
import org.jmol.api.JmolAdapter;
import org.jmol.api.SymmetryInterface;
import org.jmol.script.SV;
import org.jmol.util.BSUtil;
import org.jmol.util.Logger;
import org.jmol.util.SimpleUnitCell;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;

public abstract class AtomSetCollectionReader
implements GenericLineReader {
    public static final float ANGSTROMS_PER_BOHR = 0.5291772f;
    protected static final String CELL_TYPE_CONVENTIONAL = "conventional";
    protected static final String CELL_TYPE_PRIMITIVE = "primitive";
    public boolean isBinary;
    public boolean debugging;
    protected boolean requiresBSFilter;
    public M3 primitiveToCrystal;
    public AtomSetCollection asc;
    public BufferedReader reader;
    public GenericBinaryDocument binaryDoc;
    protected String readerName;
    public Map<String, Object> htParams;
    public Lst<P3[]> trajectorySteps;
    private Object domains;
    public Object validation;
    public Object dssr;
    protected boolean isConcatenated;
    public String addedData;
    public String addedDataKey;
    public Map<String, Object> thisBiomolecule;
    public Lst<M4> lstNCS;
    public boolean floatifyJavaDouble = true;
    public String line;
    public String prevline;
    protected int[] next = new int[1];
    protected int ptLine;
    public boolean checkNearAtoms = true;
    protected String latticeType;
    public int[] latticeCells;
    public Object fillRange;
    public boolean doProcessLines;
    public boolean iHaveUnitCell;
    public boolean iHaveSymmetryOperators;
    public boolean continuing = true;
    public Viewer vwr;
    public boolean doApplySymmetry;
    protected boolean ignoreFileSymmetryOperators;
    protected boolean isTrajectory;
    public boolean applySymmetryToBonds;
    protected boolean doCheckUnitCell;
    protected boolean getHeader;
    protected boolean isSequential;
    public boolean optimize2D;
    public boolean noHydrogens;
    public boolean noMinimize;
    public boolean is2D;
    public boolean isMolecular;
    protected int templateAtomCount;
    public int modelNumber;
    public int vibrationNumber;
    public int desiredVibrationNumber = Integer.MIN_VALUE;
    protected BS bsModels;
    protected boolean useFileModelNumbers;
    protected boolean havePartialChargeFilter;
    public String calculationType = "?";
    protected String sgName;
    protected boolean ignoreFileUnitCell;
    protected boolean ignoreFileSpaceGroupName;
    public float[] unitCellParams;
    protected int desiredModelNumber = Integer.MIN_VALUE;
    public SymmetryInterface symmetry;
    protected OC out;
    protected boolean iHaveFractionalCoordinates;
    public boolean doPackUnitCell;
    protected P3 ptSupercell;
    protected boolean mustFinalizeModelSet;
    protected boolean forcePacked;
    public Number packingRange;
    static final float OLD_PACKING_RANGE = 0.02f;
    private static final float LOW_PRECISION_PACKING_RANGE = 1.0E-4f;
    protected float cellSlop = 1.0E-4f;
    protected boolean rotateHexCell;
    protected boolean isPrimitive;
    public int modDim;
    protected boolean lowPrecision;
    private boolean highprecision0 = Viewer.isHighPrecision;
    private SB loadNote = new SB();
    public boolean doConvertToFractional;
    boolean fileCoordinatesAreFractional;
    protected boolean merging;
    float symmetryRange;
    private int[] firstLastStep;
    private int lastModelNumber = Integer.MAX_VALUE;
    public int desiredSpaceGroupIndex = -1;
    protected float latticeScaling = Float.NaN;
    protected P3 unitCellOffset;
    private boolean unitCellOffsetFractional;
    private Lst<String> moreUnitCellInfo;
    public T3 paramsLattice;
    public boolean paramsCentroid;
    private boolean paramsPacked;
    protected P3 fileScaling;
    protected P3 fileOffset;
    private P3 fileOffsetFractional;
    protected String filePath;
    protected String fileName;
    public int baseAtomIndex;
    public int baseBondIndex;
    protected int stateScriptVersionInt = Integer.MAX_VALUE;
    protected boolean isFinalized;
    protected boolean noPack;
    protected int precision;
    protected boolean haveModel;
    private String previousSpaceGroup;
    private float[] previousUnitCell;
    private int nMatrixElements = 0;
    public float[] ucItems;
    protected M3 matUnitCellOrientation;
    protected BS bsFilter;
    public String filter;
    public String filterCased;
    public boolean haveAtomFilter;
    private boolean filterAltLoc;
    private boolean filterGroup3;
    private boolean filterChain;
    private boolean filterAtomName;
    private boolean filterAtomType;
    private String filterAtomTypeStr;
    private String filterAtomNameTerminator = ";";
    private boolean filterElement;
    protected boolean filterHetero;
    protected boolean filterAllHetero;
    private boolean filterEveryNth;
    String filterSymop;
    private int filterN;
    private int nFiltered;
    private boolean doSetOrientation;
    protected boolean doCentralize;
    protected boolean addVibrations;
    protected boolean useAltNames;
    protected boolean ignoreStructure;
    protected boolean isDSSP1;
    protected boolean allowPDBFilter;
    public boolean doReadMolecularOrbitals;
    protected boolean reverseModels;
    private String nameRequired;
    public boolean doCentroidUnitCell;
    public boolean centroidPacked;
    public String strSupercell;
    public boolean allow_a_len_1 = false;
    public boolean slabXY;
    private boolean polymerX;
    boolean fixUnitCell;
    private String filter1;
    private String filter2;
    private String filter1Cased;
    private String filter2Cased;
    private M3 matRot;
    public MSInterface ms;
    public boolean vibsFractional = false;
    private String previousScript;
    private String siteScript;

    protected void setup(String fullPath, Map<String, Object> htParams, Object readerOrDocument) {
        this.setupASCR(fullPath, htParams, readerOrDocument);
    }

    protected void setupASCR(String fullPath, Map<String, Object> htParams, Object readerOrDocument) {
        if (fullPath == null) {
            return;
        }
        this.debugging = Logger.debugging;
        this.htParams = htParams;
        this.filePath = FileManager.stripTypePrefix("" + htParams.get("fullPathName"));
        int i = this.filePath.lastIndexOf(47);
        this.fileName = this.filePath.substring(i + 1);
        if (readerOrDocument instanceof BufferedReader) {
            this.reader = (BufferedReader)readerOrDocument;
        } else if (readerOrDocument instanceof GenericBinaryDocument) {
            this.binaryDoc = (GenericBinaryDocument)readerOrDocument;
        }
    }

    Object readData() throws Exception {
        this.initialize();
        this.asc = new AtomSetCollection(this.readerName, this, null, null);
        try {
            this.initializeReader();
            if (this.binaryDoc == null) {
                if (this.line == null && this.continuing) {
                    this.rd();
                }
                while (this.line != null && this.continuing) {
                    if (!this.checkLine()) continue;
                    this.rd();
                }
            } else {
                this.binaryDoc.setOutputChannel(this.out);
                this.processBinaryDocument();
            }
            this.finalizeSubclassReader();
            if (!this.isFinalized) {
                this.finalizeReaderASCR();
            }
        }
        catch (Throwable e) {
            Logger.info("Reader error: " + e);
            e.printStackTrace();
            this.setError(e);
        }
        if (this.reader != null) {
            this.reader.close();
        }
        if (this.binaryDoc != null) {
            this.binaryDoc.close();
        }
        return this.finish();
    }

    private void fixBaseIndices() {
        try {
            Integer ii = (Integer)this.htParams.get("baseModelIndex");
            if (ii == null) {
                return;
            }
            int baseModelIndex = ii;
            this.baseAtomIndex += this.asc.ac;
            this.baseBondIndex += this.asc.bondCount;
            this.htParams.put("baseAtomIndex", this.baseAtomIndex);
            this.htParams.put("baseBondIndex", this.baseBondIndex);
            this.htParams.put("baseModelIndex", baseModelIndex += this.asc.atomSetCount);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Object readDataObject(Object node) throws Exception {
        this.initialize();
        this.asc = new AtomSetCollection(this.readerName, this, null, null);
        this.initializeReader();
        this.processDOM(node);
        return this.finish();
    }

    protected void processDOM(Object DOMNode) {
    }

    protected void processBinaryDocument() throws Exception {
    }

    protected void initializeReader() throws Exception {
    }

    protected boolean checkLine() throws Exception {
        return true;
    }

    public boolean checkLastModel() {
        if (this.isLastModel(this.modelNumber) && this.doProcessLines) {
            this.doProcessLines = false;
            this.continuing = false;
            return false;
        }
        this.doProcessLines = false;
        return true;
    }

    public boolean isLastModel(int modelNumber) {
        return this.desiredModelNumber > 0 || modelNumber >= this.lastModelNumber;
    }

    public void appendLoadNote(String info) {
        if (info == null) {
            this.loadNote = new SB();
            return;
        }
        this.loadNote.append(info).append("\n");
        Logger.info(info);
    }

    protected void initializeTrajectoryFile() {
        this.asc.addAtom(new Atom());
        this.trajectorySteps = (Lst)this.htParams.get("trajectorySteps");
        if (this.trajectorySteps == null) {
            this.trajectorySteps = new Lst();
            this.htParams.put("trajectorySteps", this.trajectorySteps);
        }
    }

    protected void finalizeSubclassReader() throws Exception {
    }

    protected void finalizeReaderASCR() throws Exception {
        this.isFinalized = true;
        if (this.asc.atomSetCount > 0) {
            Map<String, Object> info;
            if (this.asc.atomSetCount == 1) {
                this.asc.setCurrentModelInfo("dbName", this.htParams.get("dbName"));
                this.asc.setCurrentModelInfo("auxFiles", this.htParams.get("auxFiles"));
            }
            this.applySymmetryAndSetTrajectory();
            this.asc.finalizeStructures();
            if (this.doCentralize) {
                this.asc.centralize();
            }
            if (this.fillRange != null) {
                this.asc.setInfo("boundbox", this.fillRange);
            }
            if ((info = this.asc.getAtomSetAuxiliaryInfo(0)) != null) {
                if (this.domains != null) {
                    this.asc.setGlobalBoolean(5);
                    String s = ((SV)this.domains).getMapKeys(2, true);
                    int pt = s.indexOf("{ ", 2);
                    if (pt >= 0) {
                        s = s.substring(pt + 2);
                    }
                    if ((pt = s.indexOf("_metadata")) < 0) {
                        pt = s.indexOf("metadata");
                    }
                    if (pt >= 0) {
                        s = s.substring(0, pt);
                    }
                    s = PT.rep(PT.replaceAllCharacters(s, "{}", "").trim(), "\n", "\n  ") + "\n\nUse SHOW DOMAINS for details.";
                    this.appendLoadNote("\nDomains loaded:\n   " + s);
                    int i = this.asc.atomSetCount;
                    while (--i >= 0) {
                        info = this.asc.getAtomSetAuxiliaryInfo(i);
                        info.put("domains", this.domains);
                    }
                }
                if (this.validation != null) {
                    int i = this.asc.atomSetCount;
                    while (--i >= 0) {
                        info = this.asc.getAtomSetAuxiliaryInfo(i);
                        info.put("validation", this.validation);
                    }
                }
                if (this.dssr != null) {
                    info.put("dssrJSON", Boolean.TRUE);
                    int i = this.asc.atomSetCount;
                    while (--i >= 0) {
                        info = this.asc.getAtomSetAuxiliaryInfo(i);
                        info.put("dssr", this.dssr);
                    }
                }
            }
        }
        if (!this.floatifyJavaDouble) {
            this.asc.setInfo("highPrecision", Boolean.TRUE);
        }
        this.setLoadNote();
    }

    protected String setLoadNote() {
        String s = this.loadNote.toString();
        if (this.loadNote.length() > 0) {
            this.asc.setInfo("modelLoadNote", s);
        }
        return s;
    }

    public void setIsPDB() {
        this.asc.setGlobalBoolean(4);
        if (this.htParams.get("pdbNoHydrogens") != null) {
            this.asc.setInfo("pdbNoHydrogens", this.htParams.get("pdbNoHydrogens"));
        }
        if (this.checkFilterKey("ADDHYDROGENS")) {
            this.asc.setInfo("pdbAddHydrogens", Boolean.TRUE);
        }
    }

    protected void setModelPDB(boolean isPDB) {
        if (isPDB) {
            this.asc.setGlobalBoolean(4);
        } else {
            this.asc.clearGlobalBoolean(4);
        }
        this.asc.setCurrentModelInfo(JC.getBoolName(4), isPDB ? Boolean.TRUE : null);
    }

    private Object finish() {
        String name;
        String fileType;
        String s;
        if (!this.highprecision0) {
            this.vwr.setBooleanPropertyTok("doubleprecision", 603979831, this.highprecision0);
        }
        this.asc.setInfo("loadState", (s = (String)this.htParams.get("loadState")) == null ? "" : s);
        s = (String)this.htParams.get("smilesString");
        if (s != null) {
            this.asc.setInfo("smilesString", s);
        }
        if (!this.htParams.containsKey("templateAtomCount")) {
            this.htParams.put("templateAtomCount", this.asc.ac);
        }
        if (this.bsFilter != null) {
            this.htParams.put("filteredAtomCount", BSUtil.cardinalityOf(this.bsFilter));
            this.htParams.put("bsFilter", this.bsFilter);
        }
        if (!this.calculationType.equals("?")) {
            this.asc.setInfo("calculationType", this.calculationType);
        }
        if ((fileType = (name = this.asc.fileTypeName)).indexOf("(") >= 0) {
            fileType = fileType.substring(0, fileType.indexOf("("));
        }
        int i = this.asc.atomSetCount;
        while (--i >= 0) {
            this.asc.setModelInfoForSet("fileName", this.filePath, i);
            this.asc.setModelInfoForSet("fileType", fileType, i);
        }
        this.asc.freeze(this.reverseModels);
        if (this.asc.errorMessage != null) {
            return this.asc.errorMessage + "\nfor file " + this.filePath + "\ntype " + name;
        }
        if (!this.merging && (this.asc.bsAtoms == null ? this.asc.ac == 0 : this.asc.bsAtoms.nextSetBit(0) < 0) && fileType.indexOf("DataOnly") < 0 && this.asc.atomSetInfo.get("dataOnly") == null) {
            return "No atoms found\nfor file " + this.filePath + "\ntype " + name;
        }
        this.fixBaseIndices();
        return this.asc;
    }

    private void setError(Throwable e) {
        String s = e.getMessage();
        this.asc.errorMessage = this.line == null ? "Error reading file at end of file \n" + s : "Error reading file at line " + this.ptLine + ":\n" + this.line + "\n" + s;
        e.printStackTrace();
    }

    private void initialize() {
        boolean isHighPrecision;
        if (this.htParams.containsKey("baseAtomIndex")) {
            this.baseAtomIndex = (Integer)this.htParams.get("baseAtomIndex");
        }
        if (this.htParams.containsKey("baseBondIndex")) {
            this.baseBondIndex = (Integer)this.htParams.get("baseBondIndex");
        }
        this.initializeSymmetry();
        this.vwr = (Viewer)this.htParams.remove("vwr");
        if (this.htParams.containsKey("stateScriptVersionInt")) {
            this.stateScriptVersionInt = (Integer)this.htParams.get("stateScriptVersionInt");
        }
        this.packingRange = (Number)this.htParams.get("packingRange");
        boolean bl = isHighPrecision = this.htParams.get("highPrecision") != null;
        if (this.packingRange == null && isHighPrecision) {
            this.floatifyJavaDouble = false;
            this.packingRange = Float.valueOf(1.0E-4f);
        }
        this.merging = this.htParams.containsKey("merging");
        this.getHeader = this.htParams.containsKey("getHeader");
        this.isSequential = this.htParams.containsKey("isSequential");
        this.readerName = (String)this.htParams.get("readerName");
        if (this.htParams.containsKey("outputChannel")) {
            this.out = (OC)this.htParams.get("outputChannel");
        }
        if (this.htParams.containsKey("vibrationNumber")) {
            this.desiredVibrationNumber = (Integer)this.htParams.get("vibrationNumber");
        } else if (this.htParams.containsKey("modelNumber")) {
            this.desiredModelNumber = (Integer)this.htParams.get("modelNumber");
        }
        this.applySymmetryToBonds = this.htParams.containsKey("applySymmetryToBonds");
        this.bsFilter = this.requiresBSFilter ? (BS)this.htParams.get("bsFilter") : null;
        this.setFilter(null);
        this.fillRange = this.htParams.get("fillRange");
        this.paramsLattice = (T3)this.htParams.get("lattice");
        Object o = this.htParams.get("supercell");
        this.noPack = this.checkFilterKey("NOPACK");
        if (this.strSupercell != null && !this.noPack) {
            this.forcePacked = true;
        }
        if (o instanceof P3) {
            this.ptSupercell = (P3)o;
            P3 s = this.ptSupercell;
            if (s.length() != 1.0f) {
                this.strSupercell = (int)s.x + "a," + (int)s.y + "b," + (int)s.z + "c";
            }
        } else if (o instanceof String) {
            this.strSupercell = (String)o;
        }
        int ptFile = this.htParams.containsKey("ptFile") ? (Integer)this.htParams.get("ptFile") : -1;
        this.isTrajectory = this.htParams.containsKey("isTrajectory");
        if (ptFile > 0 && this.htParams.containsKey("firstLastSteps")) {
            Object val = ((Lst)this.htParams.get("firstLastSteps")).get(ptFile - 1);
            if (val instanceof BS) {
                this.bsModels = (BS)val;
            } else {
                this.firstLastStep = (int[])val;
            }
        } else if (this.htParams.containsKey("firstLastStep")) {
            this.firstLastStep = (int[])this.htParams.get("firstLastStep");
        } else if (this.htParams.containsKey("bsModels")) {
            this.bsModels = (BS)this.htParams.get("bsModels");
        }
        boolean bl2 = this.useFileModelNumbers = this.htParams.containsKey("useFileModelNumbers") || this.checkFilterKey("USEFILEMODELNUMBERS");
        if (this.htParams.containsKey("templateAtomCount")) {
            this.templateAtomCount = (Integer)this.htParams.get("templateAtomCount");
        }
        if (this.bsModels != null || this.firstLastStep != null) {
            this.desiredModelNumber = Integer.MIN_VALUE;
        }
        if (this.bsModels == null && this.firstLastStep != null) {
            if (this.firstLastStep[0] < 0) {
                this.firstLastStep[0] = 0;
            }
            if (this.firstLastStep[2] == 0 || this.firstLastStep[1] < this.firstLastStep[0]) {
                this.firstLastStep[1] = -1;
            }
            if (this.firstLastStep[2] < 1) {
                this.firstLastStep[2] = 1;
            }
            this.bsModels = BSUtil.newAndSetBit(this.firstLastStep[0]);
            if (this.firstLastStep[1] > this.firstLastStep[0]) {
                for (int i = this.firstLastStep[0]; i <= this.firstLastStep[1]; i += this.firstLastStep[2]) {
                    this.bsModels.set(i);
                }
            }
        }
        if (this.bsModels != null && (this.firstLastStep == null || this.firstLastStep[1] != -1)) {
            this.lastModelNumber = this.bsModels.length();
        }
        this.symmetryRange = this.htParams.containsKey("symmetryRange") ? ((Float)this.htParams.get("symmetryRange")).floatValue() : 0.0f;
        this.paramsCentroid = this.htParams.containsKey("centroid");
        this.paramsPacked = this.htParams.containsKey("packed");
        this.initializeSymmetryOptions();
        if (this.htParams.containsKey("spaceGroupIndex")) {
            this.desiredSpaceGroupIndex = (Integer)this.htParams.get("spaceGroupIndex");
            if (this.desiredSpaceGroupIndex == -2) {
                this.sgName = (String)this.htParams.get("spaceGroupName");
            }
            this.ignoreFileSpaceGroupName = this.desiredSpaceGroupIndex == -2 || this.desiredSpaceGroupIndex >= 0;
            boolean bl3 = this.ignoreFileSymmetryOperators = this.desiredSpaceGroupIndex != -1;
        }
        if (this.htParams.containsKey("unitCellOffset")) {
            this.fileScaling = P3.new3(1.0f, 1.0f, 1.0f);
            this.fileOffset = (P3)this.htParams.get("unitCellOffset");
            this.fileOffsetFractional = P3.newP(this.fileOffset);
            this.unitCellOffsetFractional = this.htParams.containsKey("unitCellOffsetFractional");
        }
        if (this.htParams.containsKey("unitcell")) {
            float[] fParams = (float[])this.htParams.get("unitcell");
            if (this.merging) {
                this.setFractionalCoordinates(true);
            }
            if (fParams.length == 9) {
                this.addExplicitLatticeVector(0, fParams, 0);
                this.addExplicitLatticeVector(1, fParams, 3);
                this.addExplicitLatticeVector(2, fParams, 6);
            } else {
                this.setUnitCell(fParams[0], fParams[1], fParams[2], fParams[3], fParams[4], fParams[5]);
            }
            this.ignoreFileUnitCell = this.iHaveUnitCell;
            if (this.merging && !this.iHaveUnitCell) {
                this.setFractionalCoordinates(false);
            }
        }
        this.domains = this.htParams.get("domains");
        this.validation = this.htParams.get("validation");
        this.dssr = this.htParams.get("dssr");
        this.isConcatenated = this.htParams.containsKey("concatenate");
    }

    protected float parsePrecision(String s) {
        int pt = s.indexOf(46) + 1;
        if (pt >= 0) {
            this.precision = Math.max(this.precision, s.length() - pt);
        }
        return this.parseFloatStr(s);
    }

    private void setLowPrecision() {
        this.lowPrecision = true;
        this.cellSlop = 1.0E-4f;
        if (this.packingRange == null) {
            this.packingRange = (double)1.0E-4f;
        }
    }

    protected void setPrecision() {
        boolean isHigh;
        if (this.lowPrecision) {
            isHigh = false;
            this.precision = 4;
        } else {
            this.precision = this.precision > 1000 ? (this.precision -= 1000) : Math.min(12, Math.max(4, this.precision));
            boolean bl = isHigh = this.precision >= 7;
            if (isHigh) {
                this.vwr.setBooleanProperty("doubleprecision", true);
                if (Viewer.isHighPrecision) {
                    this.cellSlop = 1.0E-12f;
                    this.packingRange = (double)this.cellSlop;
                    this.asc.setInfo("highPrecision", Boolean.TRUE);
                } else {
                    isHigh = false;
                    this.precision = 6;
                    this.appendLoadNote("Structure read has high precision but this version of Jmol uses float precision.\nUse JmolD.jar or JavaScript for full precision.");
                }
            }
        }
        if (!isHigh && this.precision < 10) {
            this.cellSlop = (float)Math.pow(10.0, -this.precision);
        }
        this.symmetry.setPrecision(this.cellSlop);
        this.unitCellParams[26] = this.cellSlop;
        if (this.fileCoordinatesAreFractional) {
            int i = this.asc.ac;
            int n = this.asc.getLastAtomSetAtomIndex();
            while (--i >= n) {
                this.symmetry.twelfthify(this.asc.atoms[i]);
            }
        }
        this.appendLoadNote("Precision set to " + this.precision);
    }

    protected void initializeSymmetryOptions() {
        this.latticeCells = new int[4];
        this.doApplySymmetry = false;
        T3 pt = this.paramsLattice;
        if (pt == null || pt.length() == 0.0f) {
            if (!this.forcePacked && this.strSupercell == null) {
                return;
            }
            pt = P3.new3(1.0f, 1.0f, 1.0f);
        }
        this.latticeCells[0] = (int)pt.x;
        this.latticeCells[1] = (int)pt.y;
        this.latticeCells[2] = (int)pt.z;
        if (pt instanceof T4) {
            this.latticeCells[3] = (int)((T4)pt).w;
        }
        this.doCentroidUnitCell = this.paramsCentroid;
        if (this.doCentroidUnitCell && (this.latticeCells[2] == -1 || this.latticeCells[2] == 0)) {
            this.latticeCells[2] = 1;
        }
        boolean isPacked = this.forcePacked || this.paramsPacked;
        this.centroidPacked = this.doCentroidUnitCell && isPacked;
        this.doPackUnitCell = !this.doCentroidUnitCell && (isPacked || this.latticeCells[2] < 0);
        boolean bl = this.doApplySymmetry = this.latticeCells[0] > 0 && this.latticeCells[1] > 0;
        if (!this.doApplySymmetry) {
            this.latticeCells = new int[3];
        }
    }

    public boolean doGetModel(int modelNumber, String title) {
        boolean isOK;
        if (title != null && this.nameRequired != null && this.nameRequired.length() > 0 && title.toUpperCase().indexOf(this.nameRequired) < 0) {
            return false;
        }
        boolean bl = this.bsModels == null ? this.desiredModelNumber < 1 || modelNumber == this.desiredModelNumber : (modelNumber > this.lastModelNumber ? false : (isOK = modelNumber > 0 && this.bsModels.get(modelNumber - 1) || this.haveModel && this.firstLastStep != null && this.firstLastStep[1] < 0 && (this.firstLastStep[2] < 2 || (modelNumber - 1 - this.firstLastStep[0]) % this.firstLastStep[2] == 0)));
        if (isOK && this.desiredModelNumber == 0) {
            this.discardPreviousAtoms();
        }
        this.haveModel |= isOK;
        if (isOK) {
            this.doProcessLines = true;
        }
        return isOK;
    }

    protected void discardPreviousAtoms() {
        this.asc.discardPreviousAtoms();
    }

    protected final void initializeSymmetry() {
        this.previousSpaceGroup = this.sgName;
        this.previousUnitCell = this.unitCellParams;
        this.iHaveUnitCell = this.ignoreFileUnitCell;
        if (!this.ignoreFileUnitCell) {
            this.unitCellParams = new float[27];
            int i = 27;
            while (--i >= 0) {
                this.unitCellParams[i] = Float.NaN;
            }
            this.unitCellParams[25] = this.latticeScaling;
            this.symmetry = null;
        }
        if (!this.ignoreFileSpaceGroupName) {
            this.sgName = "unspecified!";
        }
        this.doCheckUnitCell = false;
    }

    protected void newAtomSet(String name) {
        if (this.asc.iSet >= 0) {
            this.asc.newAtomSet();
            this.asc.setCollectionName("<collection of " + (this.asc.iSet + 1) + " models>");
        } else {
            this.asc.setCollectionName(name);
        }
        this.asc.setModelInfoForSet("name", name, Math.max(0, this.asc.iSet));
        this.asc.setAtomSetName(name);
    }

    protected int cloneLastAtomSet(int ac, P3[] pts) throws Exception {
        int lastAtomCount = this.asc.getLastAtomSetAtomCount();
        this.asc.cloneLastAtomSetFromPoints(ac, pts);
        if (this.asc.haveUnitCell) {
            this.iHaveUnitCell = true;
            this.doCheckUnitCell = true;
            this.sgName = this.previousSpaceGroup;
            this.unitCellParams = this.previousUnitCell;
        }
        return lastAtomCount;
    }

    public void setSpaceGroupName(String name) {
        if (this.ignoreFileSpaceGroupName || name == null) {
            return;
        }
        String s = name.trim();
        if (s.length() == 0 || s.equals("HM:") || s.equals(this.sgName)) {
            return;
        }
        if (!s.equals("P1")) {
            Logger.info("Setting space group name to " + s);
        }
        this.sgName = s;
    }

    public int setSymmetryOperator(String xyz) {
        if (this.ignoreFileSymmetryOperators) {
            return -1;
        }
        int isym = this.asc.getXSymmetry().addSpaceGroupOperation(xyz, true);
        if (isym < 0) {
            Logger.warn("Skippings symmetry operation " + xyz);
        }
        this.iHaveSymmetryOperators = true;
        return isym;
    }

    private void initializeCartesianToFractional() {
        int i;
        for (i = 0; i < 16; ++i) {
            if (Float.isNaN(this.unitCellParams[6 + i])) continue;
            return;
        }
        for (i = 0; i < 16; ++i) {
            this.unitCellParams[6 + i] = i % 5 == 0 ? 1 : 0;
        }
        this.nMatrixElements = 0;
    }

    public void clearUnitCell() {
        if (this.ignoreFileUnitCell) {
            return;
        }
        for (int i = 6; i < 22; ++i) {
            this.unitCellParams[i] = Float.NaN;
        }
        this.checkUnitCell(6);
    }

    public void setUnitCellItem(int i, float x) {
        if (this.ignoreFileUnitCell) {
            return;
        }
        if (i == 0 && x == 1.0f && !this.allow_a_len_1 || i == 3 && x == 0.0f) {
            if (this.ucItems == null) {
                this.ucItems = new float[6];
            }
            this.ucItems[i] = x;
            return;
        }
        if (this.ucItems != null && i < 6) {
            this.ucItems[i] = x;
        }
        if (!Float.isNaN(x) && i >= 6 && Float.isNaN(this.unitCellParams[6])) {
            this.initializeCartesianToFractional();
        }
        this.unitCellParams[i] = x;
        if (this.debugging) {
            Logger.debug("setunitcellitem " + i + " " + x);
        }
        if (i < 6 || Float.isNaN(x)) {
            this.iHaveUnitCell = this.checkUnitCell(6);
        } else if (++this.nMatrixElements == 12) {
            this.iHaveUnitCell = this.checkUnitCell(22);
        }
    }

    public void setUnitCell(float a, float b, float c, float alpha, float beta, float gamma) {
        if (this.ignoreFileUnitCell) {
            return;
        }
        this.clearUnitCell();
        this.unitCellParams[0] = a;
        this.unitCellParams[1] = b;
        this.unitCellParams[2] = c;
        if (alpha != 0.0f) {
            this.unitCellParams[3] = alpha;
        }
        if (beta != 0.0f) {
            this.unitCellParams[4] = beta;
        }
        if (gamma != 0.0f) {
            this.unitCellParams[5] = gamma;
        }
        this.iHaveUnitCell = this.checkUnitCell(6);
    }

    public void addExplicitLatticeVector(int i, float[] xyz, int i0) {
        if (this.ignoreFileUnitCell) {
            return;
        }
        if (i == 0) {
            for (int j = 0; j < 6; ++j) {
                this.unitCellParams[j] = 0.0f;
            }
        }
        i = 6 + i * 3;
        this.unitCellParams[i++] = xyz[i0++];
        this.unitCellParams[i++] = xyz[i0++];
        this.unitCellParams[i] = xyz[i0];
        if (Float.isNaN(this.unitCellParams[0])) {
            for (i = 0; i < 6; ++i) {
                this.unitCellParams[i] = -1.0f;
            }
        }
        this.iHaveUnitCell = this.checkUnitCell(15);
        if (this.iHaveUnitCell) {
            if (this.slabXY || this.polymerX) {
                this.unitCellParams[2] = -1.0f;
            }
            if (this.polymerX) {
                this.unitCellParams[1] = -1.0f;
            }
        }
    }

    private boolean checkUnitCell(int n) {
        for (int i = 0; i < n; ++i) {
            if (!Float.isNaN(this.unitCellParams[i])) continue;
            return false;
        }
        this.fixFloatA(this.unitCellParams);
        if (n == 22 && this.unitCellParams[0] == 1.0f && this.unitCellParams[1] == 1.0f && this.unitCellParams[2] == 1.0f && this.unitCellParams[6] == 1.0f && this.unitCellParams[11] == 1.0f && this.unitCellParams[16] == 1.0f) {
            return false;
        }
        if (n == 6 && Float.isNaN(this.unitCellParams[6])) {
            if (this.slabXY && this.unitCellParams[2] > 0.0f) {
                SimpleUnitCell.addVectors(this.unitCellParams);
                this.unitCellParams[2] = -1.0f;
            } else if (this.polymerX && this.unitCellParams[1] > 0.0f) {
                SimpleUnitCell.addVectors(this.unitCellParams);
                this.unitCellParams[2] = -1.0f;
                this.unitCellParams[1] = -1.0f;
            }
        }
        if (this.doApplySymmetry) {
            this.getSymmetry();
            this.doConvertToFractional = !this.fileCoordinatesAreFractional;
        }
        return true;
    }

    public SymmetryInterface getSymmetry() {
        if (!this.iHaveUnitCell) {
            return null;
        }
        if (this.symmetry == null) {
            this.getNewSymmetry().setUnitCell(this.unitCellParams, false, this.cellSlop);
            this.checkUnitCellOffset();
        }
        if (this.symmetry == null) {
            this.iHaveUnitCell = false;
        } else {
            this.symmetry.setSpaceGroupName(this.sgName);
        }
        return this.symmetry;
    }

    private void checkUnitCellOffset() {
        if (this.fileOffsetFractional == null || this.symmetry == null) {
            return;
        }
        this.fileOffset.setT(this.fileOffsetFractional);
        if (this.unitCellOffsetFractional != this.fileCoordinatesAreFractional) {
            if (this.unitCellOffsetFractional) {
                this.symmetry.toCartesian(this.fileOffset, false);
            } else {
                this.symmetry.toFractional(this.fileOffset, false);
            }
        }
    }

    protected void fractionalizeCoordinates(boolean toFrac) {
        if (this.getSymmetry() == null) {
            return;
        }
        Atom[] a = this.asc.atoms;
        if (toFrac) {
            int i = this.asc.ac;
            while (--i >= 0) {
                this.symmetry.toFractional(a[i], false);
            }
        } else {
            int i = this.asc.ac;
            while (--i >= 0) {
                this.symmetry.toCartesian(a[i], false);
            }
        }
        this.setFractionalCoordinates(toFrac);
    }

    protected SymmetryInterface getNewSymmetry() {
        this.symmetry = (SymmetryInterface)this.getInterface("org.jmol.symmetry.Symmetry");
        return this.symmetry;
    }

    public void setFractionalCoordinates(boolean TF) {
        this.iHaveFractionalCoordinates = this.fileCoordinatesAreFractional = TF;
        this.checkUnitCellOffset();
    }

    protected void setFilterAtomTypeStr(String s) {
        this.filterAtomTypeStr = s;
        this.filterAtomNameTerminator = "\u0000";
    }

    protected void setFilter(String filter0) {
        if (filter0 == null) {
            filter0 = (String)this.htParams.get("filter");
        } else {
            this.bsFilter = null;
            this.filterCased = null;
        }
        if (this.filterCased == null) {
            String string = this.filterCased = filter0 == null ? null : filter0 + ";";
        }
        if (filter0 != null) {
            filter0 = filter0.toUpperCase();
        }
        this.filter = filter0;
        this.doSetOrientation = !this.checkFilterKey("NOORIENT");
        this.doCentralize = !this.checkFilterKey("NOCENTER") && this.checkFilterKey("CENTER");
        this.addVibrations = !this.checkFilterKey("NOVIB");
        this.ignoreStructure = this.checkFilterKey("DSSP");
        this.isDSSP1 = this.checkFilterKey("DSSP1");
        this.doReadMolecularOrbitals = !this.checkFilterKey("NOMO");
        this.useAltNames = this.checkFilterKey("ALTNAME");
        this.reverseModels = this.checkFilterKey("REVERSEMODELS");
        this.allow_a_len_1 = this.checkFilterKey("TOPOS");
        this.slabXY = this.checkFilterKey("SLABXY");
        this.polymerX = !this.slabXY && this.checkFilterKey("POLYMERX");
        this.noHydrogens = this.checkFilterKey("NOH");
        this.noMinimize = this.checkFilterKey("NOMIN");
        boolean bl = this.optimize2D = this.checkFilterKey("2D") && !this.noHydrogens && !this.noMinimize;
        if (this.filter == null) {
            return;
        }
        this.fixUnitCell = this.checkFilterKey("FIXUNITCELL");
        if (this.checkFilterKey("LOWPRECISION")) {
            this.setLowPrecision();
        }
        if (this.checkFilterKey("HETATM")) {
            this.filterHetero = true;
            this.filter = PT.rep(this.filter, "HETATM", "HETATM-Y");
            this.filterCased = PT.rep(this.filterCased, "HETATM", "HETATM-Y");
        }
        if (this.checkFilterKey("ATOM")) {
            this.filterHetero = true;
            this.filter = PT.rep(this.filter, "ATOM", "HETATM-N");
            this.filterCased = PT.rep(this.filterCased, "ATOM", "HETATM-N");
        }
        if (this.checkFilterKey("CELL=")) {
            this.strSupercell = this.filter.substring(this.filter.indexOf("CELL=") + 5).toLowerCase();
        }
        this.nameRequired = PT.getQuotedAttribute(this.filter, "NAME");
        if (this.nameRequired != null) {
            if (this.nameRequired.startsWith("'")) {
                this.nameRequired = PT.split(this.nameRequired, "'")[1];
            } else if (this.nameRequired.startsWith("\"")) {
                this.nameRequired = PT.split(this.nameRequired, "\"")[1];
            }
            this.filter = PT.rep(this.filter, this.nameRequired, "");
            filter0 = this.filter = PT.rep(this.filter, "NAME=", "");
        }
        boolean bl2 = this.filterAtomName = this.checkFilterKey("*.") || this.checkFilterKey("!.");
        if (this.filter.startsWith("_") || this.filter.startsWith("!_") || this.filter.indexOf(";_") >= 0) {
            this.filterElement = this.checkFilterKey("_");
        }
        this.filterGroup3 = this.checkFilterKey("[");
        this.filterChain = this.checkFilterKey(":");
        this.filterAltLoc = this.checkFilterKey("%");
        this.filterEveryNth = this.checkFilterKey("/=");
        this.filterAllHetero = this.checkFilterKey("ALLHET");
        if (this.filterEveryNth) {
            this.filterN = this.parseIntAt(this.filter, this.filter.indexOf("/=") + 2);
        } else if (this.filter.startsWith("=") || this.filter.indexOf(";=") >= 0) {
            this.filterAtomType = this.checkFilterKey("=");
        }
        if (this.filterN == Integer.MIN_VALUE) {
            this.filterEveryNth = false;
        }
        boolean bl3 = this.haveAtomFilter = this.filterAtomName || this.filterAtomType || this.filterElement || this.filterGroup3 || this.filterChain || this.filterAltLoc || this.filterHetero || this.filterEveryNth || this.checkFilterKey("/=");
        if (this.bsFilter == null) {
            String s;
            int prec;
            this.bsFilter = new BS();
            this.htParams.put("bsFilter", this.bsFilter);
            this.filter = (";" + this.filter + ";").replace(',', ';');
            String p = this.getFilter("PRECISION=");
            if (p != null && (prec = PT.parseInt(p)) > 0 && prec <= 16) {
                this.precision = 1000 + prec;
            }
            if ((s = this.getFilter("LATTICESCALING=")) != null && this.unitCellParams.length > 25) {
                this.unitCellParams[25] = this.latticeScaling = this.parseFloatStr(s);
            }
            if ((s = this.getFilter("SYMOP=")) != null) {
                this.filterSymop = " " + s + " ";
            }
            Logger.info("filtering with " + this.filter);
            if (this.haveAtomFilter) {
                this.filter1Cased = this.filterCased;
                this.filter2Cased = "";
                int ipt = this.filter.indexOf("|");
                if (ipt >= 0) {
                    this.filter1Cased = this.filter.substring(0, ipt).trim() + ";";
                    this.filter2Cased = ";" + this.filter.substring(ipt).trim();
                }
                this.filter1 = this.filter1Cased.toUpperCase();
                this.filter2 = this.filter2Cased.length() == 0 ? null : this.filter2Cased.toUpperCase();
            }
        }
    }

    public String getFilterWithCase(String key) {
        int pt = this.filterCased == null ? -1 : this.filterCased.toUpperCase().indexOf(key.toUpperCase());
        return pt < 0 ? null : this.filterCased.substring(pt + key.length(), this.filterCased.indexOf(";", pt));
    }

    public String getFilter(String key) {
        int pt = this.filter == null ? -1 : this.filter.indexOf(key);
        return pt < 0 ? null : this.filter.substring(pt + key.length(), this.filter.indexOf(";", pt));
    }

    public boolean checkFilterKey(String key) {
        return this.filter != null && this.filter.indexOf(key) >= 0;
    }

    public boolean checkAndRemoveFilterKey(String key) {
        if (!this.checkFilterKey(key)) {
            return false;
        }
        this.filter = PT.rep(this.filter, key, "");
        if (this.filter.length() < 3) {
            this.filter = null;
        }
        return true;
    }

    protected boolean filterAtom(Atom atom, int iAtom) {
        if (!this.haveAtomFilter) {
            return true;
        }
        boolean isOK = this.checkFilter(atom, this.filter1, this.filter1Cased);
        if (this.filter2 != null) {
            isOK |= this.checkFilter(atom, this.filter2, this.filter2Cased);
        }
        if (isOK && this.filterEveryNth && (!atom.isHetero || !this.filterAllHetero)) {
            isOK = this.nFiltered++ % this.filterN == 0;
        }
        this.bsFilter.setBitTo(iAtom >= 0 ? iAtom : this.asc.ac, isOK);
        return isOK;
    }

    private boolean checkFilter(Atom atom, String f, String fCased) {
        if (atom.isHetero && this.filterAllHetero) {
            return true;
        }
        return !(this.filterGroup3 && atom.group3 != null && this.filterReject(f, "[", atom.group3.toUpperCase() + "]") || this.filterAtomName && !this.allowAtomName(atom.atomName, f) || this.filterAtomTypeStr != null && atom.atomName != null && atom.atomName.toUpperCase().indexOf("\u0000" + this.filterAtomTypeStr) < 0 || this.filterElement && atom.elementSymbol != null && this.filterReject(f, "_", atom.elementSymbol.toUpperCase() + ";") || this.filterChain && atom.chainID != 0 && this.filterReject(fCased, ":", "" + this.vwr.getChainIDStr(atom.chainID)) || this.filterAltLoc && atom.altLoc != '\u0000' && this.filterReject(f, "%", "" + atom.altLoc) || this.filterHetero && this.allowPDBFilter && this.filterReject(f, "HETATM", atom.isHetero ? "-Y" : "-N"));
    }

    public boolean rejectAtomName(String name) {
        return this.filterAtomName && !this.allowAtomName(name, this.filter);
    }

    private boolean allowAtomName(String atomName, String f) {
        return atomName == null || !this.filterReject(f, ".", atomName.toUpperCase() + this.filterAtomNameTerminator);
    }

    protected boolean filterReject(String f, String code, String atomCode) {
        return f.indexOf(code) >= 0 && f.indexOf("!" + code) >= 0 == f.indexOf(code + atomCode) >= 0;
    }

    protected void set2D() {
        this.asc.setInfo("is2D", Boolean.TRUE);
        this.asc.getBSAtoms(-1);
        if (this.noHydrogens) {
            this.asc.setInfo("noHydrogen", Boolean.TRUE);
            this.optimize2D = false;
        }
        if (this.optimize2D) {
            this.asc.fix2Stereo();
            this.asc.setInfo("doMinimize", Boolean.TRUE);
            this.appendLoadNote("This model is 2D. Its 3D structure was generated.");
        } else {
            this.appendLoadNote("This model is 2D. Its 3D structure has not been generated; use LOAD \"\" FILTER \"2D\" to optimize 3D.");
            this.addJmolScript("select thismodel;wireframe only");
        }
    }

    public boolean doGetVibration(int vibrationNumber) {
        return this.addVibrations && (this.desiredVibrationNumber <= 0 || vibrationNumber == this.desiredVibrationNumber);
    }

    public void setTransform(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3) {
        if (this.matRot != null || !this.doSetOrientation) {
            return;
        }
        this.matRot = new M3();
        V3 v = V3.new3(x1, y1, z1);
        v.normalize();
        this.matRot.setColumnV(0, v);
        v.set(x2, y2, z2);
        v.normalize();
        this.matRot.setColumnV(1, v);
        v.set(x3, y3, z3);
        v.normalize();
        this.matRot.setColumnV(2, v);
        this.asc.setInfo("defaultOrientationMatrix", M3.newM3(this.matRot));
        Quat q = Quat.newM(this.matRot);
        this.asc.setInfo("defaultOrientationQuaternion", q);
        Logger.info("defaultOrientationMatrix = " + this.matRot);
    }

    public void setAtomCoordXYZ(Atom atom, float x, float y, float z) {
        atom.set(x, y, z);
        this.setAtomCoord(atom);
    }

    public Atom setAtomCoordScaled(Atom atom, String[] tokens, int i, float f) {
        if (atom == null) {
            atom = this.asc.addNewAtom();
        }
        this.setAtomCoordXYZ(atom, this.parsePrecision(tokens[i]) * f, this.parsePrecision(tokens[i + 1]) * f, this.parsePrecision(tokens[i + 2]) * f);
        return atom;
    }

    protected void setAtomCoordTokens(Atom atom, String[] tokens, int i) {
        this.setAtomCoordXYZ(atom, this.parsePrecision(tokens[i]), this.parsePrecision(tokens[i + 1]), this.parsePrecision(tokens[i + 2]));
    }

    public Atom addAtomXYZSymName(String[] tokens, int i, String sym, String name) {
        Atom atom = this.asc.addNewAtom();
        if (sym != null) {
            atom.elementSymbol = sym;
        }
        if (name != null) {
            atom.atomName = name;
        }
        this.setAtomCoordTokens(atom, tokens, i);
        return atom;
    }

    public void setAtomCoord(Atom atom) {
        boolean mustFractionalize;
        boolean bl = mustFractionalize = this.doConvertToFractional && !this.fileCoordinatesAreFractional && this.getSymmetry() != null;
        if (this.fileScaling != null) {
            atom.x = atom.x * this.fileScaling.x + this.fileOffset.x;
            atom.y = atom.y * this.fileScaling.y + this.fileOffset.y;
            atom.z = atom.z * this.fileScaling.z + this.fileOffset.z;
        }
        if (mustFractionalize) {
            if (!this.symmetry.haveUnitCell()) {
                this.symmetry.setUnitCell(this.unitCellParams, false, Float.NaN);
            }
            this.symmetry.toFractional(atom, false);
            this.iHaveFractionalCoordinates = true;
        }
        if (this.floatifyJavaDouble && this.fileCoordinatesAreFractional) {
            this.fixFloatPt(atom, 100000.0f);
        }
        this.doCheckUnitCell = true;
    }

    public void addSites(Map<String, Map<String, Object>> htSites) {
        this.asc.setCurrentModelInfo("pdbSites", htSites);
        String sites = "";
        for (Map.Entry<String, Map<String, Object>> entry : htSites.entrySet()) {
            String name = entry.getKey();
            Map<String, Object> htSite = entry.getValue();
            int i = name.length();
            while (--i >= 0) {
                char ch = name.charAt(i);
                if (PT.isLetterOrDigit(ch) || ch == '\'') continue;
                name = name.substring(0, i) + "_" + name.substring(i + 1);
            }
            String groups = (String)htSite.get("groups");
            if (groups.length() == 0) continue;
            this.addSiteScript("@site_" + name + " " + groups);
            this.addSiteScript("site_" + name + " = [\"" + PT.rep(groups, ",", "\",\"") + "\"]");
            sites = sites + ",\"site_" + name + "\"";
        }
        if (sites.length() > 0) {
            this.addSiteScript("site_list = [" + sites.substring(1) + "]");
        }
    }

    public void applySymmetryAndSetTrajectory() throws Exception {
        this.applySymTrajASCR();
    }

    public SymmetryInterface applySymTrajASCR() throws Exception {
        if (this.forcePacked) {
            this.initializeSymmetryOptions();
        }
        boolean doApply = this.iHaveUnitCell && this.doCheckUnitCell;
        SymmetryInterface sym = null;
        if (doApply) {
            sym = this.getSymmetry();
            this.setPrecision();
            sym = this.asc.getXSymmetry().applySymmetryFromReader(sym);
        } else {
            this.asc.setTensors();
        }
        if (this.isTrajectory) {
            this.asc.setTrajectory();
        }
        if (this.moreUnitCellInfo != null) {
            this.asc.setCurrentModelInfo("moreUnitCellInfo", this.moreUnitCellInfo);
            this.moreUnitCellInfo = null;
        }
        this.finalizeSubclassSymmetry(sym != null);
        if (this.merging && sym != null && this.iHaveFractionalCoordinates && this.iHaveUnitCell && this.iHaveSymmetryOperators) {
            this.fractionalizeCoordinates(false);
            this.addJmolScript("modelkit spacegroup P1");
        }
        this.initializeSymmetry();
        return sym;
    }

    protected void finalizeSubclassSymmetry(boolean haveSymmetry) throws Exception {
    }

    protected void doPreSymmetry() throws Exception {
    }

    public void finalizeMOData(Map<String, Object> moData) {
        this.asc.setCurrentModelInfo("moData", moData);
        if (moData == null) {
            return;
        }
        Lst orbitals = (Lst)moData.get("mos");
        if (orbitals != null) {
            Logger.info(orbitals.size() + " molecular orbitals read in model " + this.asc.atomSetCount);
        }
    }

    public static String getElementSymbol(int elementNumber) {
        return JmolAdapter.getElementSymbol(elementNumber);
    }

    protected void fillDataBlock(String[][] data, int minLineLen) throws Exception {
        int nLines = data.length;
        for (int i = 0; i < nLines; ++i) {
            data[i] = PT.getTokens(this.discardLinesUntilNonBlank());
            if (data[i].length >= minLineLen) continue;
            --i;
        }
    }

    protected double[][] fill3x3(String[] tokens, int pt) throws Exception {
        double[][] a = new double[3][3];
        boolean needTokens = tokens == null;
        int pt0 = pt;
        for (int i = 0; i < 3; ++i) {
            if (needTokens || pt >= tokens.length) {
                while ((tokens = PT.getTokens(this.rd())).length < 3) {
                }
                pt = pt0 < 0 ? tokens.length + pt0 : pt0;
            }
            for (int j = 0; j < 3; ++j) {
                a[i][j] = Double.valueOf(tokens[pt++]);
            }
        }
        return a;
    }

    protected float[] fillFloatArray(String s, int width, float[] data) throws Exception {
        String[] tokens = new String[]{};
        int pt = 0;
        for (int i = 0; i < data.length; ++i) {
            while (tokens != null && pt >= tokens.length) {
                if (s == null) {
                    s = this.rd();
                }
                if (width == 0) {
                    tokens = PT.getTokens(s);
                } else {
                    tokens = new String[s.length() / width];
                    for (int j = 0; j < tokens.length; ++j) {
                        tokens[j] = s.substring(j * width, (j + 1) * width);
                    }
                }
                s = null;
                pt = 0;
            }
            if (tokens == null) break;
            data[i] = this.parseFloatStr(tokens[pt++]);
        }
        return data;
    }

    protected void fillFrequencyData(int iAtom0, int ac, int modelAtomCount, boolean[] ignore, boolean isWide, int col0, int colWidth, int[] atomIndexes, int minLineLen, String[][] data) throws Exception {
        boolean withSymmetry;
        boolean bl = withSymmetry = ac != 0 && modelAtomCount != ac && data == null;
        if (ac == 0 && atomIndexes != null) {
            ac = atomIndexes.length;
        }
        int nLines = isWide ? ac : ac * 3;
        int nFreq = ignore.length;
        if (data == null) {
            data = new String[nLines][];
            this.fillDataBlockFixed(data, col0, colWidth, minLineLen);
        } else if (!isWide) {
            int ptNonblank = minLineLen;
            this.fillDataBlockFixed(data, col0, colWidth, -ptNonblank);
            if (data[0] == null) {
                return;
            }
            iAtom0 += this.parseIntAt(this.line, ptNonblank - 5) - 1;
        }
        int i = 0;
        int atomPt = 0;
        while (i < nLines) {
            String[] values = data[i];
            String[] valuesY = isWide ? null : data[++i];
            String[] valuesZ = isWide ? null : data[++i];
            int dataPt = values.length - (isWide ? nFreq * 3 : nFreq) - 1;
            int j = 0;
            for (int jj = 0; jj < nFreq; ++jj) {
                int iAtom;
                String x;
                if ((x = values[++dataPt]).charAt(0) == ')') {
                    x = x.substring(1);
                }
                float vx = this.parseFloatStr(x);
                float vy = this.parseFloatStr(isWide ? values[++dataPt] : valuesY[dataPt]);
                float vz = this.parseFloatStr(isWide ? values[++dataPt] : valuesZ[dataPt]);
                if (ignore[jj]) continue;
                int n = iAtom = atomIndexes == null ? atomPt : atomIndexes[atomPt];
                if (iAtom < 0) continue;
                iAtom += iAtom0 + modelAtomCount * j++;
                if (this.debugging) {
                    Logger.debug("atom " + iAtom + " vib" + j + ": " + vx + " " + vy + " " + vz);
                }
                this.asc.addVibrationVectorWithSymmetry(iAtom, vx, vy, vz, withSymmetry);
            }
            ++i;
            ++atomPt;
        }
    }

    protected void fillDataBlockFixed(String[][] data, int col0, int colWidth, int minLineLen) throws Exception {
        if (colWidth == 0) {
            this.fillDataBlock(data, minLineLen);
            return;
        }
        int nLines = data.length;
        for (int i = 0; i < nLines; ++i) {
            this.discardLinesUntilNonBlank();
            if (minLineLen < 0 && this.line.charAt(-minLineLen) == ' ') {
                data[0] = null;
                return;
            }
            int nFields = (this.line.length() - col0 + 1) / colWidth;
            data[i] = new String[nFields];
            int j = 0;
            int start = col0;
            while (j < nFields) {
                data[i][j] = this.line.substring(start, Math.min(this.line.length(), start + colWidth));
                ++j;
                start += colWidth;
            }
        }
    }

    protected String readLines(int nLines) throws Exception {
        int i = nLines;
        while (--i >= 0) {
            this.rd();
        }
        return this.line;
    }

    public String discardLinesUntilStartsWith(String startsWith) throws Exception {
        while (this.rd() != null && !this.line.startsWith(startsWith)) {
        }
        return this.line;
    }

    public String discardLinesUntilContains(String containsMatch) throws Exception {
        while (this.rd() != null && this.line.indexOf(containsMatch) < 0) {
        }
        return this.line;
    }

    public String discardLinesUntilContains2(String s1, String s2) throws Exception {
        while (this.rd() != null && this.line.indexOf(s1) < 0 && this.line.indexOf(s2) < 0) {
        }
        return this.line;
    }

    public String discardLinesUntilBlank() throws Exception {
        while (this.rd() != null && this.line.trim().length() != 0) {
        }
        return this.line;
    }

    public String discardLinesUntilNonBlank() throws Exception {
        while (this.rd() != null && this.line.trim().length() == 0) {
        }
        return this.line;
    }

    protected void checkLineForScript(String line) {
        this.line = line;
        this.checkCurrentLineForScript();
    }

    public void checkCurrentLineForScript() {
        int pt;
        if (this.line.endsWith("#noautobond")) {
            this.line = this.line.substring(0, this.line.lastIndexOf(35)).trim();
            this.asc.setNoAutoBond();
        }
        if ((pt = this.line.indexOf("jmolscript:")) >= 0) {
            String script = this.line.substring(pt + 11, this.line.length());
            if (script.indexOf("#") >= 0) {
                script = script.substring(0, script.indexOf("#"));
            }
            this.addJmolScript(script);
            this.line = this.line.substring(0, pt).trim();
        }
    }

    public void addJmolScript(String script) {
        Logger.info("#jmolScript: " + script);
        if (this.previousScript == null) {
            this.previousScript = "";
        } else if (!this.previousScript.endsWith(";")) {
            this.previousScript = this.previousScript + ";";
        }
        this.previousScript = this.previousScript + script;
        this.asc.setInfo("jmolscript", this.previousScript);
    }

    protected void addSiteScript(String script) {
        if (this.siteScript == null) {
            this.siteScript = "";
        } else if (!this.siteScript.endsWith(";")) {
            this.siteScript = this.siteScript + ";";
        }
        this.siteScript = this.siteScript + script;
        this.asc.setInfo("sitescript", this.siteScript);
    }

    public String rd() throws Exception {
        return this.RL();
    }

    public String RL() throws Exception {
        this.prevline = this.line;
        this.line = this.reader.readLine();
        if (this.out != null && this.line != null) {
            this.out.append(this.line).append("\n");
        }
        ++this.ptLine;
        if (this.debugging && this.line != null) {
            Logger.info(this.line);
        }
        return this.line;
    }

    protected static final String[] getStrings(String sinfo, int nFields, int width) {
        String[] fields = new String[nFields];
        int i = 0;
        int pt = 0;
        while (i < nFields) {
            fields[i] = sinfo.substring(pt, pt + width);
            ++i;
            pt += width;
        }
        return fields;
    }

    public String[] getTokens() {
        return PT.getTokens(this.line);
    }

    public static float[] getTokensFloat(String s, float[] f, int n) {
        if (f == null) {
            f = new float[n];
        }
        PT.parseFloatArrayDataN(PT.getTokens(s), f, n);
        return f;
    }

    protected float parseFloat() {
        return PT.parseFloatNext(this.line, this.next);
    }

    public float parseFloatStr(String s) {
        this.next[0] = 0;
        return PT.parseFloatNext(s, this.next);
    }

    protected float parseFloatRange(String s, int iStart, int iEnd) {
        this.next[0] = iStart;
        return PT.parseFloatRange(s, iEnd, this.next);
    }

    protected int parseInt() {
        return PT.parseIntNext(this.line, this.next);
    }

    public int parseIntStr(String s) {
        this.next[0] = 0;
        return PT.parseIntNext(s, this.next);
    }

    public int parseIntAt(String s, int iStart) {
        this.next[0] = iStart;
        return PT.parseIntNext(s, this.next);
    }

    protected int parseIntRange(String s, int iStart, int iEnd) {
        this.next[0] = iStart;
        return PT.parseIntRange(s, iEnd, this.next);
    }

    protected String parseToken() {
        return PT.parseTokenNext(this.line, this.next);
    }

    protected String parseTokenStr(String s) {
        this.next[0] = 0;
        return PT.parseTokenNext(s, this.next);
    }

    protected String parseTokenNext(String s) {
        return PT.parseTokenNext(s, this.next);
    }

    protected String parseTokenRange(String s, int iStart, int iEnd) {
        this.next[0] = iStart;
        return PT.parseTokenRange(s, iEnd, this.next);
    }

    protected static Lst<Integer> getFortranFormatLengths(String s) {
        Lst<Integer> vdata = new Lst<Integer>();
        int n = 0;
        int c = 0;
        int factor = 1;
        boolean inN = false;
        boolean inCount = true;
        s = s + ",";
        block5: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '.': {
                    inN = false;
                    continue block5;
                }
                case ',': {
                    for (int j = 0; j < c; ++j) {
                        vdata.addLast(n * factor);
                    }
                    inN = false;
                    inCount = true;
                    c = 0;
                    continue block5;
                }
                case 'X': {
                    n = c;
                    c = 1;
                    factor = -1;
                    continue block5;
                }
                default: {
                    boolean isDigit = PT.isDigit(ch);
                    if (isDigit) {
                        if (inN) {
                            n = n * 10 + ch - 48;
                            continue block5;
                        }
                        if (!inCount) continue block5;
                        c = c * 10 + ch - 48;
                        continue block5;
                    }
                    if (PT.isLetter(ch)) {
                        n = 0;
                        inN = true;
                        inCount = false;
                        factor = 1;
                        continue block5;
                    }
                    inN = false;
                }
            }
        }
        return vdata;
    }

    protected V3[] read3Vectors(boolean isBohr) throws Exception {
        V3[] vectors = new V3[3];
        float[] f = new float[3];
        for (int i = 0; i < 3; ++i) {
            if (i > 0 || Float.isNaN(this.parseFloatStr(this.line))) {
                this.rd();
                if (i == 0 && this.line != null) {
                    i = -1;
                    continue;
                }
            }
            this.fillFloatArray(this.line, 0, f);
            vectors[i] = new V3();
            vectors[i].setA(f);
            if (!isBohr) continue;
            vectors[i].scale(0.5291772f);
        }
        return vectors;
    }

    protected void setElementAndIsotope(Atom atom, String str) {
        int isotope = this.parseIntStr(str);
        if (isotope == Integer.MIN_VALUE) {
            atom.elementSymbol = str;
        } else {
            atom.elementNumber = (short)((str = str.substring(("" + isotope).length())).length() == 0 ? isotope : (isotope << 7) + JmolAdapter.getElementNumber(str));
        }
    }

    public void finalizeModelSet() {
    }

    public void setChainID(Atom atom, String label) {
        atom.chainID = this.vwr.getChainID(label, true);
    }

    @Override
    public String readNextLine() throws Exception {
        if (this.rd() != null && this.line.indexOf("#jmolscript:") >= 0) {
            this.checkCurrentLineForScript();
        }
        return this.line;
    }

    public void appendUunitCellInfo(String info) {
        if (this.moreUnitCellInfo == null) {
            this.moreUnitCellInfo = new Lst();
        }
        this.moreUnitCellInfo.addLast(info);
        this.appendLoadNote(info);
    }

    public Object getInterface(String className) {
        Object o = Interface.getInterface(className, this.vwr, "file");
        if (o == null) {
            throw new NullPointerException("Interface");
        }
        return o;
    }

    public void forceSymmetry(boolean andPack) {
        if (andPack) {
            this.doPackUnitCell = andPack;
        }
        if (!this.doApplySymmetry) {
            this.doApplySymmetry = true;
            this.latticeCells[0] = 1;
            this.latticeCells[1] = 1;
            this.latticeCells[2] = 1;
        }
    }

    public void fixFloatA(float[] pts) {
        if (this.floatifyJavaDouble) {
            int i = pts.length;
            while (--i >= 0) {
                if (Float.isNaN(pts[i])) continue;
                pts[i] = PT.fixFloat(pts[i], 100000.0);
            }
        }
    }

    public void fixDoubleA(double[] pts) {
        if (this.floatifyJavaDouble) {
            int i = pts.length;
            while (--i >= 0) {
                if (Double.isNaN(pts[i])) continue;
                pts[i] = PT.fixDouble(pts[i], 100000.0);
            }
        }
    }

    public void fixFloatPt(P3 pt, float prec) {
        if (this.floatifyJavaDouble) {
            PT.fixPtFloats(pt, prec);
        }
    }
}

