/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelkit;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.JmolScriptEvaluator;
import org.jmol.api.SymmetryInterface;
import org.jmol.i18n.GT;
import org.jmol.modelkit.ModelKitPopup;
import org.jmol.modelset.Atom;
import org.jmol.modelset.AtomCollection;
import org.jmol.modelset.Bond;
import org.jmol.modelset.MeasurementPending;
import org.jmol.modelset.ModelSet;
import org.jmol.script.SV;
import org.jmol.script.ScriptEval;
import org.jmol.util.BSUtil;
import org.jmol.util.Edge;
import org.jmol.util.Elements;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.SimpleUnitCell;
import org.jmol.util.Vibration;
import org.jmol.viewer.MouseState;
import org.jmol.viewer.Viewer;

public class ModelKit {
    static Constraint locked = new Constraint(null, 6, null);
    static Constraint none = new Constraint(null, 0, null);
    Viewer vwr;
    private ModelKitPopup menu;
    static final int STATE_MOLECULAR = 0;
    static final int STATE_XTALVIEW = 1;
    static final int STATE_XTALEDIT = 2;
    static final int STATE_BITS_XTAL = 3;
    static final int STATE_BITS_SYM_VIEW = 28;
    static final int STATE_SYM_NONE = 0;
    static final int STATE_SYM_SHOW = 8;
    static final int STATE_BITS_SYM_EDIT = 224;
    static final int STATE_SYM_APPLYLOCAL = 32;
    static final int STATE_SYM_RETAINLOCAL = 64;
    static final int STATE_SYM_APPLYFULL = 128;
    static final int STATE_BITS_UNITCELL = 1792;
    static final int STATE_UNITCELL_PACKED = 0;
    static final int STATE_UNITCELL_EXTEND = 256;
    static final String OPTIONS_MODE = "optionsMenu";
    static final String XTAL_MODE = "xtalMenu";
    static final String BOND_MODE = "bondMenu";
    static final String ATOM_MODE = "atomMenu";
    private static final P3 Pt000 = new P3();
    int state = 0;
    private String atomHoverLabel = "C";
    private String bondHoverLabel = GT.$("increase order");
    private String[] allOperators;
    private int currentModelIndex = -1;
    protected ModelSet lastModelSet;
    private String lastElementType = "C";
    private BS bsHighlight = new BS();
    private int bondIndex = -1;
    private int bondAtomIndex1 = -1;
    private int bondAtomIndex2 = -1;
    private BS bsRotateBranch;
    private int branchAtomIndex;
    private int[] screenXY = new int[2];
    private boolean isPickAtomAssignCharge;
    private boolean isRotateBond;
    private boolean showSymopInfo = true;
    private boolean hasUnitCell;
    private boolean alertedNoEdit;
    private boolean wasRotating;
    private boolean addXtalHydrogens = true;
    private boolean clickToSetElement = true;
    private boolean autoBond = false;
    private P3 centerPoint;
    private P3 spherePoint;
    String pickAtomAssignType = "C";
    char pickBondAssignType = (char)112;
    P3 viewOffset;
    private double centerDistance;
    private Object symop;
    private int centerAtomIndex = -1;
    private int secondAtomIndex = -1;
    private String drawData;
    private String drawScript;
    private int iatom0;
    private String lastCenter = "0 0 0";
    private String lastOffset = "0 0 0";
    private Atom a0;
    private Atom a3;
    Constraint constraint;
    private String xtalHoverLabel;
    private int atomIndexSphere = -1;
    private Constraint[] atomConstraints;
    private Atom[] minBasisAtoms;
    private SymmetryInterface[] modelSyms;
    private BS minBasis;
    private BS minBasisFixed;
    private BS minBasisModelAtoms;
    private int minBasisModel;
    private BS minSelectionSaved;
    private BS minTempFixed;
    private BS minTempModelAtoms;
    private static int GET = 0;
    static int GET_CREATE = 1;
    private static int GET_DELETE = 2;

    public boolean checkOption(char type, String value) {
        String check = null;
        switch (type) {
            case 'M': {
                check = ";view;edit;molecular;";
                break;
            }
            case 'S': {
                check = ";none;applylocal;retainlocal;applyfull;";
                break;
            }
            case 'U': {
                check = ";packed;extend;";
                break;
            }
            case 'B': {
                check = ";autobond;hidden;showsymopinfo;clicktosetelement;addhydrogen;addhydrogens;";
            }
        }
        return check != null && PT.isOneOf(value, check);
    }

    public void setMenu(ModelKitPopup menu) {
        this.menu = menu;
        this.vwr = menu.vwr;
        menu.modelkit = this;
        this.initializeForModel();
    }

    public void initializeForModel() {
        this.resetBondFields();
        this.allOperators = null;
        this.currentModelIndex = -999;
        this.iatom0 = 0;
        this.secondAtomIndex = -1;
        this.centerAtomIndex = -1;
        this.atomIndexSphere = -1;
        this.spherePoint = null;
        this.centerPoint = null;
        this.symop = null;
        this.setDefaultState(0);
    }

    public void showMenu(int x, int y) {
        this.menu.jpiShow(x, y);
    }

    public String getDefaultModel() {
        return this.addXtalHydrogens ? "5\n\nC 0 0 0\nH .63 .63 .63\nH -.63 -.63 .63\nH -.63 .63 -.63\nH .63 -.63 -.63" : "1\n\nC 0 0 0\n";
    }

    public void updateMenu() {
        this.menu.jpiUpdateComputedMenus();
    }

    public void dispose() {
        this.menu.jpiDispose();
        this.menu.modelkit = null;
        this.menu = null;
        this.vwr = null;
    }

    public boolean isPickAtomAssignCharge() {
        return this.isPickAtomAssignCharge;
    }

    public boolean isHidden() {
        return this.menu.hidden;
    }

    public String getActiveMenu() {
        return this.menu.activeMenu;
    }

    public int getRotateBondIndex() {
        return this.getMKState() == 0 && this.isRotateBond ? this.bondIndex : -1;
    }

    public Object getProperty(String name) {
        if ((name = name.toLowerCase().intern()) == "exists") {
            return Boolean.TRUE;
        }
        if (name == "constraint") {
            return this.constraint;
        }
        if (name == "ismolecular") {
            return this.getMKState() == 0;
        }
        if (name == "minimizing") {
            return this.minBasis != null;
        }
        if (name == "alloperators") {
            return this.allOperators;
        }
        if (name == "data") {
            return this.getinfo();
        }
        return this.setProperty(name, null);
    }

    public synchronized Object setProperty(String key, Object value) {
        try {
            if (this.vwr == null) {
                return null;
            }
            if ((key = key.toLowerCase().intern()) == "hoverlabel") {
                return this.getHoverLabel((Integer)value);
            }
            if (key == "branchatomclicked") {
                if (this.isRotateBond && !this.vwr.acm.isHoverable()) {
                    this.setBranchAtom((Integer)value, true);
                }
                return null;
            }
            if (key == "branchatomdragged") {
                if (this.isRotateBond) {
                    this.setBranchAtom((Integer)value, true);
                }
                return null;
            }
            if (key == "hidemenu") {
                this.menu.hidePopup();
                return null;
            }
            if (key == "constraint") {
                this.constraint = null;
                this.clearAtomConstraints();
                Object[] o = (Object[])value;
                if (o != null) {
                    P3 v1 = (P3)o[0];
                    P3 v2 = (P3)o[1];
                    P4 plane = (P4)o[2];
                    if (v1 != null && v2 != null) {
                        this.constraint = new Constraint(null, 4, new Object[]{v1, v2});
                    } else if (plane != null) {
                        this.constraint = new Constraint(null, 5, new Object[]{plane});
                    } else if (v1 != null) {
                        this.constraint = new Constraint(null, 6, null);
                    }
                }
                return null;
            }
            if (key == "reset") {
                return null;
            }
            if (key == "atompickingmode") {
                if (PT.isOneOf((String)value, ";identify;off;")) {
                    this.exitBondRotation(null);
                    this.vwr.setBooleanProperty("bondPicking", false);
                    this.vwr.acm.exitMeasurementMode("modelkit");
                }
                if ("dragatom".equals(value)) {
                    this.setHoverLabel(ATOM_MODE, ModelKit.getText("dragAtom"));
                }
                return null;
            }
            if (key == "bondpickingmode") {
                if (value.equals("deletebond")) {
                    this.exitBondRotation(ModelKit.getText("bondTo0"));
                } else if (value.equals("identifybond")) {
                    this.exitBondRotation("");
                }
                return null;
            }
            if (key == "bondatomindex") {
                int i = (Integer)value;
                if (i != this.bondAtomIndex2) {
                    this.bondAtomIndex1 = i;
                }
                this.bsRotateBranch = null;
                return null;
            }
            if (key == "highlight") {
                this.bsHighlight = value == null ? new BS() : (BS)value;
                return null;
            }
            if (key == "mode") {
                boolean isEdit = "edit".equals(value);
                this.setMKState("view".equals(value) ? 1 : (isEdit ? 2 : 0));
                if (isEdit) {
                    this.addXtalHydrogens = false;
                }
                return null;
            }
            if (key == "symmetry") {
                this.setDefaultState(2);
                key = ((String)value).toLowerCase().intern();
                this.setSymEdit(key == "applylocal" ? 32 : (key == "retainlocal" ? 64 : (key == "applyfull" ? 128 : 0)));
                this.showXtalSymmetry();
                return null;
            }
            if (key == "unitcell") {
                boolean isPacked = "packed".equals(value);
                this.setUnitCell(isPacked ? 0 : 256);
                this.viewOffset = isPacked ? Pt000 : null;
                return null;
            }
            if (key == "center") {
                this.setDefaultState(1);
                this.centerPoint = (P3)value;
                this.lastCenter = this.centerPoint.x + " " + this.centerPoint.y + " " + this.centerPoint.z;
                this.centerAtomIndex = this.centerPoint instanceof Atom ? ((Atom)this.centerPoint).i : -1;
                this.atomIndexSphere = -1;
                this.secondAtomIndex = -1;
                this.processAtomClick(this.centerAtomIndex);
                return null;
            }
            if (key == "scriptassignbond") {
                this.appRunScript("modelkit assign bond [{" + value + "}] \"" + this.pickBondAssignType + "\"");
                return null;
            }
            if (key == "addhydrogen" || key == "addhydrogens") {
                if (value != null) {
                    this.addXtalHydrogens = ModelKit.isTrue(value);
                }
                return this.addXtalHydrogens;
            }
            if (key == "autobond") {
                if (value != null) {
                    this.autoBond = ModelKit.isTrue(value);
                }
                return this.autoBond;
            }
            if (key == "clicktosetelement") {
                if (value != null) {
                    this.clickToSetElement = ModelKit.isTrue(value);
                }
                return this.clickToSetElement;
            }
            if (key == "hidden") {
                if (value != null) {
                    this.menu.hidden = ModelKit.isTrue(value);
                    if (this.menu.hidden) {
                        this.menu.hidePopup();
                    }
                    this.vwr.setBooleanProperty("modelkitMode", true);
                }
                return this.menu.hidden;
            }
            if (key == "showsymopinfo") {
                if (value != null) {
                    this.showSymopInfo = ModelKit.isTrue(value);
                }
                return this.showSymopInfo;
            }
            if (key == "symop") {
                this.setDefaultState(1);
                if (value != null) {
                    if (key == "hoverlabel") {
                        return this.getHoverLabel((Integer)value);
                    }
                    this.symop = value;
                    this.showSymop(this.symop);
                }
                return this.symop;
            }
            if (key == "atomtype") {
                this.wasRotating = this.isRotateBond;
                this.isRotateBond = false;
                if (value != null) {
                    this.pickAtomAssignType = (String)value;
                    boolean bl = this.isPickAtomAssignCharge = this.pickAtomAssignType.equalsIgnoreCase("pl") || this.pickAtomAssignType.equalsIgnoreCase("mi");
                    if (this.isPickAtomAssignCharge) {
                        this.setHoverLabel(ATOM_MODE, ModelKit.getText(this.pickAtomAssignType.equalsIgnoreCase("mi") ? "decCharge" : "incCharge"));
                    } else if ("X".equals(this.pickAtomAssignType)) {
                        this.setHoverLabel(ATOM_MODE, ModelKit.getText("delAtom"));
                    } else if (this.pickAtomAssignType.equals("Xx")) {
                        this.setHoverLabel(ATOM_MODE, ModelKit.getText("dragBond"));
                    } else {
                        this.setHoverLabel(ATOM_MODE, "Click or click+drag to bond or for a new " + this.pickAtomAssignType);
                        this.lastElementType = this.pickAtomAssignType;
                    }
                }
                return this.pickAtomAssignType;
            }
            if (key == "bondtype") {
                if (value != null) {
                    String s = ((String)value).substring(0, 1).toLowerCase();
                    if (" 0123456pm".indexOf(s) > 0) {
                        this.pickBondAssignType = s.charAt(0);
                        this.setHoverLabel(BOND_MODE, ModelKit.getText(this.pickBondAssignType == 'm' ? "decBond" : (this.pickBondAssignType == 'p' ? "incBond" : "bondTo" + s)));
                    }
                    this.isRotateBond = false;
                }
                return "" + this.pickBondAssignType;
            }
            if (key == "bondindex") {
                if (value != null) {
                    this.setBondIndex((Integer)value, false);
                }
                return this.bondIndex < 0 ? null : Integer.valueOf(this.bondIndex);
            }
            if (key == "rotatebondindex") {
                if (value != null) {
                    this.setBondIndex((Integer)value, true);
                }
                return this.bondIndex < 0 ? null : Integer.valueOf(this.bondIndex);
            }
            if (key == "offset") {
                if (value == "none") {
                    this.viewOffset = null;
                } else if (value != null) {
                    P3 p3 = this.viewOffset = value instanceof P3 ? (P3)value : ModelKit.pointFromTriad(value.toString());
                    if (this.viewOffset != null) {
                        this.setSymViewState(8);
                    }
                }
                this.showXtalSymmetry();
                return this.viewOffset;
            }
            if (key == "screenxy") {
                if (value != null) {
                    this.screenXY = (int[])value;
                    this.vwr.acm.exitMeasurementMode("modelkit");
                }
                return this.screenXY;
            }
            if (key == "invariant") {
                int iatom = value instanceof BS ? ((BS)value).nextSetBit(0) : -1;
                Atom atom = this.vwr.ms.getAtom(iatom);
                return atom == null ? null : this.vwr.getSymmetryInfo(iatom, null, -1, null, atom, atom, 1275068418, null, 0.0f, 0, 0, null);
            }
            if (key == "distance") {
                double d;
                this.setDefaultState(2);
                double d2 = value == null ? Double.NaN : (d = value instanceof Double ? ((Number)value).doubleValue() : (double)PT.parseFloat((String)value));
                if (!Double.isNaN(d)) {
                    ModelKit.notImplemented("setProperty: distance");
                    this.centerDistance = d;
                }
                return this.centerDistance;
            }
            if (key == "point") {
                if (value != null) {
                    ModelKit.notImplemented("setProperty: point");
                    this.setDefaultState(2);
                    this.spherePoint = (P3)value;
                    this.atomIndexSphere = this.spherePoint instanceof Atom ? ((Atom)this.spherePoint).i : -1;
                }
                return this.spherePoint;
            }
            if (key == "addconstraint") {
                ModelKit.notImplemented("setProperty: addConstraint");
                return null;
            }
            if (key == "removeconstraint") {
                ModelKit.notImplemented("setProperty: removeConstraint");
                return null;
            }
            if (key == "removeallconstraints") {
                ModelKit.notImplemented("setProperty: removeAllConstraints");
                return null;
            }
            if (key == "vibration") {
                WyckoffModulation.setVibrationMode(this, value);
                return null;
            }
            System.err.println("ModelKit.setProperty? " + key + " " + value);
        }
        catch (Exception e) {
            return "?";
        }
        return null;
    }

    public MeasurementPending setBondMeasure(int bi, MeasurementPending mp) {
        if (this.branchAtomIndex < 0) {
            return null;
        }
        Bond b = this.vwr.ms.bo[bi];
        Atom a1 = b.atom1;
        Atom a2 = b.atom2;
        this.a3 = null;
        this.a0 = null;
        if (a1.getCovalentBondCount() == 1 || a2.getCovalentBondCount() == 1) {
            return null;
        }
        this.a0 = this.getOtherAtomIndex(a1, a2);
        mp.addPoint(this.a0.i, null, true);
        mp.addPoint(a1.i, null, true);
        mp.addPoint(a2.i, null, true);
        this.a3 = this.getOtherAtomIndex(a2, a1);
        mp.addPoint(this.a3.i, null, true);
        mp.mad = 50;
        mp.inFront = true;
        return mp;
    }

    public void actionRotateBond(int deltaX, int deltaY, int x, int y, boolean forceFull) {
        Atom atomFix;
        Atom atomMove;
        if (this.bondIndex < 0) {
            return;
        }
        BS bsBranch = this.bsRotateBranch;
        ModelSet ms = this.vwr.ms;
        Bond b = ms.bo[this.bondIndex];
        if (forceFull) {
            bsBranch = null;
            this.branchAtomIndex = -1;
        }
        if (bsBranch == null) {
            atomMove = this.branchAtomIndex == b.atom1.i ? b.atom1 : b.atom2;
            atomFix = atomMove == b.atom1 ? b.atom2 : b.atom1;
            this.vwr.undoMoveActionClear(atomFix.i, 2, true);
            if (this.branchAtomIndex >= 0) {
                bsBranch = this.vwr.getBranchBitSet(atomMove.i, atomFix.i, true);
            }
            if (bsBranch != null) {
                int n = 0;
                int i = atomFix.bonds.length;
                while (--i >= 0) {
                    if (!bsBranch.get(atomFix.getBondedAtomIndex(i)) || ++n != 2) continue;
                    bsBranch = null;
                    break;
                }
            }
            if (bsBranch == null) {
                bsBranch = ms.getMoleculeBitSetForAtom(atomFix.i);
                forceFull = true;
            }
            this.bsRotateBranch = bsBranch;
            this.bondAtomIndex1 = atomFix.i;
            this.bondAtomIndex2 = atomMove.i;
        } else {
            atomFix = ms.at[this.bondAtomIndex1];
            atomMove = ms.at[this.bondAtomIndex2];
        }
        if (forceFull) {
            this.bsRotateBranch = null;
        }
        V3 v1 = V3.new3(atomMove.sX - atomFix.sX, atomMove.sY - atomFix.sY, 0.0f);
        v1.scale(1.0f / v1.length());
        V3 v2 = V3.new3(deltaX, deltaY, 0.0f);
        v1.cross(v1, v2);
        float f = v1.z > 0.0f ? 1 : -1;
        float degrees = f * (float)((int)v2.length() / 2 + 1);
        if (!forceFull && this.a0 != null) {
            float ang0 = Measure.computeTorsion(this.a0, b.atom1, b.atom2, this.a3, true);
            float ang1 = Math.round(ang0 + degrees);
            degrees = ang1 - ang0;
        }
        BS bs = BSUtil.copy(bsBranch);
        bs.andNot(this.vwr.slm.getMotionFixedAtoms());
        this.vwr.rotateAboutPointsInternal(null, atomFix, atomMove, 0.0f, degrees, false, bs, null, null, null, null);
    }

    public boolean handleAssignNew(MouseState pressed, MouseState dragged, MeasurementPending mp, int dragAtomIndex, int key) {
        String atomType;
        boolean inRange = pressed.inRange(10, dragged.x, dragged.y);
        if (inRange) {
            dragged.x = pressed.x;
            dragged.y = pressed.y;
        }
        if (mp != null && this.handleDragAtom(pressed, dragged, mp.countPlusIndices)) {
            return true;
        }
        String string = atomType = key < 0 ? this.pickAtomAssignType : ModelKit.keyToElement(key);
        if (atomType == null) {
            return false;
        }
        boolean isCharge = this.isPickAtomAssignCharge;
        if (mp != null && mp.count == 2) {
            this.vwr.undoMoveActionClear(-1, 4146, true);
            String atoms = mp.getMeasurementScript(" ", false);
            if (((Atom)mp.getAtom(1)).isBonded((Atom)mp.getAtom(2))) {
                this.appRunScript("modelkit assign bond " + atoms + "'p'");
            } else {
                this.appRunScript("modelkit connect " + atoms);
            }
        } else {
            if (atomType.equals("Xx")) {
                atomType = this.lastElementType;
            }
            if (inRange) {
                String s = "modelkit assign atom ({" + dragAtomIndex + "}) \"" + atomType + "\" true";
                if (isCharge) {
                    s = s + ";{atomindex=" + dragAtomIndex + "}.label='%C'; ";
                    this.vwr.undoMoveActionClear(dragAtomIndex, 4, true);
                } else {
                    this.vwr.undoMoveActionClear(-1, 4146, true);
                }
                this.appRunScript(s);
            } else if (!isCharge) {
                this.vwr.undoMoveActionClear(-1, 4146, true);
                Atom a = this.vwr.ms.at[dragAtomIndex];
                if (a.getElementNumber() == 1) {
                    this.assignAtomClick(dragAtomIndex, "X", null);
                } else {
                    int x = dragged.x;
                    int y = dragged.y;
                    if (this.vwr.antialiased) {
                        x <<= 1;
                        y <<= 1;
                    }
                    P3 ptNew = P3.new3(x, y, a.sZ);
                    this.vwr.tm.unTransformPoint(ptNew, ptNew);
                    this.assignAtomClick(dragAtomIndex, atomType, ptNew);
                }
            }
        }
        return true;
    }

    private static String keyToElement(int key) {
        int ch1 = key & 0xFF;
        int ch2 = key >> 8 & 0xFF;
        String element = "" + (char)ch1 + (ch2 == 0 ? "" : ("" + (char)ch2).toLowerCase());
        int n = Elements.elementNumberFromSymbol(element, true);
        return n == 0 ? null : element;
    }

    boolean isXtalState() {
        return (this.state & 3) != 0;
    }

    void setMKState(int bits) {
        this.state = this.state & 0xFFFFFFFC | (this.hasUnitCell ? bits : 0);
    }

    int getMKState() {
        return this.state & 3;
    }

    void setSymEdit(int bits) {
        this.state = this.state & 0xFFFFFF1F | bits;
    }

    int getSymEditState() {
        return this.state & 0xE0;
    }

    void setSymViewState(int bits) {
        this.state = this.state & 0xFFFFFFE3 | bits;
    }

    int getSymViewState() {
        return this.state & 0x1C;
    }

    void setUnitCell(int bits) {
        this.state = this.state & 0xFFFFF8FF | bits;
    }

    int getUnitCellState() {
        return this.state & 0x700;
    }

    void exitBondRotation(String text) {
        this.wasRotating = this.isRotateBond;
        this.isRotateBond = false;
        if (text != null) {
            this.bondHoverLabel = text;
        }
        this.vwr.highlight(null);
    }

    void resetBondFields() {
        this.bsRotateBranch = null;
        this.bondAtomIndex2 = -1;
        this.bondAtomIndex1 = -1;
        this.branchAtomIndex = -1;
    }

    void processXtalClick(String id, String action) {
        if (this.processSymop(id, false)) {
            return;
        }
        if ((action = action.intern()).startsWith("mkmode_")) {
            if (!this.alertedNoEdit && action == "mkmode_edit") {
                this.alertedNoEdit = true;
                this.vwr.alert("ModelKit xtal edit has not been implemented");
                return;
            }
            this.processModeClick(action);
        } else if (action.startsWith("mksel_")) {
            this.processSelClick(action);
        } else if (action.startsWith("mkselop_")) {
            while (action != null) {
                action = this.processSelOpClick(action);
            }
        } else if (action.startsWith("mksymmetry_")) {
            this.processSymClick(action);
        } else if (action.startsWith("mkunitcell_")) {
            this.processUCClick(action);
        } else {
            ModelKit.notImplemented("XTAL click " + action);
        }
        this.menu.updateAllXtalMenuOptions();
    }

    boolean processSymop(String id, boolean isFocus) {
        int pt = id.indexOf(".mkop_");
        if (pt >= 0) {
            Object op = this.symop;
            this.symop = Integer.valueOf(id.substring(pt + 6));
            this.showSymop(this.symop);
            if (isFocus) {
                this.symop = op;
            }
            return true;
        }
        return false;
    }

    void setDefaultState(int mode) {
        if (!this.hasUnitCell) {
            mode = 0;
        }
        if (!this.hasUnitCell || this.isXtalState() != this.hasUnitCell) {
            this.setMKState(mode);
            switch (mode) {
                case 0: {
                    break;
                }
                case 1: {
                    if (this.getSymViewState() != 0) break;
                    this.setSymViewState(8);
                    break;
                }
            }
        }
    }

    String[] getAllOperators() {
        if (this.allOperators != null) {
            return this.allOperators;
        }
        String data = this.runScriptBuffered("show symop");
        this.allOperators = PT.split(data.trim().replace('\t', ' '), "\n");
        return this.allOperators;
    }

    boolean setHasUnitCell() {
        this.hasUnitCell = this.vwr.getOperativeSymmetry() != null;
        return this.hasUnitCell;
    }

    boolean checkNewModel() {
        boolean isNew = false;
        if (this.vwr.ms != this.lastModelSet) {
            this.lastModelSet = this.vwr.ms;
            isNew = true;
        }
        this.currentModelIndex = Math.max(this.vwr.am.cmi, 0);
        this.iatom0 = this.vwr.ms.am[this.currentModelIndex].firstAtomIndex;
        return isNew;
    }

    String getSymopText() {
        return this.symop == null || this.allOperators == null ? null : (this.symop instanceof Integer ? this.allOperators[(Integer)this.symop - 1] : this.symop.toString());
    }

    String getCenterText() {
        return this.centerAtomIndex < 0 && this.centerPoint == null ? null : (this.centerAtomIndex >= 0 ? this.vwr.getAtomInfo(this.centerAtomIndex) : this.centerPoint.toString());
    }

    void resetAtomPickType() {
        this.setProperty("atomType", this.lastElementType);
    }

    void setHoverLabel(String mode, String text) {
        if (text == null) {
            return;
        }
        if (mode == BOND_MODE) {
            this.bondHoverLabel = text;
        } else if (mode == ATOM_MODE) {
            this.atomHoverLabel = text;
        } else if (mode == XTAL_MODE) {
            this.xtalHoverLabel = this.atomHoverLabel = text;
        }
    }

    String getElementFromUser() {
        String element = this.promptUser(GT.$("Element?"), "");
        return element == null || Elements.elementNumberFromSymbol(element, true) == 0 ? null : element;
    }

    void processMKPropertyItem(String name, boolean TF) {
        int pt = (name = name.substring(2)).indexOf("_");
        if (pt > 0) {
            this.setProperty(name.substring(0, pt), name.substring(pt + 1));
        } else {
            this.setProperty(name, TF);
        }
    }

    private int assignAtom(int atomIndex, String type, boolean autoBond, boolean addHsAndBond, boolean isClick, BS bsAtoms) {
        boolean wasH;
        if (isClick) {
            if (this.vwr.isModelkitPickingRotateBond()) {
                this.bondAtomIndex1 = atomIndex;
                return -1;
            }
            if (this.processAtomClick(atomIndex) || !this.clickToSetElement && this.vwr.ms.getAtom(atomIndex).getElementNumber() != 1) {
                return -1;
            }
        }
        if (bsAtoms != null) {
            int n = -1;
            int i = bsAtoms.nextSetBit(0);
            while (i >= 0) {
                n = this.assignAtom(i, type, autoBond, addHsAndBond, isClick, null);
                i = bsAtoms.nextSetBit(i + 1);
            }
            return n;
        }
        Atom atom = this.vwr.ms.at[atomIndex];
        if (atom == null) {
            return -1;
        }
        this.vwr.ms.clearDB(atomIndex);
        if (type == null) {
            type = "C";
        }
        BS bs = new BS();
        boolean bl = wasH = atom.getElementNumber() == 1;
        int atomicNumber = "PPlMiX".indexOf(type) > 0 ? -1 : (type.equals("Xx") ? 0 : (PT.isUpperCase(type.charAt(0)) ? Elements.elementNumberFromSymbol(type, true) : -1));
        boolean isDelete = false;
        if (atomicNumber >= 0) {
            boolean doTaint = atomicNumber > 1 || !addHsAndBond;
            this.vwr.ms.setElement(atom, atomicNumber, doTaint);
            this.vwr.shm.setShapeSizeBs(0, 0, this.vwr.rd, BSUtil.newAndSetBit(atomIndex));
            this.vwr.ms.setAtomName(atomIndex, type + atom.getAtomNumber(), doTaint);
            if (this.vwr.getBoolean(603983903)) {
                this.vwr.ms.am[atom.mi].isModelKit = true;
            }
            if (!this.vwr.ms.am[atom.mi].isModelKit || atomicNumber > 1) {
                this.vwr.ms.taintAtom(atomIndex, 0);
            }
        } else if (type.toLowerCase().equals("pl")) {
            atom.setFormalCharge(atom.getFormalCharge() + 1);
        } else if (type.toLowerCase().equals("mi")) {
            atom.setFormalCharge(atom.getFormalCharge() - 1);
        } else if (type.equals("X")) {
            isDelete = true;
        } else if (!type.equals(".") || !this.addXtalHydrogens) {
            return -1;
        }
        if (!addHsAndBond && !isDelete) {
            return atomicNumber;
        }
        if (!wasH) {
            this.vwr.ms.removeUnnecessaryBonds(atom, isDelete);
        }
        float dx = 0.0f;
        if (atom.getCovalentBondCount() == 1) {
            dx = atomicNumber == 1 ? 1.0f : 1.5f;
        }
        if (dx != 0.0f) {
            V3 v = V3.newVsub(atom, this.vwr.ms.at[atom.getBondedAtomIndex(0)]);
            float d = v.length();
            v.normalize();
            v.scale(dx - d);
            this.vwr.ms.setAtomCoordRelative(atomIndex, v.x, v.y, v.z);
        }
        BS bsA = BSUtil.newAndSetBit(atomIndex);
        if (isDelete) {
            this.vwr.deleteAtoms(bsA, false);
        }
        if (atomicNumber != 1 && autoBond) {
            this.vwr.ms.validateBspf(false);
            bs = this.vwr.ms.getAtomsWithinRadius(1.0f, bsA, false, null, null);
            bs.andNot(bsA);
            if (bs.nextSetBit(0) >= 0) {
                this.vwr.deleteAtoms(bs, false);
            }
            bs = this.vwr.getModelUndeletedAtomsBitSet(atom.mi);
            bs.andNot(this.vwr.ms.getAtomBitsMDa(1612709900, null, new BS()));
            this.vwr.ms.makeConnections2(0.1f, 1.8f, 1, 0x40000050, bsA, bs, null, false, false, 0.0f, null);
        }
        if (this.addXtalHydrogens) {
            this.vwr.addHydrogens(bsA, 1);
        }
        return atomicNumber;
    }

    public String cmdAssignSpaceGroup(BS bs, String name, int mi) {
        boolean isITA = name.startsWith("ITA/");
        if (isITA) {
            if ((name = name.substring(4)).length() == 0) {
                name = this.vwr.getOperativeSymmetry().getSpaceGroupName();
            }
            if (name.startsWith("HM:")) {
                name = name.substring(3);
            }
        } else if (name.indexOf(46) > 0 && !Double.isNaN(PT.parseFloat(name))) {
            isITA = true;
        }
        boolean isP1 = name.equalsIgnoreCase("P1") || name.equals("1");
        boolean isDefined = name.length() > 0;
        this.clearAtomConstraints();
        try {
            BS basis;
            String ita;
            T3[] oabc;
            P3 supercell;
            Map sgInfo;
            T3 m;
            BS bsCell;
            if (bs != null && bs.isEmpty()) {
                return "";
            }
            BS bsAtoms = mi < 0 ? this.vwr.getThisModelAtoms() : this.vwr.getModelUndeletedAtomsBitSet(mi);
            BS bS = bsCell = isP1 ? bsAtoms : SV.getBitSet(this.vwr.evaluateExpressionAsVariable("{within(unitcell)}"), true);
            if (bs == null) {
                bs = bsAtoms;
            }
            if (bs != null) {
                bsAtoms.and(bs);
                if (!isP1) {
                    bsAtoms.and(bsCell);
                }
            }
            boolean noAtoms = bsAtoms.isEmpty();
            if (mi < 0) {
                mi = noAtoms && this.vwr.am.cmi < 0 ? 0 : (noAtoms ? this.vwr.am.cmi : this.vwr.ms.at[bsAtoms.nextSetBit(0)].getModelIndex());
            }
            this.vwr.ms.getModelAuxiliaryInfo(mi).remove("spaceGroupInfo");
            SymmetryInterface sym = this.vwr.getOperativeSymmetry();
            if (sym == null) {
                sym = this.vwr.getSymTemp().setUnitCell(new float[]{10.0f, 10.0f, 10.0f, 90.0f, 90.0f, 90.0f}, false, Float.NaN);
            }
            if ((m = sym.getUnitCellMultiplier()) != null && m.z == 1.0f) {
                m.z = 0.0f;
            }
            Object sg = null;
            Map map = noAtoms && !isDefined ? null : (sgInfo = (Map)this.vwr.findSpaceGroup(isDefined ? null : bsAtoms, isDefined ? (isITA ? "ITA/" + name : name) : null, sym.getUnitCellParams(), false, true));
            if (sgInfo == null) {
                if (isITA) {
                    return "No International Tables setting found!";
                }
                name = "P1";
                supercell = P3.new3(1.0f, 1.0f, 1.0f);
                oabc = sym.getUnitCellVectors();
                ita = "1";
                basis = null;
            } else {
                supercell = (P3)sgInfo.get("supercell");
                oabc = (P3[])sgInfo.get("unitcell");
                name = (String)sgInfo.get("name");
                ita = (String)sgInfo.get("itaFull");
                basis = (BS)sgInfo.get("basis");
                sg = sgInfo.remove("sg");
            }
            sym.getUnitCell(oabc, false, null);
            sym.setSpaceGroupTo(sg == null ? ita : sg);
            sym.setSpaceGroupName(name);
            if (basis == null) {
                basis = sym.removeDuplicates(this.vwr.ms, bsAtoms, true);
            }
            this.vwr.ms.setSpaceGroup(mi, sym, basis);
            P4 pt = SimpleUnitCell.ptToIJK(supercell, 1);
            ModelSet.setUnitCellOffset(sym, pt, 0);
            if (noAtoms) {
                this.appRunScript("unitcell on; center unitcell;axes unitcell; axes on;set perspectivedepth false;moveto 0 axis c1;draw delete;show spacegroup");
            }
            return name + " basis=" + basis;
        }
        catch (Exception e) {
            if (!Viewer.isJS) {
                e.printStackTrace();
            }
            return e.getMessage();
        }
    }

    public int cmdAssignDeleteAtoms(BS bs) {
        this.clearAtomConstraints();
        bs.and(this.vwr.getThisModelAtoms());
        bs = this.vwr.ms.getSymmetryEquivAtoms(bs, null, null);
        if (!bs.isEmpty()) {
            this.vwr.deleteAtoms(bs, false);
        }
        return bs.cardinality();
    }

    private void setBondIndex(int index, boolean isRotate) {
        boolean haveBond;
        if (!isRotate && this.vwr.isModelkitPickingRotateBond()) {
            this.setProperty("rotateBondIndex", index);
            return;
        }
        boolean bl = haveBond = this.bondIndex >= 0;
        if (!haveBond && index < 0) {
            return;
        }
        if (index < 0) {
            this.resetBondFields();
            return;
        }
        this.bsRotateBranch = null;
        this.branchAtomIndex = -1;
        this.bondIndex = index;
        this.isRotateBond = isRotate;
        this.bondAtomIndex1 = this.vwr.ms.bo[index].getAtomIndex1();
        this.bondAtomIndex2 = this.vwr.ms.bo[index].getAtomIndex2();
        this.menu.setActiveMenu(BOND_MODE);
    }

    private boolean handleDragAtom(MouseState pressed, MouseState dragged, int[] countPlusIndices) {
        switch (this.getMKState()) {
            case 0: {
                return false;
            }
            case 2: {
                if (countPlusIndices[0] > 2) {
                    return true;
                }
                ModelKit.notImplemented("drag atom for XTAL edit");
                break;
            }
            case 1: {
                if (this.getSymViewState() == 0) {
                    this.setSymViewState(8);
                }
                switch (countPlusIndices[0]) {
                    case 1: {
                        this.centerAtomIndex = countPlusIndices[1];
                        this.secondAtomIndex = -1;
                        break;
                    }
                    case 2: {
                        this.centerAtomIndex = countPlusIndices[1];
                        this.secondAtomIndex = countPlusIndices[2];
                    }
                }
                this.showXtalSymmetry();
                return true;
            }
        }
        return true;
    }

    private void showSymop(Object symop) {
        this.secondAtomIndex = -1;
        this.symop = symop;
        this.showXtalSymmetry();
    }

    private void showXtalSymmetry() {
        String script = null;
        switch (this.getSymViewState()) {
            case 0: {
                script = "draw * delete";
                break;
            }
            default: {
                P3 offset = null;
                if (this.secondAtomIndex >= 0) {
                    script = "draw ID sym symop " + (this.centerAtomIndex < 0 ? this.centerPoint : " {atomindex=" + this.centerAtomIndex + "}") + " {atomindex=" + this.secondAtomIndex + "}";
                } else {
                    offset = this.viewOffset;
                    if (this.symop == null) {
                        this.symop = 1;
                    }
                    int iatom = this.centerAtomIndex >= 0 ? this.centerAtomIndex : (this.centerPoint != null ? -1 : this.iatom0);
                    script = "draw ID sym symop " + (this.symop == null ? "1" : (this.symop instanceof String ? "'" + this.symop + "'" : PT.toJSON(null, this.symop))) + (iatom < 0 ? this.centerPoint : " {atomindex=" + iatom + "}") + (offset == null ? "" : " offset " + offset);
                }
                this.drawData = this.runScriptBuffered(script);
                this.drawScript = script;
                this.drawData = this.showSymopInfo ? this.drawData.substring(0, this.drawData.indexOf("\n") + 1) : "";
                this.appRunScript(";refresh;set echo top right;echo " + this.drawData.replace('\t', ' '));
            }
        }
    }

    private Object getinfo() {
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        this.addInfo(info, "addHydrogens", this.addXtalHydrogens);
        this.addInfo(info, "autobond", this.autoBond);
        this.addInfo(info, "clickToSetElement", this.clickToSetElement);
        this.addInfo(info, "hidden", this.menu.hidden);
        this.addInfo(info, "showSymopInfo", this.showSymopInfo);
        this.addInfo(info, "centerPoint", this.centerPoint);
        this.addInfo(info, "centerAtomIndex", this.centerAtomIndex);
        this.addInfo(info, "secondAtomIndex", this.secondAtomIndex);
        this.addInfo(info, "symop", this.symop);
        this.addInfo(info, "offset", this.viewOffset);
        this.addInfo(info, "drawData", this.drawData);
        this.addInfo(info, "drawScript", this.drawScript);
        this.addInfo(info, "isMolecular", this.getMKState() == 0);
        return info;
    }

    private void addInfo(Map<String, Object> info, String key, Object value) {
        if (value != null) {
            info.put(key, value);
        }
    }

    private boolean processAtomClick(int atomIndex) {
        switch (this.getMKState()) {
            case 0: {
                return this.vwr.isModelkitPickingRotateBond();
            }
            case 1: {
                this.centerAtomIndex = atomIndex;
                if (this.getSymViewState() == 0) {
                    this.setSymViewState(8);
                }
                this.showXtalSymmetry();
                return true;
            }
            case 2: {
                if (atomIndex == this.centerAtomIndex) {
                    return true;
                }
                ModelKit.notImplemented("edit click");
                return false;
            }
        }
        ModelKit.notImplemented("atom click unknown XTAL state");
        return false;
    }

    private void processModeClick(String action) {
        this.processMKPropertyItem(action, false);
    }

    private void processSelClick(String action) {
        if (action == "mksel_atom") {
            this.centerPoint = null;
            this.centerAtomIndex = -1;
            this.secondAtomIndex = -1;
        } else if (action == "mksel_position") {
            String pos = this.promptUser("Enter three fractional coordinates", this.lastCenter);
            if (pos == null) {
                return;
            }
            this.lastCenter = pos;
            P3 p = ModelKit.pointFromTriad(pos);
            if (p == null) {
                this.processSelClick(action);
                return;
            }
            this.centerAtomIndex = -2147483647;
            this.centerPoint = p;
            this.showXtalSymmetry();
        }
    }

    private String processSelOpClick(String action) {
        this.secondAtomIndex = -1;
        if (action == "mkselop_addoffset") {
            String pos = this.promptUser("Enter i j k for an offset for viewing the operator - leave blank to clear", this.lastOffset);
            if (pos == null) {
                return null;
            }
            this.lastOffset = pos;
            if (pos.length() == 0 || pos == "none") {
                this.setProperty("offset", "none");
                return null;
            }
            P3 p = ModelKit.pointFromTriad(pos);
            if (p == null) {
                return action;
            }
            this.setProperty("offset", p);
        } else if (action == "mkselop_atom2") {
            ModelKit.notImplemented(action);
        }
        return null;
    }

    private void processSymClick(String action) {
        if (action == "mksymmetry_none") {
            this.setSymEdit(0);
        } else {
            this.processMKPropertyItem(action, false);
        }
    }

    private void processUCClick(String action) {
        this.processMKPropertyItem(action, false);
        this.showXtalSymmetry();
    }

    private String getHoverLabel(int atomIndex) {
        int state = this.getMKState();
        String msg = null;
        block0 : switch (state) {
            case 1: {
                if (this.symop == null) {
                    this.symop = 1;
                }
                msg = "view symop " + this.symop + " for " + this.vwr.getAtomInfo(atomIndex);
                break;
            }
            case 2: {
                msg = "start editing for " + this.vwr.getAtomInfo(atomIndex);
                break;
            }
            case 0: {
                Atom[] atoms = this.vwr.ms.at;
                if (this.isRotateBond) {
                    this.setBranchAtom(atomIndex, false);
                    String string = msg = this.branchAtomIndex >= 0 ? "rotate branch " + atoms[atomIndex].getAtomName() : "rotate bond for " + this.getBondLabel(atoms);
                }
                if (this.bondIndex < 0) {
                    if (this.atomHoverLabel.length() <= 2) {
                        msg = this.atomHoverLabel = "Click to change to " + this.atomHoverLabel + " or drag to add " + this.atomHoverLabel;
                        break;
                    }
                    msg = atoms[atomIndex].getAtomName() + ": " + this.atomHoverLabel;
                    this.vwr.highlight(BSUtil.newAndSetBit(atomIndex));
                    break;
                }
                if (msg != null) break;
                switch (this.isRotateBond ? this.bsHighlight.cardinality() : (atomIndex >= 0 ? 1 : -1)) {
                    case 0: {
                        this.vwr.highlight(BSUtil.newAndSetBit(atomIndex));
                    }
                    case 1: 
                    case 2: {
                        Atom a = this.vwr.ms.at[atomIndex];
                        if (!this.isRotateBond) {
                            this.menu.setActiveMenu(ATOM_MODE);
                            if (this.vwr.acm.getAtomPickingMode() == 1) {
                                return null;
                            }
                        }
                        if (this.atomHoverLabel.indexOf("charge") >= 0) {
                            int ch = a.getFormalCharge();
                            msg = this.atomHoverLabel + " to " + ((ch += this.atomHoverLabel.indexOf("increase") >= 0 ? 1 : -1) > 0 ? "+" : "") + ch;
                        } else {
                            msg = this.atomHoverLabel;
                        }
                        msg = atoms[atomIndex].getAtomName() + ": " + msg;
                        break block0;
                    }
                    case -1: {
                        msg = (this.bondHoverLabel.length() == 0 ? "" : this.bondHoverLabel + " for ") + this.getBondLabel(atoms);
                    }
                }
            }
        }
        return msg;
    }

    private void setBranchAtom(int atomIndex, boolean isClick) {
        boolean isBondedAtom;
        boolean bl = isBondedAtom = atomIndex == this.bondAtomIndex1 || atomIndex == this.bondAtomIndex2;
        if (isBondedAtom) {
            this.branchAtomIndex = atomIndex;
            this.bsRotateBranch = null;
        } else {
            this.bsRotateBranch = null;
            this.branchAtomIndex = -1;
        }
    }

    private String getBondLabel(Atom[] atoms) {
        return atoms[Math.min(this.bondAtomIndex1, this.bondAtomIndex2)].getAtomName() + "-" + atoms[Math.max(this.bondAtomIndex1, this.bondAtomIndex2)].getAtomName();
    }

    private Atom getOtherAtomIndex(Atom a1, Atom a2) {
        Bond[] b = a1.bonds;
        Atom ret = null;
        int zmin = Integer.MAX_VALUE;
        int i = -1;
        while (++i < b.length) {
            Atom a;
            if (b[i] == null || !b[i].isCovalent() || (a = b[i].getOtherAtom(a1)) == a2 || a.sZ >= zmin) continue;
            zmin = a.sZ;
            ret = a;
        }
        return ret;
    }

    private String promptUser(String msg, String def) {
        return this.vwr.prompt(msg, def, null, false);
    }

    private void appRunScript(String script) {
        this.vwr.runScript(script);
    }

    private String runScriptBuffered(String script) {
        SB sb = new SB();
        try {
            ((ScriptEval)this.vwr.eval).runBufferedSafely(script, sb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    private static boolean isTrue(Object value) {
        return Boolean.valueOf(value.toString()) == Boolean.TRUE;
    }

    private static P3 pointFromTriad(String pos) {
        float[] a = PT.parseFloatArray(PT.replaceAllCharacters(pos, "{,}", " "));
        return a.length == 3 && !Float.isNaN(a[2]) ? P3.new3(a[0], a[1], a[2]) : null;
    }

    private static void notImplemented(String action) {
        System.err.println("ModelKit.notImplemented(" + action + ")");
    }

    public void cmdAssignAtom(int atomIndex, P3 pt, String type, String cmd, boolean isClick) {
        BS bs = atomIndex < 0 ? null : BSUtil.newAndSetBit(atomIndex);
        this.assignAtoms(pt, pt != null, -1, type, cmd, isClick, bs, 0, 0, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assignAtoms(P3 pt, boolean newPoint, int atomIndex, String type, String cmd, boolean isClick, BS bs, int atomicNo, int site, SymmetryInterface uc, Lst<P3> points, String packing) {
        BS bsEquiv;
        float bd;
        boolean haveAtomByIndex;
        boolean bl = haveAtomByIndex = atomIndex >= 0;
        if (bs == null) {
            bs = new BS();
        }
        boolean isMultipleAtoms = bs.cardinality() > 1;
        int nIgnored = 0;
        int np = 0;
        if (!haveAtomByIndex) {
            atomIndex = bs.nextSetBit(0);
        }
        Atom atom = atomIndex < 0 ? null : this.vwr.ms.at[atomIndex];
        float f = bd = pt != null && atom != null ? pt.distance(atom) : -1.0f;
        if (points != null) {
            nIgnored = points.size();
            np = nIgnored++;
            uc.toFractional(pt, true);
            points.addLast(pt);
            if (!newPoint || haveAtomByIndex) {
                // empty if block
            }
            uc.getEquivPointList(points, nIgnored, packing + (newPoint && atomIndex < 0 ? "newpt" : ""));
        }
        BS bS = bsEquiv = atom == null ? null : this.vwr.ms.getSymmetryEquivAtoms(bs, uc, null);
        BS bs0 = bsEquiv == null ? null : (uc == null ? BSUtil.newAndSetBit(atomIndex) : BSUtil.copy(bsEquiv));
        int mi = atom == null ? this.vwr.am.cmi : atom.mi;
        int ac = this.vwr.ms.ac;
        int state = this.getMKState();
        boolean isDelete = type.equals("X");
        boolean isXtal = this.vwr.getOperativeSymmetry() != null;
        try {
            P3[] pts;
            if (isDelete) {
                if (isClick) {
                    this.setProperty("rotateBondIndex", -1);
                }
                this.setConstraint(null, atomIndex, GET_DELETE);
            }
            if (pt == null && points == null) {
                if (atom == null) {
                    return;
                }
                this.vwr.sm.setStatusStructureModified(atomIndex, mi, 1, cmd, 1, bsEquiv);
                this.assignAtom(atomIndex, type, this.autoBond, !isXtal, true, bsEquiv);
                if (!PT.isOneOf(type, ";Mi;Pl;X;")) {
                    this.vwr.ms.setAtomNamesAndNumbers(atomIndex, -ac, null, true);
                }
                this.vwr.sm.setStatusStructureModified(atomIndex, mi, -1, "OK", 1, bsEquiv);
                this.vwr.refresh(3, "assignAtom");
                return;
            }
            this.setMKState(0);
            if (points == null) {
                pts = new P3[]{pt};
            } else {
                pts = new P3[Math.max(0, points.size() - np)];
                int i = pts.length;
                while (--i >= 0) {
                    pts[i] = (P3)points.get(np + i);
                }
            }
            Lst<Atom> vConnections = new Lst<Atom>();
            boolean isConnected = false;
            if (site == 0) {
                if (atom != null) {
                    if (!isMultipleAtoms) {
                        vConnections.addLast(atom);
                        isConnected = true;
                    } else if (uc != null) {
                        P3 p = P3.newP(atom);
                        uc.toFractional(p, true);
                        bs.or(bsEquiv);
                        Lst<P3> list = uc.getEquivPoints(null, p, packing);
                        int n = list.size();
                        for (int j = 0; j < n; ++j) {
                            int i = bs.nextSetBit(0);
                            while (i >= 0) {
                                if (this.vwr.ms.at[i].distanceSquared((T3)list.get(j)) < 0.001f) {
                                    vConnections.addLast(this.vwr.ms.at[i]);
                                    bs.clear(i);
                                }
                                i = bs.nextSetBit(i + 1);
                            }
                        }
                    }
                    boolean bl2 = isConnected = vConnections.size() == pts.length;
                    if (isConnected) {
                        float d = Float.MAX_VALUE;
                        int i = pts.length;
                        while (--i >= 0) {
                            float d1 = ((Atom)vConnections.get(i)).distance(pts[i]);
                            if (d == Float.MAX_VALUE) {
                                d1 = d;
                                continue;
                            }
                            if (!(Math.abs(d1 - d) > 0.001f)) continue;
                            isConnected = false;
                            break;
                        }
                    }
                    if (!isConnected) {
                        vConnections.clear();
                    }
                    this.vwr.sm.setStatusStructureModified(atomIndex, mi, 3, cmd, 1, null);
                }
                if (pt != null || points != null) {
                    BS bsM = this.vwr.getThisModelAtoms();
                    int i = bsM.nextSetBit(0);
                    while (i >= 0) {
                        int as = this.vwr.ms.at[i].getAtomSite();
                        if (as > site) {
                            site = as;
                        }
                        i = bsM.nextSetBit(i + 1);
                    }
                    ++site;
                }
            }
            int pickingMode = this.vwr.acm.getAtomPickingMode();
            boolean wasHidden = this.menu.hidden;
            boolean isMK = this.vwr.getBoolean(603983903);
            if (!isMK) {
                this.vwr.setBooleanProperty("modelkitmode", true);
                this.menu.hidden = true;
                this.menu.allowPopup = false;
            }
            Hashtable<String, Object> htParams = new Hashtable<String, Object>();
            if (site > 0) {
                htParams.put("fixedSite", site);
            }
            bs = this.vwr.addHydrogensInline(bs, vConnections, pts, htParams);
            if (bd > 0.0f && !isConnected && vConnections.isEmpty()) {
                this.connectAtoms(bd, 1, bs0, bs);
            }
            if (!isMK) {
                this.vwr.setBooleanProperty("modelkitmode", false);
                this.menu.hidden = wasHidden;
                this.menu.allowPopup = true;
                this.vwr.acm.setPickingMode(pickingMode);
                this.menu.hidePopup();
            }
            int atomIndexNew = bs.nextSetBit(0);
            if (points == null) {
                this.assignAtom(atomIndexNew, type, false, atomIndex >= 0 && !isXtal, true, null);
                if (atomIndex >= 0) {
                    this.assignAtom(atomIndex, ".", false, !isXtal && !"H".equals(type), isClick, null);
                }
                this.vwr.ms.setAtomNamesAndNumbers(atomIndexNew, -ac, null, true);
                this.vwr.sm.setStatusStructureModified(atomIndexNew, mi, -3, "OK", 1, bs);
                return;
            }
            if (atomIndexNew >= 0) {
                int i = atomIndexNew;
                while (i >= 0) {
                    this.assignAtom(i, type, false, false, true, null);
                    this.vwr.ms.setSite(this.vwr.ms.at[i], -1, false);
                    this.vwr.ms.setSite(this.vwr.ms.at[i], site, true);
                    i = bs.nextSetBit(i + 1);
                }
                this.vwr.ms.updateBasisFromSite(mi);
            }
            int firstAtom = this.vwr.ms.am[mi].firstAtomIndex;
            if (atomicNo >= 0) {
                atomicNo = Elements.elementNumberFromSymbol(type, true);
                BS bsM = this.vwr.getThisModelAtoms();
                int i = bsM.nextSetBit(0);
                while (i >= 0) {
                    if (this.vwr.ms.at[i].getAtomSite() == site) {
                        this.vwr.ms.setElement(this.vwr.ms.at[i], atomicNo, true);
                    }
                    i = bsM.nextSetBit(i + 1);
                }
            }
            this.vwr.ms.setAtomNamesAndNumbers(firstAtom, -ac, null, true);
            this.vwr.sm.setStatusStructureModified(-1, mi, -3, "OK", 1, bs);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this.setMKState(state);
        }
    }

    private void connectAtoms(float bd, int bondOrder, BS bs1, BS bs2) {
        this.vwr.makeConnections(bd - 0.01f, bd + 0.01f, bondOrder, 1073742026, bs1, bs2, new BS(), false, false, 0.0f);
    }

    public void cmdAssignBond(int bondIndex, char type, String cmd) {
        this.assignBondAndType(bondIndex, this.getBondOrder(type, this.vwr.ms.bo[bondIndex]), type, cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignBondAndType(int bondIndex, int bondOrder, char type, String cmd) {
        int modelIndex = -1;
        int state = this.getMKState();
        try {
            this.setMKState(0);
            Atom a1 = this.vwr.ms.bo[bondIndex].atom1;
            modelIndex = a1.mi;
            int ac = this.vwr.ms.ac;
            BS bsAtoms = BSUtil.newAndSetBit(a1.i);
            bsAtoms.set(this.vwr.ms.bo[bondIndex].atom2.i);
            this.vwr.sm.setStatusStructureModified(bondIndex, modelIndex, 6, cmd, 1, bsAtoms);
            this.assignBond(bondIndex, bondOrder, bsAtoms);
            this.vwr.ms.setAtomNamesAndNumbers(a1.i, -ac, null, true);
            this.vwr.refresh(3, "setBondOrder");
            this.vwr.sm.setStatusStructureModified(bondIndex, modelIndex, -6, "" + type, 1, bsAtoms);
        }
        catch (Exception ex) {
            Logger.error("assignBond failed");
            this.vwr.sm.setStatusStructureModified(bondIndex, modelIndex, -6, "ERROR " + ex, 1, null);
        }
        finally {
            this.setMKState(state);
        }
    }

    private boolean assignBond(int bondIndex, int bondOrder, BS bsAtoms) {
        Bond bond = this.vwr.ms.bo[bondIndex];
        this.vwr.ms.clearDB(bond.atom1.i);
        if (bondOrder < 0) {
            return false;
        }
        try {
            if (bondOrder == 0) {
                this.vwr.deleteBonds(BSUtil.newAndSetBit(bond.index));
            } else {
                bond.setOrder(bondOrder | 0x20000);
                if (bond.atom1.getElementNumber() != 1 && bond.atom2.getElementNumber() != 1) {
                    this.vwr.ms.removeUnnecessaryBonds(bond.atom1, false);
                    this.vwr.ms.removeUnnecessaryBonds(bond.atom2, false);
                }
            }
        }
        catch (Exception e) {
            Logger.error("Exception in seBondOrder: " + e.toString());
        }
        if (bondOrder != 0 && this.addXtalHydrogens) {
            this.vwr.addHydrogens(bsAtoms, 1);
        }
        return true;
    }

    private int getBondOrder(char type, Bond bond) {
        if (type == '-') {
            type = this.pickBondAssignType;
        }
        int bondOrder = type - 48;
        switch (type) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': {
                break;
            }
            case 'm': 
            case 'p': {
                bondOrder = Edge.getBondOrderNumberFromOrder(bond.getCovalentOrder()).charAt(0) - 48 + (type == 'p' ? 1 : -1);
                if (bondOrder > 3) {
                    bondOrder = 1;
                    break;
                }
                if (bondOrder >= 0) break;
                bondOrder = 3;
                break;
            }
            default: {
                return -1;
            }
        }
        return bondOrder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cmdAssignConnect(int index, int index2, char type, String cmd) {
        Atom b;
        Atom a;
        Atom[] atoms = this.vwr.ms.at;
        if (index < 0 || index2 < 0 || index >= atoms.length || index2 >= atoms.length || (a = atoms[index]) == null || (b = atoms[index2]) == null) {
            return;
        }
        int state = this.getMKState();
        try {
            Bond bond = null;
            if (type != '1') {
                BS bs = new BS();
                bs.set(index);
                bs.set(index2);
                bs = this.vwr.getBondsForSelectedAtoms(bs);
                bond = this.vwr.ms.bo[bs.nextSetBit(0)];
            }
            int bondOrder = this.getBondOrder(type, bond);
            BS bs1 = this.vwr.ms.getSymmetryEquivAtoms(BSUtil.newAndSetBit(index), null, null);
            BS bs2 = this.vwr.ms.getSymmetryEquivAtoms(BSUtil.newAndSetBit(index2), null, null);
            this.connectAtoms(a.distance(b), bondOrder, bs1, bs2);
        }
        catch (Exception exception) {
        }
        finally {
            this.setMKState(state);
        }
    }

    public void assignAtomClick(int atomIndex, String element, P3 ptNew) {
        this.appRunScript("modelkit " + (this.vwr.getOperativeSymmetry() == null ? "assign atom" : "ADD") + " ({" + atomIndex + "}) \"" + element + "\" " + (ptNew == null ? "" : Escape.eP(ptNew)) + " true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int cmdAssignAddAtoms(String type, P3[] pts, BS bsAtoms, String packing, String cmd, boolean isClick) {
        try {
            int atomIndex;
            int ipt;
            String wyckoff;
            SymmetryInterface sym = this.vwr.getOperativeSymmetry();
            if (type.startsWith("_")) {
                type = type.substring(1);
            }
            String string = wyckoff = (ipt = type.indexOf(":")) > 0 && ipt == type.length() - 2 ? type.substring(ipt + 1) : null;
            if (wyckoff != null) {
                type = type.substring(0, ipt);
                if (sym != null) {
                    Object o = sym.getWyckoffPosition(this.vwr, null, wyckoff);
                    if (!(o instanceof P3)) {
                        int n = 0;
                        return n;
                    }
                    pts = new P3[]{(P3)o};
                }
            }
            this.vwr.pushHoldRepaintWhy("modelkit");
            boolean isPoint = bsAtoms == null;
            int n = atomIndex = isPoint ? -1 : bsAtoms.nextSetBit(0);
            if (!isPoint && atomIndex < 0) {
                int n2 = 0;
                return n2;
            }
            if (sym == null) {
                if (isPoint) {
                    int i;
                    for (i = 0; i < pts.length; ++i) {
                        this.assignAtoms(pts[i], true, -1, type, cmd, false, null, 1, -1, null, null, "");
                    }
                    i = pts.length;
                    return i;
                }
                this.assignAtoms(pts[0], true, atomIndex, type, cmd, false, null, 1, -1, null, null, "");
                int i = 1;
                return i;
            }
            BS bsM = this.vwr.getThisModelAtoms();
            int n3 = bsM.cardinality();
            if (n3 == 0) {
                packing = "zapped;" + packing;
            }
            String stype = "" + type;
            Lst<P3> list = new Lst<P3>();
            int atomicNo = -1;
            int site = 0;
            P3 pf = null;
            if (pts != null && pts.length == 1) {
                pf = P3.newP(pts[0]);
                sym.toFractional(pf, true);
                isPoint = true;
            }
            int i = bsM.nextSetBit(0);
            while (i >= 0) {
                P3 p = P3.newP(this.vwr.ms.at[i]);
                sym.toFractional(p, true);
                if (pf != null && pf.distanceSquared(p) < 1.96E-6f) {
                    site = this.vwr.ms.at[i].getAtomSite();
                    if (type == null || pts == null) {
                        type = this.vwr.ms.at[i].getElementSymbolIso(true);
                    }
                }
                list.addLast(p);
                i = bsM.nextSetBit(i + 1);
            }
            int nIgnored = list.size();
            packing = "fromfractional;tocartesian;" + packing;
            if (type != null) {
                atomicNo = Elements.elementNumberFromSymbol(type, true);
            }
            if (isPoint) {
                BS bsEquiv = bsAtoms == null ? null : this.vwr.ms.getSymmetryEquivAtoms(bsAtoms, null, null);
                for (int i2 = 0; i2 < pts.length; ++i2) {
                    this.assignAtoms(P3.newP(pts[i2]), true, atomIndex, stype, null, false, bsEquiv, atomicNo, site, sym, list, packing);
                }
            } else {
                BS sites = new BS();
                int i3 = bsAtoms.nextSetBit(0);
                while (i3 >= 0) {
                    Atom a = this.vwr.ms.at[i3];
                    site = a.getAtomSite();
                    if (!sites.get(site)) {
                        sites.set(site);
                        stype = type == null ? a.getElementSymbolIso(true) : stype;
                        this.assignAtoms(P3.newP(a), false, -1, stype, null, false, null, atomicNo, site, sym, list, packing);
                        int j = list.size();
                        while (--j >= nIgnored) {
                            list.removeItemAt(j);
                        }
                    }
                    i3 = bsAtoms.nextSetBit(i3 + 1);
                }
            }
            if (isClick) {
                this.vwr.setPickingMode("dragAtom", 0);
            }
            int n4 = n3 = this.vwr.getThisModelAtoms().cardinality() - n3;
            return n4;
        }
        catch (Exception e) {
            e.printStackTrace();
            int n = 0;
            return n;
        }
        finally {
            this.vwr.popHoldRepaint("modelkit");
        }
    }

    public int cmdAssignMoveAtoms(BS bsSelected, BS bsFixed, BS bsModelAtoms, int iatom, P3 p, P3[] pts, boolean allowProjection) {
        SymmetryInterface sym = this.getSym(iatom);
        if (sym == null) {
            return 0;
        }
        int npts = bsSelected.cardinality();
        if (npts == 0) {
            return 0;
        }
        int n = 0;
        int i0 = bsSelected.nextSetBit(0);
        if (bsFixed == null) {
            bsFixed = this.vwr.getMotionFixedAtoms(i0);
        }
        if (bsModelAtoms == null) {
            bsModelAtoms = this.vwr.getModelUndeletedAtomsBitSet(this.vwr.ms.at[i0].mi);
        }
        if (pts != null) {
            if (npts != pts.length) {
                return 0;
            }
            BS bs = new BS();
            int ip = 0;
            int i = bsSelected.nextSetBit(0);
            while (i >= 0) {
                bs.clearAll();
                bs.set(i);
                n += this.cmdAssignMoveAtoms(bs, bsFixed, bsModelAtoms, i, pts[ip++], null, true);
                i = bsSelected.nextSetBit(i + 1);
            }
            return n;
        }
        int nAtoms = bsSelected.cardinality();
        if (bsSelected.intersects(bsFixed) || nAtoms > 1 && (this.constraint != null || sym.getSpaceGroupOperationCount() > 1)) {
            p.x = Float.NaN;
            return 0;
        }
        if (nAtoms > 1) {
            return 0;
        }
        BS bsOcc = new BS();
        boolean checkOcc = false;
        Atom a = this.vwr.ms.at[iatom];
        if (!checkOcc || this.vwr.ms.getOccupancyFloat(a.i) == 100.0f) {
            bsOcc.set(a.i);
        } else {
            this.vwr.getAtomsNearPt(1.0E-4f, a, bsOcc);
            int i = bsOcc.nextSetBit(0);
            while (i >= 0) {
                if (this.vwr.ms.getOccupancyFloat(i) == 100.0f) {
                    bsOcc.clear(i);
                }
                i = bsOcc.nextSetBit(i + 1);
            }
        }
        boolean isOccSet = bsOcc.cardinality() > 1;
        n = this.moveConstrained(iatom, bsFixed, bsModelAtoms, p, !isOccSet, allowProjection);
        if (n == 0 || Float.isNaN(p.x) || !isOccSet) {
            this.vwr.setStatusAtomMoved(false, bsOcc);
            return n;
        }
        int i = bsOcc.nextSetBit(0);
        while (i >= 0) {
            iatom = this.constraint == null ? this.getBasisAtom((int)i).i : i;
            n += this.assignMoveAtom(iatom, p, bsFixed, bsModelAtoms);
            i = bsOcc.nextSetBit(i + 1);
        }
        this.vwr.setStatusAtomMoved(true, bsOcc);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int assignMoveAtom(int iatom, P3 pt, BS bsFixed, BS bsModelAtoms) {
        if (Float.isNaN(pt.x) || iatom < 0) {
            return 0;
        }
        BS bs = BSUtil.newAndSetBit(iatom);
        if (bsModelAtoms == null) {
            bsModelAtoms = this.vwr.getThisModelAtoms();
        }
        bs.and(bsModelAtoms);
        if (bs.isEmpty()) {
            return 0;
        }
        int state = this.getMKState();
        this.setMKState(0);
        try {
            int n;
            SymmetryInterface sym = this.getSym(iatom);
            BS bseq = new BS();
            this.vwr.ms.getSymmetryEquivAtomsForAtom(iatom, null, bsModelAtoms, bseq);
            if (this.setConstraint((SymmetryInterface)sym, (int)bseq.nextSetBit((int)0), (int)ModelKit.GET_CREATE).type == 6) {
                int n2 = 0;
                return n2;
            }
            if (bsFixed != null && !bsFixed.isEmpty()) {
                bseq.andNot(bsFixed);
            }
            if ((n = bseq.cardinality()) == 0) {
                int n3 = 0;
                return n3;
            }
            Atom a = this.vwr.ms.at[iatom];
            int[] v0 = sym.getInvariantSymops(a, null);
            int[] v1 = sym.getInvariantSymops(pt, v0);
            if (v1 == null != (v0 == null) || !Arrays.equals(v0, v1)) {
                int n4 = 0;
                return n4;
            }
            P3[] points = new P3[n];
            int ia0 = bseq.nextSetBit(0);
            if (!this.fillPointsForMove(sym, bseq, ia0, a, pt, points)) {
                int n5 = 0;
                return n5;
            }
            short mi = this.vwr.ms.at[ia0].mi;
            this.vwr.sm.setStatusStructureModified(ia0, mi, 3, "dragatom", n, bseq);
            int k = 0;
            int ia = bseq.nextSetBit(0);
            while (ia >= 0) {
                P3 p = points[k++];
                this.vwr.ms.setAtomCoord(ia, p.x, p.y, p.z);
                ia = bseq.nextSetBit(ia + 1);
            }
            this.vwr.sm.setStatusStructureModified(ia0, mi, -3, "dragatom", n, bseq);
            int n6 = n;
            return n6;
        }
        catch (Exception e) {
            System.err.println("Modelkit err" + e);
            int n = 0;
            return n;
        }
        finally {
            this.setMKState(state);
        }
    }

    public SymmetryInterface getSym(int iatom) {
        short modelIndex = this.vwr.ms.at[iatom].mi;
        if (this.modelSyms == null || modelIndex >= this.modelSyms.length) {
            this.modelSyms = new SymmetryInterface[this.vwr.ms.mc];
            int imodel = this.modelSyms.length;
            while (--imodel >= 0) {
                SymmetryInterface sym = this.vwr.ms.getUnitCell(imodel);
                if (sym != null && sym.getSymmetryOperations() == null) continue;
                this.modelSyms[imodel] = sym;
            }
        }
        return iatom < 0 ? null : this.modelSyms[modelIndex];
    }

    private boolean fillPointsForMove(SymmetryInterface sg, BS bseq, int i0, P3 a, P3 pt, P3[] points) {
        float d = a.distance(pt);
        P3 fa = P3.newP(a);
        P3 fb = P3.newP(pt);
        sg.toFractional(fa, true);
        sg.toFractional(fb, true);
        int k = 0;
        int i = i0;
        while (i >= 0) {
            P3 p = P3.newP(this.vwr.ms.at[i]);
            P3 p0 = P3.newP(p);
            sg.toFractional(p, true);
            System.out.println(fa + " " + p);
            M4 m = sg.getTransform(fa, p, false);
            if (m == null) {
                return false;
            }
            P3 p2 = P3.newP(fb);
            m.rotTrans(p2);
            sg.toCartesian(p2, true);
            if (Math.abs(d - p0.distance(p2)) > 0.001f) {
                return false;
            }
            points[k++] = p2;
            i = bseq.nextSetBit(i + 1);
        }
        fa.setT(points[0]);
        sg.toFractional(fa, true);
        k = points.length;
        while (--k >= 0) {
            fb.setT(points[k]);
            sg.toFractional(fb, true);
            M4 m = sg.getTransform(fa, fb, false);
            if (m == null) {
                return false;
            }
            int i2 = points.length;
            while (--i2 > k) {
                if (!(points[i2].distance(points[k]) < 0.1f)) continue;
                return false;
            }
        }
        return true;
    }

    Atom getBasisAtom(int iatom) {
        Atom b;
        if (this.minBasisAtoms == null) {
            this.minBasisAtoms = new Atom[this.vwr.ms.ac + 10];
        }
        if (this.minBasisAtoms.length < iatom + 10) {
            Atom[] a = new Atom[this.vwr.ms.ac + 10];
            System.arraycopy(this.minBasisAtoms, 0, a, 0, this.minBasisAtoms.length);
            this.minBasisAtoms = a;
        }
        return (b = this.minBasisAtoms[iatom]) == null ? this.vwr.ms.getBasisAtom(iatom, false) : b;
    }

    public void clearAtomConstraints() {
        this.modelSyms = null;
        this.minBasisAtoms = null;
        if (this.atomConstraints != null) {
            int i = this.atomConstraints.length;
            while (--i >= 0) {
                this.atomConstraints[i] = null;
            }
        }
    }

    public boolean hasConstraint(int iatom, boolean ignoreGeneral, boolean addNew) {
        Constraint c = this.setConstraint(this.getSym(iatom), iatom, addNew ? GET_CREATE : GET);
        return c != null && (!ignoreGeneral || c.type != 7);
    }

    public int moveMinConstrained(int iatom, P3 p, BS bsAtoms) {
        return this.moveConstrained(iatom, null, bsAtoms, p, true, true);
    }

    public int moveConstrained(int iatom, BS bsFixed, BS bsModelAtoms, P3 ptNew, boolean doAssign, boolean allowProjection) {
        int n = 0;
        SymmetryInterface sym = this.getSym(iatom);
        if (sym == null) {
            return 0;
        }
        Atom a = this.vwr.ms.at[iatom];
        Constraint c = this.constraint;
        if (c == null) {
            c = this.setConstraint(sym, iatom, GET_CREATE);
            if (c.type == 6) {
                iatom = -1;
            } else {
                Atom b = this.getBasisAtom(iatom);
                if (a != b) {
                    M4 m = ModelKit.getTransform(sym, a, b);
                    if (m == null) {
                        System.err.println("ModelKit - null matrix for " + iatom + " " + a + " to " + b);
                        iatom = -1;
                    } else {
                        iatom = b.i;
                        P3 p = P3.newP(ptNew);
                        sym.toFractional(p, true);
                        m.rotTrans(p);
                        sym.toCartesian(p, true);
                        ptNew.set(p.x, p.y, p.z);
                    }
                }
                if (iatom >= 0) {
                    c.constrain(b, ptNew, allowProjection);
                }
            }
        } else {
            c.constrain(a, ptNew, allowProjection);
        }
        if (iatom >= 0 && !Float.isNaN(ptNew.x)) {
            if (!doAssign) {
                return 1;
            }
            n = this.assignMoveAtom(iatom, ptNew, bsFixed, bsModelAtoms);
        }
        ptNew.x = Float.NaN;
        return n;
    }

    static M4 getTransform(SymmetryInterface sym, Atom a, Atom b) {
        P3 fa = P3.newP(a);
        sym.toFractional(fa, true);
        P3 fb = P3.newP(b);
        sym.toFractional(fb, true);
        return sym.getTransform(fa, fb, true);
    }

    Constraint setConstraint(SymmetryInterface sym, int ia, int mode) {
        Constraint ac;
        if (ia < 0) {
            return null;
        }
        Atom a = this.getBasisAtom(ia);
        int iatom = a.i;
        Constraint constraint = ac = this.atomConstraints != null && iatom < this.atomConstraints.length ? this.atomConstraints[iatom] : null;
        if (ac != null || mode != GET_CREATE) {
            if (ac != null && mode == GET_DELETE) {
                this.atomConstraints[iatom] = null;
            }
            return ac;
        }
        if (sym == null) {
            return this.addConstraint(iatom, new Constraint(a, 0, null));
        }
        int[] ops = sym.getInvariantSymops(a, null);
        if (Logger.debugging) {
            System.out.println("MK.getConstraint atomIndex=" + iatom + " symops=" + Arrays.toString(ops));
        }
        if (ops.length == 0) {
            return this.addConstraint(iatom, new Constraint(a, 7, null));
        }
        P4 plane1 = null;
        Object[] line1 = null;
        int i = ops.length;
        while (--i >= 0) {
            Object[] line2 = null;
            Object c = sym.getSymmetryInfoAtom(this.vwr.ms, iatom, null, ops[i], null, a, null, "invariant", 1275068418, 0.0f, -1, 0, null);
            if (c instanceof String) {
                return locked;
            }
            if (c instanceof P4) {
                P4 plane = (P4)c;
                if (plane1 == null) {
                    plane1 = plane;
                    continue;
                }
                Lst<Object> line = Measure.getIntersectionPP(plane1, plane);
                if (line == null || line.size() == 0) {
                    return locked;
                }
                line2 = new Object[]{line.get(0), line.get(1)};
            } else {
                if (c instanceof P3) {
                    return locked;
                }
                line2 = (Object[])c;
            }
            if (line2 == null) continue;
            if (line1 == null) {
                line1 = line2;
            } else {
                T3 v1 = (T3)line1[1];
                if (Math.abs(v1.dot((T3)line2[1])) < 0.999f) {
                    return locked;
                }
            }
            if (plane1 == null || !(Math.abs(plane1.dot((T3)line2[1])) > 0.001f)) continue;
            return locked;
        }
        if (line1 != null) {
            line1[0] = P3.newP(a);
        }
        return this.addConstraint(iatom, line1 != null ? new Constraint(a, 4, line1) : (plane1 != null ? new Constraint(a, 5, new Object[]{plane1}) : new Constraint(a, 7, null)));
    }

    private Constraint addConstraint(int iatom, Constraint c) {
        if (c == null) {
            if (this.atomConstraints != null && this.atomConstraints.length > iatom) {
                this.atomConstraints[iatom] = null;
            }
            return null;
        }
        if (this.atomConstraints == null) {
            this.atomConstraints = new Constraint[this.vwr.ms.ac + 10];
        }
        if (this.atomConstraints.length < iatom + 10) {
            Constraint[] a = new Constraint[this.vwr.ms.ac + 10];
            System.arraycopy(this.atomConstraints, 0, a, 0, this.atomConstraints.length);
            this.atomConstraints = a;
        }
        this.atomConstraints[iatom] = c;
        return this.atomConstraints[iatom];
    }

    public void addLockedAtoms(int i0, BS bs) {
        SymmetryInterface sg = this.getSym(i0);
        if (sg == null) {
            return;
        }
        BS bsm = this.vwr.getModelUndeletedAtomsBitSet(this.vwr.ms.at[i0].mi);
        int i = bsm.nextSetBit(0);
        while (i >= 0) {
            if (this.setConstraint((SymmetryInterface)sg, (int)i, (int)ModelKit.GET_CREATE).type == 6) {
                bs.set(i);
            }
            i = bsm.nextSetBit(i + 1);
        }
    }

    public int cmdRotateAtoms(BS bsAtoms, P3[] points, float endDegrees) {
        P3 center = points[0];
        P3 p = new P3();
        int i0 = bsAtoms.nextSetBit(0);
        SymmetryInterface sg = this.getSym(i0);
        BS bsAU = new BS();
        BS bsAtoms2 = new BS();
        int i = i0;
        while (i >= 0) {
            int bai = this.getBasisAtom((int)i).i;
            if (!bsAU.get(bai)) {
                if (this.setConstraint((SymmetryInterface)sg, (int)bai, (int)ModelKit.GET_CREATE).type == 6) {
                    return 0;
                }
                bsAU.set(bai);
                bsAtoms2.set(i);
            }
            i = bsAtoms.nextSetBit(i + 1);
        }
        int nAtoms = bsAtoms.cardinality();
        P3[] apos0 = new P3[this.vwr.ms.at.length];
        int i2 = apos0.length;
        while (--i2 >= 0) {
            Atom a = this.vwr.ms.at[i2];
            if (AtomCollection.isDeleted(a)) continue;
            apos0[i2] = P3.newP(a);
        }
        M3 m = Quat.newVA(V3.newVsub(points[1], points[0]), endDegrees).getMatrix();
        V3 vt = new V3();
        P3[] apos = new P3[nAtoms];
        int ip = 0;
        int i3 = i0;
        while (i3 >= 0) {
            Atom a = this.vwr.ms.at[i3];
            int n = ip++;
            P3 p3 = P3.newP(a);
            apos[n] = p3;
            p = p3;
            vt.sub2(p, center);
            m.rotate(vt);
            p.add2(center, vt);
            this.setConstraint(sg, i3, GET_CREATE).constrain(a, p, false);
            if (Double.isNaN(p.x)) {
                return 0;
            }
            i3 = bsAtoms.nextSetBit(i3 + 1);
        }
        nAtoms = 0;
        BS bsFixed = this.vwr.getMotionFixedAtoms(i0);
        BS bsModelAtoms = this.vwr.getModelUndeletedAtomsBitSet(this.vwr.ms.at[i0].mi);
        int ip2 = 0;
        int i4 = i0;
        while (i4 >= 0) {
            if (bsAtoms2.get(i4)) {
                nAtoms += this.assignMoveAtom(i4, apos[ip2], bsFixed, bsModelAtoms);
            }
            i4 = bsAtoms2.nextSetBit(i4 + 1);
            ++ip2;
        }
        boolean ok = true;
        int ip3 = 0;
        int i5 = bsAtoms.nextSetBit(0);
        while (i5 >= 0) {
            if (!bsAtoms2.get(i5) && (double)this.vwr.ms.at[i5].distance(apos[ip3]) > 1.0E-4) {
                ok = false;
                break;
            }
            i5 = bsAtoms.nextSetBit(i5 + 1);
            ++ip3;
        }
        if (!ok) {
            i4 = apos0.length;
            while (--i4 >= 0) {
                Atom a = this.vwr.ms.at[i4];
                if (AtomCollection.isDeleted(a)) continue;
                a.setT(apos0[i4]);
            }
            return 0;
        }
        return nAtoms;
    }

    static String getText(String key) {
        switch ("invSter delAtom dragBon dragAto dragMin dragMol dragMMo incChar decChar rotBond bondTo0 bondTo1 bondTo2 bondTo3 incBond decBond".indexOf(key.substring(0, 7))) {
            case 0: {
                return GT.$("invert ring stereochemistry");
            }
            case 8: {
                return GT.$("delete atom");
            }
            case 16: {
                return GT.$("drag to bond");
            }
            case 24: {
                return GT.$("drag atom");
            }
            case 32: {
                return GT.$("drag atom (and minimize)");
            }
            case 40: {
                return GT.$("drag molecule (ALT to rotate)");
            }
            case 48: {
                return GT.$("drag and minimize molecule (docking)");
            }
            case 56: {
                return GT.$("increase charge");
            }
            case 64: {
                return GT.$("decrease charge");
            }
            case 72: {
                return GT.$("rotate bond");
            }
            case 80: {
                return GT.$("delete bond");
            }
            case 88: {
                return GT.$("single");
            }
            case 96: {
                return GT.$("double");
            }
            case 104: {
                return GT.$("triple");
            }
            case 112: {
                return GT.$("increase order");
            }
            case 120: {
                return GT.$("decrease order");
            }
        }
        return key;
    }

    public boolean wasRotating() {
        boolean b = this.wasRotating;
        this.wasRotating = false;
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cmdMinimize(JmolScriptEvaluator eval, BS bsBasis, int steps, float crit, float rangeFixed, int flags) throws Exception {
        boolean wasAppend = this.vwr.getBoolean(603979792);
        this.vwr.setBooleanProperty("appendNew", true);
        this.minBasisModel = this.vwr.am.cmi;
        this.minSelectionSaved = this.vwr.bsA();
        try {
            String cif = this.vwr.getModelExtract(bsBasis, false, false, "cif");
            Hashtable<String, Object> htParams = new Hashtable<String, Object>();
            htParams.put("eval", eval);
            htParams.put("lattice", P3.new3(444.0f, 666.0f, 1.0f));
            htParams.put("fileData", cif);
            htParams.put("loadScript", new SB());
            if (this.vwr.loadModelFromFile(null, "<temp>", null, null, true, htParams, null, null, 0, " ") != null) {
                return;
            }
            this.vwr.am.setFrame(this.minBasisModel);
            int modelIndex = this.vwr.ms.mc - 1;
            BS bsBasis2 = BSUtil.copy(this.vwr.ms.am[modelIndex].bsAsymmetricUnit);
            this.minBasis = bsBasis;
            this.minBasisFixed = this.vwr.getMotionFixedAtoms(bsBasis.nextSetBit(0));
            this.minBasisModelAtoms = this.vwr.getModelUndeletedAtomsBitSet(this.minBasisModel);
            this.minTempModelAtoms = this.vwr.getModelUndeletedAtomsBitSet(modelIndex);
            this.minTempFixed = BSUtil.copy(this.minTempModelAtoms);
            this.minTempFixed.andNot(bsBasis2);
            this.minTempFixed.or(this.vwr.getMotionFixedAtoms(bsBasis2.nextSetBit(0)));
            this.vwr.minimize(eval, steps, crit, BSUtil.copy(bsBasis2), this.minTempFixed, this.minTempModelAtoms, rangeFixed, flags & 0xFFFFFEFF);
        }
        finally {
            this.vwr.setBooleanProperty("appendNew", wasAppend);
        }
    }

    public void minimizeEnd(BS bsBasis2, boolean isEnd) {
        if (this.minBasis == null) {
            return;
        }
        if (bsBasis2 != null) {
            P3[] pts = new P3[bsBasis2.cardinality()];
            int p = 0;
            int j = this.minBasis.nextSetBit(0);
            int i = bsBasis2.nextSetBit(0);
            while (i >= 0) {
                pts[p++] = P3.newP(this.vwr.ms.at[i].getXYZ());
                i = bsBasis2.nextSetBit(i + 1);
                j = this.minBasis.nextSetBit(j + 1);
            }
            BS bs = BSUtil.copy(this.minBasis);
            bs.andNot(this.minBasisFixed);
            this.cmdAssignMoveAtoms(bs, this.minBasisFixed, this.minBasisModelAtoms, this.minBasis.nextSetBit(0), null, pts, true);
        }
        if (isEnd) {
            this.clearMinimizationParameters();
        }
        this.vwr.refresh(1, "modelkit minimize");
    }

    private void clearMinimizationParameters() {
        this.minSelectionSaved = null;
        this.minBasis = null;
        this.minBasisFixed = null;
        this.minTempFixed = null;
        this.minTempModelAtoms = null;
        this.minBasisModelAtoms = null;
        this.minBasisAtoms = null;
        this.modelSyms = null;
        this.vwr.deleteModels(this.vwr.ms.mc - 1, null);
        this.vwr.setSelectionSet(this.minSelectionSaved);
        this.vwr.setCurrentModelIndex(this.minBasisModel);
    }

    private static class Constraint {
        public static final int TYPE_NONE = 0;
        public static final int TYPE_DISTANCE = 1;
        public static final int TYPE_ANGLE = 2;
        public static final int TYPE_DIHEDRAL = 3;
        public static final int TYPE_VECTOR = 4;
        public static final int TYPE_PLANE = 5;
        public static final int TYPE_LOCKED = 6;
        public static final int TYPE_GENERAL = 7;
        int type;
        private P3 pt;
        private P3 offset;
        private P4 plane;
        private V3 unitVector;
        private P3[] points;
        private double value;

        public Constraint(P3 pt, int type, Object[] params) throws IllegalArgumentException {
            this.pt = pt;
            this.type = type;
            switch (type) {
                case 0: 
                case 6: 
                case 7: {
                    break;
                }
                case 4: {
                    this.offset = (P3)params[0];
                    this.unitVector = V3.newV((T3)params[1]);
                    this.unitVector.normalize();
                    break;
                }
                case 5: {
                    this.plane = (P4)params[0];
                    break;
                }
                case 1: {
                    this.value = (Double)params[0];
                    this.points = new P3[]{(P3)params[1], null};
                    break;
                }
                case 2: {
                    this.value = (Double)params[0];
                    this.points = new P3[]{(P3)params[1], (P3)params[2], null};
                    break;
                }
                case 3: {
                    this.value = (Double)params[0];
                    this.points = new P3[]{(P3)params[1], (P3)params[2], (P3)params[3], null};
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }

        public void constrain(P3 ptOld, P3 ptNew, boolean allowProjection) {
            V3 v = new V3();
            P3 p = P3.newP(ptOld);
            float d = 0.0f;
            switch (this.type) {
                case 0: {
                    return;
                }
                case 7: {
                    return;
                }
                case 6: {
                    ptNew.x = Float.NaN;
                    return;
                }
                case 4: {
                    if (this.pt == null && (d = Measure.projectOntoAxis(p, this.offset, this.unitVector, v)) * d >= 1.96E-6f) {
                        ptNew.x = Float.NaN;
                        return;
                    }
                    d = Measure.projectOntoAxis(ptNew, this.offset, this.unitVector, v);
                    break;
                }
                case 5: {
                    if (this.pt == null && Math.abs(Measure.getPlaneProjection(p, this.plane, v, v)) > 0.01f) {
                        ptNew.x = Float.NaN;
                        return;
                    }
                    d = Measure.getPlaneProjection(ptNew, this.plane, v, v);
                    ptNew.setT(v);
                }
            }
            if (!allowProjection && (double)Math.abs(d) > 1.0E-10) {
                ptNew.x = Float.NaN;
            }
        }
    }

    private static class WyckoffModulation
    extends Vibration {
        private Vibration oldVib;
        private Atom atom = null;
        private double t;
        private Atom baseAtom = null;
        private P3 pt0 = new P3();
        private P3 ptf = new P3();
        private SymmetryInterface sym;
        private Constraint c;
        private static final int wyckoffFactor = 10;

        private WyckoffModulation(SymmetryInterface sym, Constraint c, Atom atom, Atom baseAtom) {
            this.setType(-3);
            this.sym = sym;
            this.c = c;
            this.atom = atom;
            this.baseAtom = baseAtom;
            this.x = 1.0f;
        }

        @Override
        public T3 setCalcPoint(T3 pt, T3 t456, float scale, float modulationScale) {
            Vibration v = this.baseAtom.getVibrationVector();
            if (v == null || v.modDim != -3) {
                return pt;
            }
            WyckoffModulation wv = (WyckoffModulation)v;
            if (this.sym == null) {
                return pt;
            }
            M4 m = null;
            if (wv.atom != this.atom && (m = ModelKit.getTransform(this.sym, wv.atom, this.atom)) == null) {
                return pt;
            }
            if (wv.t != (double)t456.x && (int)(t456.x * 10.0f) % 2 == 0) {
                if (this.c.type != 6) {
                    wv.setPos(this.sym, this.c, scale);
                }
                wv.t = t456.x;
            }
            if (m == null) {
                pt.setT(wv.ptf);
            } else {
                m.rotTrans2(wv.ptf, pt);
            }
            this.sym.toCartesian(pt, false);
            return pt;
        }

        private void setPos(SymmetryInterface sym, Constraint c, double scale) {
            this.x = (float)((Math.random() - 0.5) / 10.0 * scale);
            this.y = (float)((Math.random() - 0.5) / 10.0 * scale);
            this.z = (float)((Math.random() - 0.5) / 10.0 * scale);
            this.pt0.setT(this.atom);
            this.ptf.setT(this.pt0);
            this.ptf.add(this);
            c.constrain(this.pt0, this.ptf, true);
            sym.toFractional(this.ptf, false);
        }

        static void setVibrationMode(ModelKit mk, Object value) {
            Atom[] atoms = mk.vwr.ms.at;
            BS bsAtoms = mk.vwr.getThisModelAtoms();
            if ("off".equals(value)) {
                int i = bsAtoms.nextSetBit(0);
                while (i >= 0) {
                    Vibration v = atoms[i].getVibrationVector();
                    if (v == null || v.modDim == -3) {
                        mk.vwr.ms.setVibrationVector(i, ((WyckoffModulation)v).oldVib);
                    }
                    i = bsAtoms.nextSetBit(i + 1);
                }
            } else if ("wyckoff".equals(value)) {
                int i = bsAtoms.nextSetBit(0);
                while (i >= 0) {
                    Vibration v = atoms[i].getVibrationVector();
                    if (v == null || v.modDim == -3) {
                        SymmetryInterface sym = mk.getSym(i);
                        WyckoffModulation wv = null;
                        if (sym != null) {
                            Constraint c = mk.setConstraint(sym, i, GET_CREATE);
                            if (c.type != 6) {
                                wv = new WyckoffModulation(sym, c, atoms[i], mk.getBasisAtom(i));
                            }
                        }
                        mk.vwr.ms.setVibrationVector(i, wv);
                    }
                    i = bsAtoms.nextSetBit(i + 1);
                }
            }
            mk.vwr.setVibrationPeriod(Float.NaN);
        }
    }
}

