/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.fop.afp.AFPImageObjectInfo;
import org.apache.fop.afp.AFPLineDataInfo;
import org.apache.fop.afp.AFPObjectAreaInfo;
import org.apache.fop.afp.AFPPaintingState;
import org.apache.fop.afp.AFPResourceLevel;
import org.apache.fop.afp.AFPResourceManager;
import org.apache.fop.afp.AFPUnitConverter;
import org.apache.fop.afp.AbstractAFPPainter;
import org.apache.fop.afp.DataStream;
import org.apache.fop.afp.PaintingInfo;
import org.apache.fop.afp.RectanglePaintingInfo;
import org.apache.fop.util.bitmap.BitmapImageUtil;
import org.apache.xmlgraphics.image.loader.ImageSize;
import org.apache.xmlgraphics.java2d.color.ColorWithAlternatives;

public class AFPRectanglePainter
extends AbstractAFPPainter {
    private AFPResourceManager resourceManager;

    public AFPRectanglePainter(AFPPaintingState paintingState, DataStream dataStream, AFPResourceManager resourceManager) {
        super(paintingState, dataStream);
        this.resourceManager = resourceManager;
    }

    @Override
    public void paint(PaintingInfo paintInfo) throws IOException {
        Color color = this.paintingState.getColor();
        if (color instanceof ColorWithAlternatives && color.getAlpha() != 255) {
            this.paintAlpha(paintInfo);
            return;
        }
        RectanglePaintingInfo rectanglePaintInfo = (RectanglePaintingInfo)paintInfo;
        int pageWidth = this.dataStream.getCurrentPage().getWidth();
        int pageHeight = this.dataStream.getCurrentPage().getHeight();
        AFPUnitConverter unitConv = this.paintingState.getUnitConverter();
        float width = unitConv.pt2units(rectanglePaintInfo.getWidth());
        float height = unitConv.pt2units(rectanglePaintInfo.getHeight());
        float x = unitConv.pt2units(rectanglePaintInfo.getX());
        float y = unitConv.pt2units(rectanglePaintInfo.getY());
        AffineTransform at = this.paintingState.getData().getTransform();
        AFPLineDataInfo lineDataInfo = new AFPLineDataInfo();
        lineDataInfo.setColor(this.paintingState.getColor());
        lineDataInfo.setRotation(this.paintingState.getRotation());
        lineDataInfo.setThickness(Math.round(height));
        switch (lineDataInfo.getRotation()) {
            case 90: {
                lineDataInfo.setX1(Math.round((float)at.getTranslateY() + x));
                int yNew = pageWidth - Math.round((float)at.getTranslateX()) + Math.round(y);
                lineDataInfo.setY1(yNew);
                lineDataInfo.setY2(yNew);
                lineDataInfo.setX2(Math.round(width + (float)at.getTranslateY() + x));
                break;
            }
            case 180: {
                lineDataInfo.setX1(pageWidth - Math.round((float)at.getTranslateX() - x));
                int yNew = pageHeight - Math.round((float)at.getTranslateY() - y);
                lineDataInfo.setY1(yNew);
                lineDataInfo.setY2(yNew);
                lineDataInfo.setX2(pageWidth - Math.round((float)at.getTranslateX() - x - width));
                break;
            }
            case 270: {
                lineDataInfo.setX1(pageHeight - Math.round((float)at.getTranslateY() - x));
                int yNew = Math.round((float)at.getTranslateX() + y);
                lineDataInfo.setY1(yNew);
                lineDataInfo.setY2(yNew);
                lineDataInfo.setX2(pageHeight - Math.round((float)at.getTranslateY() - x - width));
                break;
            }
            default: {
                lineDataInfo.setX1(Math.round((float)at.getTranslateX() + x));
                int yNew = Math.round((float)at.getTranslateY() + y);
                lineDataInfo.setY1(yNew);
                lineDataInfo.setY2(yNew);
                lineDataInfo.setX2(Math.round((float)at.getTranslateX() + x + width));
            }
        }
        this.dataStream.createLine(lineDataInfo);
    }

    private void paintAlpha(PaintingInfo paintInfo) throws IOException {
        RectanglePaintingInfo rectanglePaintInfo = (RectanglePaintingInfo)paintInfo;
        if (rectanglePaintInfo.getWidth() <= 0.0f || rectanglePaintInfo.getHeight() <= 0.0f) {
            return;
        }
        Dimension size = new Dimension((int)rectanglePaintInfo.getWidth(), (int)rectanglePaintInfo.getHeight());
        AFPImageObjectInfo imageObjectInfo = new AFPImageObjectInfo();
        imageObjectInfo.setMimeType("image/x-afp+fs45");
        imageObjectInfo.getResourceInfo().setLevel(new AFPResourceLevel(AFPResourceLevel.ResourceType.INLINE));
        imageObjectInfo.getResourceInfo().setImageDimension(size);
        imageObjectInfo.setColor(true);
        int width = size.width;
        int height = size.height;
        int resolution = this.paintingState.getResolution();
        ImageSize bitmapSize = new ImageSize(width, height, (double)resolution);
        imageObjectInfo.setDataHeightRes((int)Math.round(bitmapSize.getDpiHorizontal() * 10.0));
        imageObjectInfo.setDataWidthRes((int)Math.round(bitmapSize.getDpiVertical() * 10.0));
        imageObjectInfo.setDataWidth(width);
        imageObjectInfo.setDataHeight(height);
        Color color = this.paintingState.getColor();
        byte[] image = this.buildImage(color, width, height);
        imageObjectInfo.setData(image);
        if (color instanceof ColorWithAlternatives) {
            imageObjectInfo.setBitsPerPixel(32);
        } else {
            imageObjectInfo.setBitsPerPixel(24);
        }
        image = this.buildMaskImage(color, width, height);
        imageObjectInfo.setTransparencyMask(image);
        int rotation = this.paintingState.getRotation();
        AffineTransform at = this.paintingState.getData().getTransform();
        Point2D origin = at.transform(new Point2D.Float(rectanglePaintInfo.getX() * 1000.0f, rectanglePaintInfo.getY() * 1000.0f), null);
        AFPUnitConverter unitConv = this.paintingState.getUnitConverter();
        float widthf = unitConv.pt2units(rectanglePaintInfo.getWidth());
        float heightf = unitConv.pt2units(rectanglePaintInfo.getHeight());
        AFPObjectAreaInfo objectAreaInfo = new AFPObjectAreaInfo((int)Math.round(origin.getX()), (int)Math.round(origin.getY()), Math.round(widthf), Math.round(heightf), resolution, rotation);
        imageObjectInfo.setObjectAreaInfo(objectAreaInfo);
        this.resourceManager.createObject(imageObjectInfo);
    }

    private byte[] buildImage(Color color, int width, int height) {
        float[] components = color instanceof ColorWithAlternatives ? ((ColorWithAlternatives)color).getAlternativeColors()[0].getColorComponents(null) : color.getColorComponents(null);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                for (float component : components) {
                    bos.write((byte)(component *= 255.0f));
                }
            }
        }
        return bos.toByteArray();
    }

    private byte[] buildMaskImage(Color color, int width, int height) {
        BufferedImage bufferedImage = new BufferedImage(width, height, 2);
        Graphics graphics = bufferedImage.getGraphics();
        Color alpha = new Color(color.getAlpha(), color.getAlpha(), color.getAlpha());
        graphics.setColor(alpha);
        graphics.fillRect(0, 0, width, height);
        graphics.dispose();
        RenderedImage renderedImage = BitmapImageUtil.convertToMonochrome(bufferedImage, new Dimension(width, height), 1.0f);
        DataBufferByte bufferByte = (DataBufferByte)renderedImage.getData().getDataBuffer();
        return bufferByte.getData();
    }
}

