/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.math.BigInteger;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.joni.Regex;
import org.joni.WarnCallback;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyComplex;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.RubyRational;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CachingCallSite;

public class Numeric {
    public static final boolean CANON = true;
    private static final long SQRT_LONG_MAX = 0x80000000L;

    public static IRubyObject f_add(ThreadContext context, IRubyObject x, IRubyObject y) {
        CachingCallSite op_plus2 = Numeric.sites((ThreadContext)context).op_plus;
        if (op_plus2.isBuiltin(x)) {
            if (x instanceof RubyInteger) {
                if (Numeric.fixnumZero(x)) {
                    return y;
                }
                if (Numeric.fixnumZero(y)) {
                    return x;
                }
                return ((RubyInteger)x).op_plus(context, y);
            }
            if (x instanceof RubyFloat) {
                if (Numeric.fixnumZero(y)) {
                    return x;
                }
                return ((RubyFloat)x).op_plus(context, y);
            }
            if (x instanceof RubyRational) {
                if (Numeric.fixnumZero(y)) {
                    return x;
                }
                return ((RubyRational)x).op_plus(context, y);
            }
        }
        return op_plus2.call(context, x, x, y);
    }

    private static boolean fixnumZero(IRubyObject y) {
        return y instanceof RubyFixnum && ((RubyFixnum)y).getLongValue() == 0L;
    }

    private static boolean fixnumOne(IRubyObject y) {
        return y instanceof RubyFixnum && ((RubyFixnum)y).getLongValue() == 1L;
    }

    public static RubyInteger f_add(ThreadContext context, RubyInteger x, RubyInteger y) {
        return (RubyInteger)x.op_plus(context, y);
    }

    public static IRubyObject f_cmp(ThreadContext context, IRubyObject x, IRubyObject y) {
        if (x instanceof RubyInteger && y instanceof RubyInteger) {
            return Numeric.f_cmp(context, (RubyInteger)x, (RubyInteger)y);
        }
        return Numeric.sites((ThreadContext)context).op_cmp.call(context, x, x, y);
    }

    public static RubyFixnum f_cmp(ThreadContext context, RubyInteger x, RubyInteger y) {
        int cmp2 = x instanceof RubyFixnum && y instanceof RubyFixnum ? Long.compare(((RubyFixnum)x).getLongValue(), ((RubyFixnum)y).getLongValue()) : x.getBigIntegerValue().compareTo(y.getBigIntegerValue());
        return RubyFixnum.newFixnum(context.runtime, cmp2);
    }

    public static RubyFixnum f_cmp(ThreadContext context, RubyInteger x, long y) {
        int cmp2 = x instanceof RubyFixnum ? Long.compare(((RubyFixnum)x).getLongValue(), y) : x.getBigIntegerValue().compareTo(BigInteger.valueOf(y));
        return RubyFixnum.newFixnum(context.runtime, cmp2);
    }

    public static IRubyObject f_div(ThreadContext context, IRubyObject x, IRubyObject y) {
        if (y instanceof RubyFixnum && ((RubyFixnum)y).getLongValue() == 1L) {
            return x;
        }
        return Numeric.sites((ThreadContext)context).op_quo.call(context, x, x, y);
    }

    public static boolean f_gt_p(ThreadContext context, IRubyObject x, IRubyObject y) {
        if (x instanceof RubyFixnum && y instanceof RubyFixnum) {
            return ((RubyFixnum)x).getLongValue() > ((RubyFixnum)y).getLongValue();
        }
        return Numeric.sites((ThreadContext)context).op_gt.call(context, x, x, y).isTrue();
    }

    public static boolean f_gt_p(ThreadContext context, RubyInteger x, RubyInteger y) {
        if (x instanceof RubyFixnum && y instanceof RubyFixnum) {
            return ((RubyFixnum)x).getLongValue() > ((RubyFixnum)y).getLongValue();
        }
        return x.getBigIntegerValue().compareTo(y.getBigIntegerValue()) > 0;
    }

    public static boolean f_lt_p(ThreadContext context, IRubyObject x, IRubyObject y) {
        if (x instanceof RubyFixnum && y instanceof RubyFixnum) {
            return ((RubyFixnum)x).getLongValue() < ((RubyFixnum)y).getLongValue();
        }
        return Numeric.sites((ThreadContext)context).op_lt.call(context, x, x, y).isTrue();
    }

    public static boolean f_lt_p(ThreadContext context, RubyInteger x, RubyInteger y) {
        if (x instanceof RubyFixnum && y instanceof RubyFixnum) {
            return ((RubyFixnum)x).getLongValue() < ((RubyFixnum)y).getLongValue();
        }
        return x.getBigIntegerValue().compareTo(y.getBigIntegerValue()) < 0;
    }

    public static IRubyObject f_mod(ThreadContext context, IRubyObject x, IRubyObject y) {
        return Numeric.sites((ThreadContext)context).op_mod.call(context, x, x, y);
    }

    public static IRubyObject f_mul(ThreadContext context, IRubyObject x, IRubyObject y) {
        CachingCallSite op_times2 = Numeric.sites((ThreadContext)context).op_times;
        if (op_times2.isBuiltin(x)) {
            if (x instanceof RubyInteger) {
                if (Numeric.fixnumZero(y)) {
                    return y;
                }
                if (Numeric.fixnumZero(x) && y instanceof RubyInteger) {
                    return x;
                }
                if (Numeric.fixnumOne(x)) {
                    return y;
                }
                if (Numeric.fixnumOne(y)) {
                    return x;
                }
                return ((RubyInteger)x).op_mul(context, y);
            }
            if (x instanceof RubyFloat) {
                if (Numeric.fixnumOne(y)) {
                    return x;
                }
                return ((RubyFloat)x).op_mul(context, y);
            }
            if (x instanceof RubyRational) {
                if (Numeric.fixnumOne(y)) {
                    return x;
                }
                return ((RubyRational)x).op_mul(context, y);
            }
            if (Numeric.fixnumOne(y)) {
                return x;
            }
        }
        return op_times2.call(context, x, x, y);
    }

    public static RubyInteger f_mul(ThreadContext context, RubyInteger x, RubyInteger y) {
        return (RubyInteger)x.op_mul(context, y);
    }

    public static IRubyObject safe_mul(ThreadContext context, IRubyObject a, IRubyObject b2, boolean az, boolean bz) {
        double v;
        Ruby runtime2 = context.runtime;
        if (!az && bz && a instanceof RubyFloat && !Double.isNaN(v = ((RubyFloat)a).getDoubleValue())) {
            IRubyObject iRubyObject = a = v < 0.0 ? runtime2.newFloat(-1.0) : runtime2.newFloat(1.0);
        }
        if (!bz && az && b2 instanceof RubyFloat && !Double.isNaN(v = ((RubyFloat)b2).getDoubleValue())) {
            b2 = v < 0.0 ? runtime2.newFloat(-1.0) : runtime2.newFloat(1.0);
        }
        return Numeric.f_mul(context, a, b2);
    }

    public static IRubyObject f_sub(ThreadContext context, IRubyObject x, IRubyObject y) {
        CachingCallSite op_minus2 = Numeric.sites((ThreadContext)context).op_minus;
        if (op_minus2.isBuiltin(x) && Numeric.fixnumZero(y)) {
            return x;
        }
        return op_minus2.call(context, x, x, y);
    }

    public static RubyInteger f_sub(ThreadContext context, RubyInteger x, RubyInteger y) {
        return (RubyInteger)x.op_minus(context, y);
    }

    public static IRubyObject f_xor(ThreadContext context, IRubyObject x, IRubyObject y) {
        return Numeric.sites((ThreadContext)context).op_xor.call(context, x, x, y);
    }

    public static IRubyObject f_xor(ThreadContext context, RubyInteger x, RubyInteger y) {
        return x.op_xor(context, y);
    }

    public static IRubyObject f_abs(ThreadContext context, IRubyObject x) {
        return Numeric.sites((ThreadContext)context).abs.call(context, x, x);
    }

    public static RubyInteger f_abs(ThreadContext context, RubyInteger x) {
        return (RubyInteger)x.abs(context);
    }

    public static RubyFloat f_abs(ThreadContext context, RubyFloat x) {
        return (RubyFloat)x.abs(context);
    }

    public static IRubyObject f_abs2(ThreadContext context, IRubyObject x) {
        return Numeric.sites((ThreadContext)context).abs2.call(context, x, x);
    }

    public static IRubyObject f_arg(ThreadContext context, IRubyObject x) {
        return Numeric.sites((ThreadContext)context).arg.call(context, x, x);
    }

    public static IRubyObject f_conjugate(ThreadContext context, IRubyObject x) {
        return Numeric.sites((ThreadContext)context).conjugate.call(context, x, x);
    }

    public static IRubyObject f_denominator(ThreadContext context, IRubyObject x) {
        return Numeric.sites((ThreadContext)context).denominator.call(context, x, x);
    }

    public static boolean f_exact_p(ThreadContext context, IRubyObject x) {
        return Numeric.sites((ThreadContext)context).exact.call(context, x, x).isTrue();
    }

    public static IRubyObject f_numerator(ThreadContext context, IRubyObject x) {
        return Numeric.sites((ThreadContext)context).numerator.call(context, x, x);
    }

    public static IRubyObject f_polar(ThreadContext context, IRubyObject x) {
        return Numeric.sites((ThreadContext)context).polar.call(context, x, x);
    }

    public static boolean f_real_p(ThreadContext context, IRubyObject x) {
        switch (x.getMetaClass().getClassIndex()) {
            case FLOAT: 
            case FIXNUM: 
            case BIGNUM: 
            case RATIONAL: {
                return ((RubyNumeric)x).isReal();
            }
            case COMPLEX: {
                return Numeric.f_zero_p(context, ((RubyComplex)x).image());
            }
        }
        return Numeric.sites((ThreadContext)context).real.call(context, x, x).isTrue();
    }

    public static boolean f_integer_p(ThreadContext context, IRubyObject x) {
        return Numeric.sites((ThreadContext)context).integer.call(context, x, x).isTrue();
    }

    public static boolean f_integer_p(ThreadContext context, RubyNumeric x) {
        switch (x.getMetaClass().getClassIndex()) {
            case FIXNUM: 
            case BIGNUM: {
                return true;
            }
            case FLOAT: 
            case RATIONAL: 
            case COMPLEX: {
                return false;
            }
        }
        return Numeric.sites((ThreadContext)context).integer.call(context, x, x).isTrue();
    }

    public static IRubyObject f_divmod(ThreadContext context, IRubyObject x, IRubyObject y) {
        return Numeric.sites((ThreadContext)context).divmod.call(context, x, x, y);
    }

    public static IRubyObject f_divmod(ThreadContext context, RubyInteger x, IRubyObject y) {
        return x.divmod(context, y);
    }

    public static IRubyObject f_floor(ThreadContext context, IRubyObject x) {
        return Numeric.sites((ThreadContext)context).floor.call(context, x, x);
    }

    public static IRubyObject f_inspect(ThreadContext context, IRubyObject x) {
        return Numeric.sites((ThreadContext)context).inspect.call(context, x, x);
    }

    public static IRubyObject f_negate(ThreadContext context, IRubyObject x) {
        return Numeric.sites((ThreadContext)context).op_uminus.call(context, x, x);
    }

    public static RubyInteger f_negate(ThreadContext context, RubyInteger x) {
        return x.negate();
    }

    public static IRubyObject f_to_f(ThreadContext context, IRubyObject x) {
        return Numeric.sites((ThreadContext)context).to_f.call(context, x, x);
    }

    public static IRubyObject f_to_i(ThreadContext context, IRubyObject x) {
        return Numeric.sites((ThreadContext)context).to_i.call(context, x, x);
    }

    public static IRubyObject f_to_r(ThreadContext context, IRubyObject x) {
        return Numeric.sites((ThreadContext)context).to_r.call(context, x, x);
    }

    public static RubyNumeric f_to_r(ThreadContext context, RubyInteger x) {
        return (RubyNumeric)x.to_r(context);
    }

    public static IRubyObject f_to_s(ThreadContext context, IRubyObject x) {
        return Numeric.sites((ThreadContext)context).to_s.call(context, x, x);
    }

    public static IRubyObject f_truncate(ThreadContext context, IRubyObject x) {
        return Numeric.sites((ThreadContext)context).truncate.call(context, x, x);
    }

    public static IRubyObject f_equal(ThreadContext context, IRubyObject x, IRubyObject y) {
        if (x instanceof RubyFixnum && y instanceof RubyFixnum) {
            return RubyBoolean.newBoolean(context, ((RubyFixnum)x).getLongValue() == ((RubyFixnum)y).getLongValue());
        }
        return Numeric.sites((ThreadContext)context).op_equals.call(context, x, x, y);
    }

    public static IRubyObject f_equal(ThreadContext context, RubyInteger x, RubyInteger y) {
        return x.op_equal(context, y);
    }

    public static IRubyObject f_expt(ThreadContext context, IRubyObject x, IRubyObject y) {
        return Numeric.sites((ThreadContext)context).op_exp.call(context, x, x, y);
    }

    public static RubyNumeric f_expt(ThreadContext context, RubyInteger x, RubyInteger y) {
        return (RubyNumeric)x.op_pow(context, y);
    }

    public static IRubyObject f_idiv(ThreadContext context, IRubyObject x, IRubyObject y) {
        return Numeric.sites((ThreadContext)context).div.call(context, x, x, y);
    }

    public static RubyInteger f_idiv(ThreadContext context, RubyInteger x, RubyInteger y) {
        return (RubyInteger)x.idiv(context, y);
    }

    public static IRubyObject f_quo(ThreadContext context, IRubyObject x, IRubyObject y) {
        return Numeric.sites((ThreadContext)context).quo.call(context, x, x, y);
    }

    public static IRubyObject f_quo(ThreadContext context, RubyFloat x, RubyFloat y) {
        return x.quo(context, y);
    }

    public static IRubyObject f_reciprocal(ThreadContext context, IRubyObject x) {
        return Numeric.f_quo(context, RubyFixnum.one(context.runtime), x);
    }

    public static IRubyObject f_rshift(ThreadContext context, IRubyObject x, IRubyObject y) {
        return Numeric.sites((ThreadContext)context).op_rshift.call(context, x, x, y);
    }

    public static IRubyObject f_lshift(ThreadContext context, IRubyObject x, IRubyObject y) {
        return Numeric.sites((ThreadContext)context).op_lshift.call(context, x, x, y);
    }

    public static boolean f_negative_p(ThreadContext context, IRubyObject x) {
        if (x instanceof RubyInteger) {
            return ((RubyInteger)x).signum() == -1;
        }
        return Numeric.sites((ThreadContext)context).op_lt.call(context, x, x, (IRubyObject)RubyFixnum.zero(context.runtime)).isTrue();
    }

    public static boolean f_negative_p(ThreadContext context, RubyInteger x) {
        return x.signum() == -1;
    }

    public static boolean f_negative_p(ThreadContext context, RubyFloat x) {
        return x.signum() == -1;
    }

    public static boolean f_zero_p(ThreadContext context, IRubyObject x) {
        if (x instanceof RubyInteger) {
            return ((RubyInteger)x).isZero();
        }
        if (x instanceof RubyFloat) {
            return ((RubyFloat)x).signum() == 0;
        }
        return Numeric.sites((ThreadContext)context).op_equals.call(context, x, x, (IRubyObject)RubyFixnum.zero(context.runtime)).isTrue();
    }

    public static boolean f_zero_p(ThreadContext context, RubyInteger x) {
        return x.isZero();
    }

    public static boolean f_one_p(ThreadContext context, IRubyObject x) {
        if (x instanceof RubyFixnum) {
            return ((RubyFixnum)x).getLongValue() == 1L;
        }
        return Numeric.sites((ThreadContext)context).op_equals.call(context, x, x, (IRubyObject)RubyFixnum.one(context.runtime)).isTrue();
    }

    public static boolean f_minus_one_p(ThreadContext context, IRubyObject x) {
        if (x instanceof RubyFixnum) {
            return ((RubyFixnum)x).getLongValue() == -1L;
        }
        return Numeric.sites((ThreadContext)context).op_equals.call(context, x, x, (IRubyObject)RubyFixnum.minus_one(context.runtime)).isTrue();
    }

    public static boolean f_odd_p(ThreadContext context, IRubyObject i2) {
        if (i2 instanceof RubyFixnum) {
            return ((RubyFixnum)i2).getLongValue() % 2L != 0L;
        }
        RubyFixnum two = RubyFixnum.two(context.runtime);
        return ((RubyFixnum)Numeric.sites((ThreadContext)context).op_mod.call(context, i2, i2, (IRubyObject)two)).getLongValue() != 0L;
    }

    public static long i_gcd(long x, long y) {
        if (x == Long.MIN_VALUE) {
            if (y == Long.MIN_VALUE) {
                return x;
            }
            return 1L << Long.numberOfTrailingZeros(Math.abs(y));
        }
        if (y == Long.MIN_VALUE) {
            return 1L << Long.numberOfTrailingZeros(Math.abs(x));
        }
        x = Math.abs(x);
        y = Math.abs(y);
        if (x == 0L) {
            return y;
        }
        if (y == 0L || x == y) {
            return x;
        }
        long uz = Long.numberOfTrailingZeros(x);
        long vz = Long.numberOfTrailingZeros(y);
        long shift2 = Math.min(uz, vz);
        x >>= (int)uz;
        y >>= (int)vz;
        while (x != y) {
            if (x > y) {
                x -= y;
                x >>= Long.numberOfTrailingZeros(x);
                continue;
            }
            y -= x;
            y >>= Long.numberOfTrailingZeros(y);
        }
        return x << (int)shift2;
    }

    public static IRubyObject f_gcd(ThreadContext context, IRubyObject x, IRubyObject y) {
        if (x instanceof RubyFixnum && y instanceof RubyFixnum && Numeric.isLongMinValue((RubyFixnum)x)) {
            return RubyFixnum.newFixnum(context.runtime, Numeric.i_gcd(((RubyFixnum)x).getLongValue(), ((RubyFixnum)y).getLongValue()));
        }
        if (Numeric.f_negative_p(context, x)) {
            x = Numeric.f_negate(context, x);
        }
        if (Numeric.f_negative_p(context, y)) {
            y = Numeric.f_negate(context, y);
        }
        if (Numeric.f_zero_p(context, x)) {
            return y;
        }
        if (Numeric.f_zero_p(context, y)) {
            return x;
        }
        while (!(x instanceof RubyFixnum && y instanceof RubyFixnum && Numeric.isLongMinValue((RubyFixnum)x))) {
            IRubyObject z = x;
            x = Numeric.f_mod(context, y, x);
            y = z;
        }
        return RubyFixnum.newFixnum(context.runtime, Numeric.i_gcd(((RubyFixnum)x).getLongValue(), ((RubyFixnum)y).getLongValue()));
    }

    public static RubyInteger f_gcd(ThreadContext context, RubyInteger x, RubyInteger y) {
        if (x instanceof RubyFixnum && y instanceof RubyFixnum && Numeric.isLongMinValue((RubyFixnum)x)) {
            return RubyFixnum.newFixnum(context.runtime, Numeric.i_gcd(x.getLongValue(), y.getLongValue()));
        }
        BigInteger gcd2 = x.getBigIntegerValue().gcd(y.getBigIntegerValue());
        if (gcd2.compareTo(RubyBignum.LONG_MAX) <= 0) {
            return RubyFixnum.newFixnum(context.runtime, gcd2.longValue());
        }
        return RubyBignum.newBignum(context.runtime, gcd2);
    }

    protected static boolean isLongMinValue(RubyFixnum x) {
        return x.getLongValue() != Long.MIN_VALUE;
    }

    public static IRubyObject f_lcm(ThreadContext context, IRubyObject x, IRubyObject y) {
        if (Numeric.f_zero_p(context, x) || Numeric.f_zero_p(context, y)) {
            return RubyFixnum.zero(context.runtime);
        }
        return Numeric.f_abs(context, Numeric.f_mul(context, Numeric.f_div(context, x, Numeric.f_gcd(context, x, y)), y));
    }

    public static long i_ilog2(ThreadContext context, IRubyObject x) {
        return Numeric.i_ilog2(context, x.convertToInteger());
    }

    public static long i_ilog2(ThreadContext context, RubyInteger x) {
        long q = (x.size(context).convertToInteger().getLongValue() - 8L) * 8L + 1L;
        if (q > 0L) {
            x = x.op_rshift(context, q);
        }
        long fx = x.getLongValue();
        long r = -1L;
        while (fx != 0L) {
            fx >>= 1;
            ++r;
        }
        return q + r;
    }

    public static double ldexp(double f, long e) {
        return f * Math.pow(2.0, e);
    }

    public static double frexp(double mantissa, long[] e) {
        int sign2 = 1;
        long exponent2 = 0L;
        if (Double.isInfinite(mantissa) || Double.isNaN(mantissa)) {
            return mantissa;
        }
        if (mantissa != 0.0) {
            if (mantissa < 0.0) {
                mantissa = -mantissa;
                sign2 = -1;
            }
            while (mantissa < 0.5) {
                mantissa *= 2.0;
                --exponent2;
            }
            while (mantissa >= 1.0) {
                mantissa *= 0.5;
                ++exponent2;
            }
        }
        e[0] = exponent2;
        return (double)sign2 * mantissa;
    }

    static boolean fitSqrtLong(long n) {
        return n < 0x80000000L && n >= Integer.MIN_VALUE;
    }

    public static RubyNumeric int_pow(ThreadContext context, long x, long y) {
        boolean neg = x < 0L;
        long z = 1L;
        if (neg) {
            x = -x;
        }
        if ((y & 1L) != 0L) {
            z = x;
        } else {
            neg = false;
        }
        y &= 0xFFFFFFFFFFFFFFFEL;
        Ruby runtime2 = context.runtime;
        while (true) {
            if (y % 2L == 0L) {
                if (!Numeric.fitSqrtLong(x)) {
                    IRubyObject v = RubyBignum.newBignum(runtime2, x).op_pow(context, y);
                    if (z != 1L) {
                        v = RubyBignum.newBignum(runtime2, neg ? -z : z).op_mul(context, v);
                    }
                    return (RubyNumeric)v;
                }
                x *= x;
                y >>= 1;
                continue;
            }
            if (Numeric.multiplyOverflows(x, z)) {
                IRubyObject v = RubyBignum.newBignum(runtime2, x).op_pow(context, y);
                if (z != 1L) {
                    v = RubyBignum.newBignum(runtime2, neg ? -z : z).op_mul(context, v);
                }
                return (RubyNumeric)v;
            }
            z = x * z;
            if (--y == 0L) break;
        }
        if (neg) {
            z = -z;
        }
        return RubyFixnum.newFixnum(runtime2, z);
    }

    public static IRubyObject num_pow(ThreadContext context, IRubyObject x, IRubyObject y) {
        if (x instanceof RubyInteger) {
            return ((RubyInteger)x).pow(context, y);
        }
        if (x instanceof RubyFloat) {
            return ((RubyFloat)x).op_pow(context, y);
        }
        if (x instanceof RubyComplex) {
            return ((RubyComplex)x).op_expt(context, y);
        }
        if (x instanceof RubyRational) {
            return ((RubyRational)x).op_expt(context, y);
        }
        return context.nil;
    }

    public static boolean multiplyOverflows(long a, long b2) {
        return a == 0L ? false : (a == -1L ? b2 < -9223372036854775807L : (a > 0L ? (b2 > 0L ? Long.MAX_VALUE / a < b2 : Long.MIN_VALUE / a > b2) : (b2 > 0L ? Long.MIN_VALUE / a < b2 : Long.MAX_VALUE / a > b2)));
    }

    public static boolean k_exact_p(IRubyObject x) {
        return !(x instanceof RubyFloat);
    }

    public static boolean k_inexact_p(IRubyObject x) {
        return x instanceof RubyFloat;
    }

    public static boolean k_integer_p(IRubyObject x) {
        return x instanceof RubyInteger;
    }

    public static boolean k_numeric_p(IRubyObject x) {
        return x instanceof RubyNumeric;
    }

    public static long rotl(long bits, int rot) {
        return bits << (rot & 0x3F) | bits >>> (-rot & 0x3F);
    }

    public static long rotr(long bits, int rot) {
        return bits << (-rot & 0x3F) | bits >>> (rot & 0x3F);
    }

    public static IRubyObject[] nurat_rationalize_internal(ThreadContext context, IRubyObject a, IRubyObject b2) {
        IRubyObject c;
        RubyFixnum q0;
        IRubyObject q1;
        RubyFixnum zero = RubyFixnum.zero(context.runtime);
        RubyFixnum one = RubyFixnum.one(context.runtime);
        RubyFixnum p0 = q1 = zero;
        IRubyObject p1 = q0 = one;
        while (!Numeric.f_lt_p(context, c = Numeric.sites((ThreadContext)context).ceil.call(context, a, a), b2)) {
            IRubyObject k = Numeric.f_sub(context, c, (IRubyObject)one);
            IRubyObject p2 = Numeric.f_add(context, Numeric.f_mul(context, k, p1), (IRubyObject)p0);
            IRubyObject q2 = Numeric.f_add(context, Numeric.f_mul(context, k, q1), (IRubyObject)q0);
            IRubyObject t = Numeric.f_quo(context, one, Numeric.f_sub(context, b2, k));
            b2 = Numeric.f_quo(context, one, Numeric.f_sub(context, a, k));
            a = t;
            p0 = p1;
            q0 = q1;
            p1 = p2;
            q1 = q2;
        }
        IRubyObject p2 = Numeric.f_add(context, Numeric.f_mul(context, c, p1), (IRubyObject)p0);
        IRubyObject q = Numeric.f_add(context, Numeric.f_mul(context, c, q1), (IRubyObject)q0);
        return new IRubyObject[]{p2, q};
    }

    public static IRubyObject[] nurat_rationalize_internal(ThreadContext context, IRubyObject[] ary) {
        return Numeric.nurat_rationalize_internal(context, ary[0], ary[1]);
    }

    public static void checkInteger(ThreadContext context, IRubyObject obj) {
        if (!(obj instanceof RubyInteger)) {
            throw context.runtime.newTypeError("not an integer");
        }
    }

    private static JavaSites.NumericSites sites(ThreadContext context) {
        return context.sites.Numeric;
    }

    public static final class RationalPatterns {
        public static final Regex rat_pat;
        public static final Regex an_e_pat;

        static {
            String WS = "\\s*";
            String DIGITS = "(?:\\d(?:_\\d|\\d)*)";
            String NUMERATOR = "(?:" + DIGITS + "?\\.)?" + DIGITS + "(?:[eE][-+]?" + DIGITS + ")?";
            String DENOMINATOR = "(?:" + DIGITS + "?\\.)?" + DIGITS + "(?:[eE][-+]?" + DIGITS + ")?";
            String PATTERN = "\\A" + WS + "([-+])?(" + NUMERATOR + ")(?:\\/(" + DENOMINATOR + "))?" + WS;
            rat_pat = new Regex(PATTERN.getBytes(), 0, PATTERN.length(), 0, (Encoding)ASCIIEncoding.INSTANCE, WarnCallback.NONE);
            an_e_pat = new Regex("[Ee]".getBytes(), 0, 4, 0, (Encoding)ASCIIEncoding.INSTANCE, WarnCallback.NONE);
        }
    }

    public static final class ComplexPatterns {
        public static final Regex comp_pat0;
        public static final Regex comp_pat1;
        public static final Regex comp_pat2;
        public static final Regex underscores_pat;

        static {
            String WS = "\\s*";
            String DIGITS = "(?:\\d(?:_\\d|\\d)*)";
            String NUMERATOR = "(?:" + DIGITS + "?\\.)?" + DIGITS + "(?:[eE][-+]?" + DIGITS + ")?";
            String DENOMINATOR = DIGITS;
            String NUMBER = "[-+]?" + NUMERATOR + "(?:\\/" + DENOMINATOR + ")?";
            String NUMBERNOS = NUMERATOR + "(?:\\/" + DENOMINATOR + ")?";
            String PATTERN0 = "\\A" + WS + "(" + NUMBER + ")@(" + NUMBER + ")" + WS;
            String PATTERN1 = "\\A" + WS + "([-+])?(" + NUMBER + ")?[iIjJ]" + WS;
            String PATTERN2 = "\\A" + WS + "(" + NUMBER + ")(([-+])(" + NUMBERNOS + ")?[iIjJ])?" + WS;
            comp_pat0 = new Regex(PATTERN0.getBytes(), 0, PATTERN0.length(), 0, (Encoding)ASCIIEncoding.INSTANCE, WarnCallback.NONE);
            comp_pat1 = new Regex(PATTERN1.getBytes(), 0, PATTERN1.length(), 0, (Encoding)ASCIIEncoding.INSTANCE, WarnCallback.NONE);
            comp_pat2 = new Regex(PATTERN2.getBytes(), 0, PATTERN2.length(), 0, (Encoding)ASCIIEncoding.INSTANCE, WarnCallback.NONE);
            underscores_pat = new Regex("_+".getBytes(), 0, 2, 0, (Encoding)ASCIIEncoding.INSTANCE, WarnCallback.NONE);
        }
    }
}

