/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.ir.attributes;

import com.strobel.annotations.NotNull;
import com.strobel.assembler.ir.attributes.SignatureAttribute;
import com.strobel.assembler.ir.attributes.SourceAttribute;
import com.strobel.assembler.metadata.MetadataParser;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.VerifyArgument;
import java.util.List;
import java.util.Objects;

public final class RecordComponentInfo {
    private final String _name;
    private final String _descriptor;
    private final TypeReference _type;
    private final List<SourceAttribute> _attributes;
    private TypeReference _resolvedType;

    public RecordComponentInfo(String name, String descriptor, TypeReference type, List<SourceAttribute> attributes) {
        this._name = VerifyArgument.notNull(name, "name");
        this._descriptor = VerifyArgument.notNull(descriptor, "descriptor");
        this._type = VerifyArgument.notNull(type, "type");
        this._attributes = VerifyArgument.notNull(attributes, "attributes");
    }

    @NotNull
    public String getName() {
        return this._name;
    }

    @NotNull
    public String getDescriptor() {
        return this._descriptor;
    }

    @NotNull
    public TypeReference getType() {
        return this._type;
    }

    @NotNull
    public TypeReference getResolvedType() {
        TypeReference type = this._resolvedType;
        return type != null ? type : this._type;
    }

    @NotNull
    public TypeReference resolveType(TypeReference recordType) {
        Objects.requireNonNull(recordType, "A record type is required.");
        TypeReference r = this._resolvedType;
        if (r != null) {
            return r;
        }
        SignatureAttribute signature = (SignatureAttribute)SourceAttribute.find("Signature", this._attributes);
        if (signature == null) {
            return this._type;
        }
        TypeDefinition rr = recordType.resolve();
        if (rr != null) {
            r = new MetadataParser(rr).parseTypeSignature(signature.getSignature());
        }
        this._resolvedType = r;
        return r != null ? r : this._type;
    }

    @NotNull
    public List<SourceAttribute> getAttributes() {
        return this._attributes;
    }
}

