package Lire::Config::SelectSpec;

use strict;

=pod

=head1 Lire::Config::SelectSpec

Type that represents a choice. Values of this type can have one from a
set of possible choices.

The these values are normalized to the case specified in the options'
specification.

=cut

use base qw/Lire::Config::CompoundSpec/;

use Lire::Config::Scalar;
use Lire::Utils qw/ check_param check_object_param /;

sub instance_class {
    return 'Lire::Config::Scalar';
}

=pod

=head2 options()

Returns as an array the valid options for this select.

=cut

sub options {
    return $_[0]->components();
}

sub add {
    my ( $self, $option ) = @_;

    check_object_param( $option, 'option', 'Lire::Config::OptionSpec' );

    $self->SUPER::add( $option );

    return;
}

sub is_valid {
    my ( $self, $value ) = @_;

    return !$self->required() unless defined $value;

    return defined $self->normalize( $value );
}

sub normalize {
    my ( $self, $value ) = @_;

    return undef unless defined $value;

    foreach my $o ( $self->options() ) {
        return $o->name() if $o->is_option( $value );
    }

    return undef;
}

1;
__END__

=pod

=head1 VERSION

$Id: SelectSpec.pm,v 1.6 2006/07/23 13:16:30 vanbaal Exp $

=head1 AUTHORS

Francis J. Lacoste <flacoste@logreport.org>
Wessel Dankers <wsl@logreport.org>
Wolfgang Sourdeau <wolfgang@logreport.org>

=head1 COPYRIGHT

Copyright (C) 2002-2004  Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html.

=cut
