/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.analysis;

import java.util.Arrays;
import java.util.Optional;
import lombok.Generated;
import org.opensearch.sql.analysis.AnalysisContext;
import org.opensearch.sql.analysis.symbol.Namespace;
import org.opensearch.sql.analysis.symbol.Symbol;
import org.opensearch.sql.ast.expression.QualifiedName;
import org.opensearch.sql.common.antlr.SyntaxCheckException;
import org.opensearch.sql.exception.SemanticCheckException;

public class QualifierAnalyzer {
    private final AnalysisContext context;

    public String unqualified(String ... parts) {
        return this.unqualified(QualifiedName.of(Arrays.asList(parts)));
    }

    public String unqualified(QualifiedName fullName) {
        return this.isQualifierIndexOrAlias(fullName) ? fullName.rest().toString() : fullName.toString();
    }

    private boolean isQualifierIndexOrAlias(QualifiedName fullName) {
        Optional<String> qualifier = fullName.first();
        if (qualifier.isPresent()) {
            if (this.isFieldName(qualifier.get())) {
                return false;
            }
            this.resolveQualifierSymbol(fullName, qualifier.get());
            return true;
        }
        return false;
    }

    private boolean isFieldName(String qualifier) {
        try {
            this.context.peek().resolve(new Symbol(Namespace.FIELD_NAME, qualifier));
            return true;
        }
        catch (SemanticCheckException e2) {
            return false;
        }
    }

    private void resolveQualifierSymbol(QualifiedName fullName, String qualifier) {
        try {
            this.context.peek().resolve(new Symbol(Namespace.INDEX_NAME, qualifier));
        }
        catch (SemanticCheckException e) {
            throw new SyntaxCheckException(String.format("The qualifier [%s] of qualified name [%s] must be an field name, index name or its alias", qualifier, fullName));
        }
    }

    @Generated
    public QualifierAnalyzer(AnalysisContext context) {
        this.context = context;
    }
}

